/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.users.QUser;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.CustomWizardExecutionStorage;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.notifications.MailHandlerImplementor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncompleteWizardRegistrationNotifyingBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private MailHandlerImplementor mailHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private CustomWizardServiceLocal customWizardService;

    public static BackgroundTaskScheduling scheduling(CustomWizardExecution customWizardExecution) throws JsonProcessingException {
        CustomWizardExecutionStorage customWizardExecutionStorage = (CustomWizardExecutionStorage)customWizardExecution.getStorage();
        return new BackgroundTaskScheduling(IncompleteWizardRegistrationNotifyingBackgroundTask.class, (Object)customWizardExecution.getKey(), "Notifying on incomplete registration to " + customWizardExecutionStorage.getVerifiedEmail());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.NOTIFY_INCOMPLETE_REGISTRATIONS;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            CustomWizardExecution customWizardExecution = this.customWizardService.findExecution(string);
            return this.runInEntityNetwork((SimpleEntity)customWizardExecution, () -> this.process(customWizardExecution));
        });
    }

    @Override
    protected boolean shouldGenerateErrorLog() {
        return false;
    }

    private long process(CustomWizardExecution customWizardExecution) {
        QUser qUser = QUser.user;
        CustomWizardExecutionStorage customWizardExecutionStorage = this.customWizardService.storage(customWizardExecution);
        String string = customWizardExecutionStorage.getVerifiedEmail();
        if (string != null && ((DBQuery)this.from(new EntityPath[]{qUser}).where((Predicate)qUser.email.eq((Object)string))).hasEmptyResults()) {
            InvocationContext.ensure().addTransactionEndListener(true, bl -> {
                String string2 = this.configurationHandler.getAccessor(customWizardExecution.getNetwork()).getApplicationName();
                String string3 = this.translationHandler.message(SystemKeys.Wizards.INCOMPLETE_REGISTRATION_NOTIFICATION_SUBJECT, new Object[]{string2});
                String string4 = this.translationHandler.message(MessageFormat.HTML, SystemKeys.Wizards.INCOMPLETE_REGISTRATION_NOTIFICATION_BODY, new Object[]{string2, this.linkGeneratorHandler.customWizardExecution(customWizardExecution, customWizardExecutionStorage)});
                this.mailHandler.send(customWizardExecution.getPrincipal(), string, string3, string4, new FileInfo[0]);
            });
            return 1L;
        }
        return 0L;
    }
}

