/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.notifications.MailHandlerImplementor;
import org.cyclos.impl.utils.notifications.MailProcessingContext;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Component;

@Component
public class MailProcessingBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private MailHandlerImplementor mailHandler;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;

    public static BackgroundTaskScheduling scheduling(ObjectMapper objectMapper, MailProcessingContext mailProcessingContext) throws JsonProcessingException {
        String string = objectMapper.writeValueAsString((Object)mailProcessingContext);
        return new BackgroundTaskScheduling(MailProcessingBackgroundTask.class, (Object)string, "Sending of e-mail to " + mailProcessingContext.getToEmail());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.SEND_EMAIL;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        try {
            MailProcessingContext mailProcessingContext = (MailProcessingContext)this.jacksonConfiguration.getObjectMapper().readValue(string, MailProcessingContext.class);
            return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                Network network = mailProcessingContext.getNetworkId() == null ? null : this.find(Network.class, mailProcessingContext.getNetworkId());
                this.runInNetwork(network, () -> {
                    this.process(mailProcessingContext);
                    return null;
                });
                return 1L;
            });
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalArgumentException("Error parsing pending email from JSON", jsonProcessingException);
        }
    }

    @Override
    protected boolean shouldGenerateErrorLog() {
        return false;
    }

    private void process(MailProcessingContext mailProcessingContext) {
        Configuration configuration = this.find(Configuration.class, mailProcessingContext.getConfigurationId());
        JavaMailSender javaMailSender = this.mailHandler.getMailSender(configuration);
        InvocationContext.ensure().addTransactionEndListener(false, bl -> this.mailHandler.sendNow(mailProcessingContext, javaMailSender));
    }
}

