/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Date;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.marketplace.AdQuestion;
import org.cyclos.entities.marketplace.Advertisement;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeneralReference;
import org.cyclos.entities.users.Reference;
import org.cyclos.entities.users.TransactionFeedback;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.utils.formatting.FormattedDate;
import org.cyclos.impl.utils.notifications.DateFormat;
import org.cyclos.impl.utils.notifications.NotificationDateFormat;
import org.cyclos.impl.utils.notifications.NotificationHandlerImpl;
import org.cyclos.impl.utils.notifications.NotificationHandlerImplementor;
import org.cyclos.impl.utils.notifications.NotificationURL;
import org.cyclos.impl.utils.notifications.OfAmount;
import org.cyclos.impl.utils.notifications.TransactionNumber;
import org.cyclos.impl.utils.notifications.UserNotificationMapping;
import org.cyclos.impl.utils.notifications.UserNotificationsHandlerAccessor;
import org.cyclos.impl.utils.notifications.WithDescription;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notifications.BrokeringNotificationType;
import org.cyclos.model.messaging.notifications.FeedbackAndReferenceNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceBuyerNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceSellerNotificationType;
import org.cyclos.model.messaging.notifications.PersonalNotificationType;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;

public class NotificationsHandlerAccessorInvocationHandlerImpl
implements InvocationHandler {
    private BasicUser user;
    private TranslationHandler translationHandler;
    private InvokerHandler invokerHandler;
    private NotificationHandlerImplementor notificationHandler;

    public NotificationsHandlerAccessorInvocationHandlerImpl(BasicUser basicUser, NotificationHandlerImpl notificationHandlerImpl, TranslationHandler translationHandler, InvokerHandler invokerHandler) {
        this.user = basicUser;
        this.notificationHandler = notificationHandlerImpl;
        this.translationHandler = translationHandler;
        this.invokerHandler = invokerHandler;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        UserNotificationType userNotificationType = UserNotificationMapping.getAnnotatedType((Method)method);
        if (userNotificationType == null) {
            if (method.getName().equals("toString") && objectArray.length == 0) {
                return "NotificationsHandlerProxy";
            }
            if (method.getName().equals("hashCode") && objectArray.length == 0) {
                return System.identityHashCode(object);
            }
            if (method.getName().equals("equals") && objectArray.length == 1) {
                return object == objectArray[0];
            }
            if (method.getDeclaringClass().equals(UserNotificationsHandlerAccessor.class)) {
                return object;
            }
            throw new IllegalStateException("Invoking a method in NotificationHandlerProxy without a proper notification type annotation");
        }
        if (CollectionHelper.isEmpty((Object[])objectArray) || !(objectArray[0] instanceof SimpleEntity)) {
            throw new IllegalStateException("Invoking a method in NotificationHandlerProxy without an entity as the first argument for notification type " + String.valueOf(userNotificationType));
        }
        this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)this.user), () -> {
            Pair<SimpleEntity, Object[]> pair = this.processArguments(method, objectArray);
            this.notify(userNotificationType, (SimpleEntity)pair.getFirst(), (Object[])pair.getSecond());
            return null;
        });
        return null;
    }

    private User getRelatedUser(UserNotificationType userNotificationType, SimpleEntity simpleEntity, Object[] objectArray) {
        if (ObjectHelper.isOneOf((Object)userNotificationType, (Object[])new Object[]{PersonalNotificationType.BROKER_ASSIGNED, PersonalNotificationType.BROKER_UNASSIGNED, BrokeringNotificationType.MEMBER_ASSIGNED, BrokeringNotificationType.MEMBER_UNASSIGNED})) {
            return this.relatedUser(simpleEntity) != null ? (User)simpleEntity : this.relatedUser(objectArray);
        }
        if (simpleEntity instanceof BasicAd) {
            BasicAd basicAd = (BasicAd)simpleEntity;
            return this.relatedUser(basicAd.getOwner());
        }
        if (simpleEntity instanceof AdQuestion) {
            AdQuestion adQuestion = (AdQuestion)simpleEntity;
            return this.relatedUser(adQuestion.getOwner(), adQuestion.getAd().getOwner());
        }
        if (simpleEntity instanceof Order) {
            Order order = (Order)simpleEntity;
            return this.relatedUser(order.getBuyer(), order.getSeller());
        }
        if (simpleEntity instanceof Reference) {
            Reference reference = (Reference)simpleEntity;
            return this.relatedUser(reference.getFrom(), reference.getTo());
        }
        if (simpleEntity instanceof Transaction || simpleEntity instanceof Installment) {
            Transaction transaction = simpleEntity instanceof Transaction ? (Transaction)simpleEntity : ((Installment)simpleEntity).getTransaction();
            return this.relatedUser(transaction.getFromUser(), transaction.getToUser());
        }
        if (simpleEntity instanceof Transfer) {
            Transfer transfer = (Transfer)simpleEntity;
            return this.relatedUser(transfer.getFromOwner(), transfer.getToOwner());
        }
        return null;
    }

    private NotificationURL getURL(UserNotificationType userNotificationType, SimpleEntity simpleEntity) {
        Location location = null;
        Long l = null;
        if (simpleEntity instanceof User) {
            location = userNotificationType == PersonalNotificationType.MAX_SMS_PER_MONTH_REACHED ? Location.NOTIFICATION_SETTING : Location.USER_PROFILE;
        } else if (simpleEntity instanceof BasicUser) {
            location = Location.USER_PROFILE;
        } else if (simpleEntity instanceof BasicAd) {
            location = userNotificationType == MarketplaceBuyerNotificationType.AD_QUESTION_ANSWERED ? Location.AD_QUESTION_ANSWERED : (userNotificationType == MarketplaceSellerNotificationType.ARTICLE_OUT_OF_STOCK || userNotificationType == MarketplaceSellerNotificationType.LOW_STOCK_QUANTITY ? Location.ORDER_STOCK : Location.ADVERTISEMENT);
        } else if (userNotificationType == MarketplaceSellerNotificationType.AD_QUESTION_CREATED) {
            AdQuestion adQuestion = (AdQuestion)simpleEntity;
            location = adQuestion.getAd() instanceof Advertisement ? Location.UNANSWERED_AD_QUESTION : Location.UNANSWERED_WEB_SHOP_QUESTION;
        } else if (simpleEntity instanceof Order) {
            location = Location.ORDER;
        } else if (simpleEntity instanceof Transfer) {
            location = Location.TRANSFER;
        } else if (simpleEntity instanceof Transaction) {
            location = userNotificationType instanceof FeedbackAndReferenceNotificationType ? Location.NEW_TRANSACTION_FEEDBACK : ((Transaction)simpleEntity).getLocation();
        } else if (simpleEntity instanceof Installment) {
            InternalTransaction internalTransaction = ((Installment)simpleEntity).getTransaction();
            simpleEntity = internalTransaction;
            location = internalTransaction.getLocation();
        } else if (simpleEntity instanceof Voucher) {
            location = Location.VOUCHER;
        } else if (simpleEntity instanceof VoucherTransaction) {
            location = Location.VOUCHER_TRANSACTION;
        } else if (simpleEntity instanceof TransactionFeedback) {
            location = Location.FEEDBACK;
            l = ((TransactionFeedback)simpleEntity).getTransaction().getId();
        } else if (simpleEntity instanceof GeneralReference) {
            location = Location.REFERENCE;
        } else if (simpleEntity instanceof PasswordType) {
            location = Location.PASSWORD;
        } else if (simpleEntity instanceof Token) {
            location = Location.TOKEN;
        } else if (simpleEntity instanceof UserAccount) {
            location = Location.ACCOUNT_HISTORY;
        }
        if (location == null) {
            return null;
        }
        return l == null ? new NotificationURL(location, simpleEntity) : new NotificationURL(location, simpleEntity, l);
    }

    private void notify(UserNotificationType userNotificationType, SimpleEntity simpleEntity, Object[] objectArray) {
        NotificationURL notificationURL = this.getURL(userNotificationType, simpleEntity);
        User user = this.getRelatedUser(userNotificationType, simpleEntity, objectArray);
        this.notificationHandler.notify(this.user, userNotificationType, notificationURL, simpleEntity, user, objectArray);
    }

    private Pair<SimpleEntity, Object[]> processArguments(Method method, Object[] objectArray) {
        Object[] objectArray2;
        Parameter[] parameterArray = method.getParameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            objectArray2 = parameterArray[i];
            if (objectArray2.isAnnotationPresent(DateFormat.class)) {
                NotificationDateFormat notificationDateFormat = objectArray2.getAnnotation(DateFormat.class).value();
                objectArray[i] = new FormattedDate((Date)objectArray[i], notificationDateFormat);
            }
            if (objectArray2.isAnnotationPresent(TransactionNumber.class)) {
                Object object = objectArray[i] = StringHelper.isBlank((Object)objectArray[i]) ? "" : this.translationHandler.message(MessagingKeys.Notifications.TRANSACTION_NUMBER, new Object[]{objectArray[i]});
            }
            if (objectArray2.isAnnotationPresent(WithDescription.class)) {
                Object object = objectArray[i] = StringHelper.isBlank((Object)objectArray[i]) ? "" : this.translationHandler.message(MessagingKeys.Notifications.WITH_DESCRIPTION, new Object[]{objectArray[i]});
            }
            if (!objectArray2.isAnnotationPresent(OfAmount.class)) continue;
            objectArray[i] = StringHelper.isBlank((Object)objectArray[i]) ? "" : this.translationHandler.message(MessagingKeys.Notifications.OF_AMOUNT, new Object[]{objectArray[i]});
        }
        SimpleEntity simpleEntity = (SimpleEntity)objectArray[0];
        objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        objectArray = objectArray2;
        return Pair.create((Object)simpleEntity, (Object)objectArray);
    }

    private User relatedUser(Object ... objectArray) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (!(object instanceof User) || object.equals(this.user.getUser())) continue;
                return (User)object;
            }
        }
        return null;
    }
}

