/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.persistence;

import com.querydsl.core.types.EntityPath;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAUpdateClause;
import javax.persistence.Cacheable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.BaseEntityManagerHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.UnexpectedDataAccessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public abstract class AbstractEntityManagerHandlerImpl
implements BaseEntityManagerHandler {
    @Autowired
    @Lazy
    protected NativeQueryHandler nativeQueryHandler;
    @Autowired
    protected EntityManagerFactory entityManagerFactory;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired(required=false)
    protected EntityManager entityManager;

    public void clear() {
        this.getEntityManager().clear();
    }

    public JPADeleteClause delete(EntityPath<?> entityPath) {
        return new JPADeleteClause(this.getEntityManager(), entityPath, this.nativeQueryHandler.getJpaQueryTemplates());
    }

    public void detach(IEntity iEntity) {
        this.getEntityManager().detach((Object)iEntity);
    }

    public <E extends IEntity> E find(Class<E> clazz, Long l) throws EntityNotFoundException {
        IEntity iEntity = null;
        if (l != null) {
            try {
                iEntity = (IEntity)this.getEntityManager().find(clazz, (Object)l);
            }
            catch (javax.persistence.EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        if (iEntity == null) {
            throw new EntityNotFoundException(clazz, l);
        }
        return (E)iEntity;
    }

    public void flush() {
        this.flush(this.getEntityManager());
    }

    public DBQuery<?> fromCacheable(EntityPath<?> entityPath) {
        DBQuery dBQuery = this.from(new EntityPath[]{entityPath});
        Class clazz = entityPath.getType();
        Table table = null;
        Cacheable cacheable = null;
        while (!(table != null && cacheable != null || Object.class.equals((Object)clazz))) {
            if (table == null) {
                table = clazz.getAnnotation(Table.class);
            }
            if (cacheable == null && (cacheable = clazz.getAnnotation(Cacheable.class)) != null && !cacheable.value()) {
                cacheable = null;
                break;
            }
            clazz = clazz.getSuperclass();
        }
        if (table == null || cacheable == null) {
            throw new IllegalStateException("Not a cacheable entity " + entityPath.getType().getSimpleName());
        }
        dBQuery.setHint("eclipselink.sql.hint", (Object)("/* table: " + table.name() + " */"));
        return dBQuery;
    }

    public EntityManager getEntityManager() {
        if (this.entityManager != null) {
            return this.entityManager;
        }
        return EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public final void persist(IEntity iEntity) {
        this.persist(iEntity, true);
    }

    public void persist(IEntity iEntity, boolean bl) {
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist((Object)iEntity);
        if (bl) {
            this.flush(entityManager);
        }
    }

    public <E extends IEntity> E refresh(E e) {
        EntityManager entityManager = this.getEntityManager();
        if (entityManager.contains(e)) {
            entityManager.refresh(e);
            return e;
        }
        return (E)((IEntity)entityManager.find(e.getClass(), (Object)e.getId()));
    }

    public final void remove(IEntity iEntity) throws ConstraintViolatedOnRemoveException {
        this.remove(iEntity, true);
    }

    public void remove(IEntity iEntity, boolean bl) throws ConstraintViolatedOnRemoveException {
        block5: {
            EntityManager entityManager = this.getEntityManager();
            try {
                IEntity iEntity2 = (IEntity)entityManager.find(iEntity.getClass(), (Object)iEntity.getId());
                if (iEntity2 == null) break block5;
                entityManager.remove((Object)iEntity2);
                if (!bl) break block5;
                try {
                    this.flush(entityManager);
                }
                catch (UnexpectedDataAccessException unexpectedDataAccessException) {
                    throw new ConstraintViolatedOnRemoveException(unexpectedDataAccessException.getCause());
                }
            }
            catch (CyclosException cyclosException) {
                throw cyclosException;
            }
            catch (Exception exception) {
                this.nativeQueryHandler.retryIfConnectionError(exception);
                throw new ConstraintViolatedOnRemoveException((Throwable)exception);
            }
        }
    }

    public <T> DBQuery<T> selectFrom(EntityPath<T> entityPath) {
        return this.from(new EntityPath[]{entityPath}).select(entityPath);
    }

    public <T> DBQuery<T> selectFromCacheable(EntityPath<T> entityPath) {
        return this.fromCacheable(entityPath).select(entityPath);
    }

    public DBQuery<?> subQuery(EntityPath<?> ... entityPathArray) {
        return this.from(entityPathArray);
    }

    public JPAUpdateClause update(EntityPath<?> entityPath) {
        return new JPAUpdateClause(this.getEntityManager(), entityPath, this.nativeQueryHandler.getJpaQueryTemplates());
    }

    protected DBQuery<?> createQuery() {
        SessionData sessionData = InvocationContext.getSessionData();
        return new DBQuery(this.getEntityManager(), this.nativeQueryHandler.getJpaQueryTemplates(), this.conversionHandler, sessionData);
    }

    private void flush(EntityManager entityManager) {
        try {
            entityManager.flush();
        }
        catch (OptimisticLockException optimisticLockException) {
            throw new StaleEntityException((Throwable)optimisticLockException);
        }
        catch (PersistenceException persistenceException) {
            this.nativeQueryHandler.retryIfConnectionError((Exception)((Object)persistenceException));
            throw new UnexpectedDataAccessException((Throwable)persistenceException);
        }
    }
}

