/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.persistence;

import com.querydsl.core.FilteredClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Table;
import org.cyclos.entities.HasNetwork;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.EntityCheckRegistry;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataSubjectId;
import org.cyclos.impl.utils.persistence.AbstractEntityManagerHandlerImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.IUnqualifiedInternalNamedEntity;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class EntityManagerHandlerImpl
extends AbstractEntityManagerHandlerImpl
implements EntityManagerHandler {
    @Autowired
    private NetworkPathRegistry networkPathRegistry;
    @Autowired
    private EntityCheckRegistry entityCheckRegistry;
    private Map<Class<? extends SimpleEntity>, Pair<Class<? extends SimpleEntity>, String>> ownerDataCache = new HashMap<Class<? extends SimpleEntity>, Pair<Class<? extends SimpleEntity>, String>>();

    public void checkAccess(IEntity iEntity) {
        this.doCheckAccess(iEntity);
    }

    @Override
    public JPADeleteClause delete(EntityPath<?> entityPath) {
        JPADeleteClause jPADeleteClause = super.delete(entityPath);
        SessionData sessionData = InvocationContext.getSessionData();
        this.applyNetworkFilter(sessionData, (FilteredClause<?>)jPADeleteClause, entityPath);
        return jPADeleteClause;
    }

    @Override
    public <E extends IEntity> E find(Class<E> clazz, Long l) throws EntityNotFoundException {
        E e = super.find(clazz, l);
        this.checkAccess((IEntity)e);
        return e;
    }

    public <E extends IInternalNamedEntity> E find(Class<E> clazz, String string) throws EntityNotFoundException {
        return this.find(clazz, string, null);
    }

    public <E extends IInternalNamedEntity> E find(Class<E> clazz, String string, SimpleEntity simpleEntity) throws EntityNotFoundException {
        Iterator iterator;
        SessionData sessionData = InvocationContext.getSessionData();
        if (StringHelper.isBlank((Object)string)) {
            throw new EntityNotFoundException(clazz);
        }
        List list = StringHelper.split((String)string.replace('/', '.'), (String)".");
        LinkedList<Class> linkedList = new LinkedList<Class>();
        Class clazz2 = clazz;
        SimpleEntity simpleEntity2 = list.iterator();
        while (simpleEntity2.hasNext()) {
            simpleEntity2.next();
            iterator = this.getOwnerData(clazz2);
            if (iterator == null && simpleEntity2.hasNext()) {
                throw new EntityNotFoundException(clazz);
            }
            linkedList.addFirst(clazz2);
            if (iterator == null) continue;
            clazz2 = (Class)iterator.getFirst();
        }
        simpleEntity2 = null;
        iterator = linkedList.iterator();
        for (String string2 : list) {
            simpleEntity = simpleEntity2 = (SimpleEntity)this.doFind(sessionData, (Class)iterator.next(), string2, simpleEntity);
        }
        try {
            this.doCheckAccess(simpleEntity2);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            entityNotFoundException.setKey(string);
            entityNotFoundException.setId(null);
        }
        return (E)((IInternalNamedEntity)simpleEntity2);
    }

    public DBQuery<?> from(EntityPath<?> ... entityPathArray) {
        DBQuery<?> dBQuery = this.createQuery();
        SessionData sessionData = dBQuery.getSessionData();
        if (CollectionHelper.isNotEmpty((Object[])entityPathArray)) {
            dBQuery.from(entityPathArray);
            if (sessionData.getNetwork() != null || !sessionData.isSystem()) {
                for (EntityPath<?> entityPath : entityPathArray) {
                    this.applyNetworkFilter(sessionData, dBQuery, entityPath);
                }
            }
        }
        return dBQuery;
    }

    public String getQualifiedInternalName(IInternalNamedEntity iInternalNamedEntity) {
        if (iInternalNamedEntity == null) {
            return null;
        }
        if (!(iInternalNamedEntity instanceof SimpleEntity)) {
            return iInternalNamedEntity.getInternalName();
        }
        Object object = (SimpleEntity)iInternalNamedEntity;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (object != null) {
            Pair<Class<? extends SimpleEntity>, String> pair;
            String string = null;
            if (object instanceof IInternalNamedEntity) {
                pair = (Pair<Class<? extends SimpleEntity>, String>)object;
                string = pair.getInternalName();
            }
            if (iInternalNamedEntity instanceof IUnqualifiedInternalNamedEntity) {
                return string;
            }
            if (string == null) {
                return null;
            }
            pair = this.getOwnerData(object.getClass());
            object = pair != null ? (SimpleEntity)InvocationContext.wrap((Object)object).getPropertyValue((String)pair.getSecond()) : null;
            linkedList.addFirst(string);
        }
        if (linkedList.contains(null)) {
            return null;
        }
        return StringHelper.join(linkedList, (String)".");
    }

    public boolean isAccessible(IEntity iEntity) {
        try {
            this.doCheckAccess(iEntity);
            return true;
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return false;
        }
    }

    @Override
    public void persist(IEntity iEntity, boolean bl) {
        SessionData sessionData = InvocationContext.getSessionData();
        if (iEntity instanceof DefinesNetwork) {
            ((DefinesNetwork)iEntity).setNetwork(sessionData.getNetwork());
        } else if (!sessionData.isSystem() && !sessionData.isGlobalAdminInNetwork() && iEntity instanceof HasNetwork && !Objects.equals(((HasNetwork)iEntity).getNetwork(), sessionData.getNetwork())) {
            throw new PermissionDeniedException("Can't persist an entity in a different network");
        }
        super.persist(iEntity, bl);
    }

    @Override
    public void remove(IEntity iEntity, boolean bl) throws ConstraintViolatedOnRemoveException {
        NetworkedEntity networkedEntity;
        SessionData sessionData = InvocationContext.getSessionData();
        Network network = sessionData.getNetwork();
        if (!(!(iEntity instanceof NetworkedEntity) || network == null && sessionData.isSystem() || Objects.equals((networkedEntity = (NetworkedEntity)iEntity).getNetwork(), network))) {
            throw new PermissionDeniedException();
        }
        super.remove(iEntity, bl);
    }

    @Override
    public DBQuery<?> subQuery(EntityPath<?> ... entityPathArray) {
        DBQuery<?> dBQuery = super.subQuery(entityPathArray);
        if (CollectionHelper.isNotEmpty((Object[])entityPathArray)) {
            dBQuery.from(entityPathArray);
            SessionData sessionData = InvocationContext.getSessionData();
            for (EntityPath<?> entityPath : entityPathArray) {
                this.applyNetworkFilter(sessionData, dBQuery, entityPath);
            }
        }
        return dBQuery;
    }

    @Override
    public JPAUpdateClause update(EntityPath<?> entityPath) {
        JPAUpdateClause jPAUpdateClause = super.update(entityPath);
        SessionData sessionData = InvocationContext.getSessionData();
        this.applyNetworkFilter(sessionData, (FilteredClause<?>)jPAUpdateClause, entityPath);
        return jPAUpdateClause;
    }

    private void applyNetworkFilter(SessionData sessionData, Class<? extends IInternalNamedEntity> clazz, StringBuilder stringBuilder) {
        Object object;
        Network network = sessionData.getNetwork();
        if (!(network == null && sessionData.isSystem() || (object = this.networkPathRegistry.getNetworkPath(clazz)) == null)) {
            object = "e." + (String)object;
            stringBuilder.append(" AND (");
            if (network == null) {
                stringBuilder.append((String)object).append(" IS NULL");
            } else if (this.networkPathRegistry.showGlobals(clazz)) {
                stringBuilder.append((String)object).append(" IS NULL OR ").append((String)object).append(" = :currentNetwork");
            } else {
                stringBuilder.append((String)object).append(" = :currentNetwork");
            }
            stringBuilder.append(")");
        }
    }

    private void applyNetworkFilter(SessionData sessionData, DBQuery<?> dBQuery, EntityPath<?> entityPath) {
        Network network = sessionData.getNetwork();
        if (network != null || !sessionData.isSystem()) {
            this.networkPathRegistry.applyNetworkFilter(dBQuery, entityPath, network);
        }
    }

    private void applyNetworkFilter(SessionData sessionData, FilteredClause<?> filteredClause, EntityPath<?> entityPath) {
        Network network = sessionData.getNetwork();
        if (network != null || !sessionData.isSystem()) {
            this.networkPathRegistry.applyNetworkFilter(filteredClause, entityPath, network);
        }
    }

    private <E extends IEntity> void doCheckAccess(E e) throws EntityNotFoundException {
        InvocationContext invocationContext = InvocationContext.ensure();
        SessionData sessionData = invocationContext.sessionData();
        if (sessionData.isSystem()) {
            return;
        }
        Class clazz = e.getClass();
        Long l = e.getId();
        AccessKey accessKey = new AccessKey(sessionData.getSubjectId(), clazz, l);
        if (Boolean.TRUE.equals(invocationContext.getAttribute((Object)accessKey))) {
            return;
        }
        if (e instanceof NetworkedEntity) {
            NetworkedEntity networkedEntity = (NetworkedEntity)e;
            Network network = sessionData.getNetwork();
            Network network2 = networkedEntity.getNetwork();
            if (this.networkPathRegistry.showGlobals(clazz) ? network2 != null && !network2.equals((Object)network) : !Objects.equals(network, network2)) {
                throw new EntityNotFoundException(clazz, l);
            }
            EntityCheck entityCheck = this.entityCheckRegistry.get(clazz.asSubclass(SimpleEntity.class));
            if (entityCheck != null && !sessionData.isVisible(entityCheck, (SimpleEntity)networkedEntity)) {
                throw new EntityNotFoundException(clazz, l);
            }
        }
        invocationContext.setAttribute((Object)accessKey, (Object)Boolean.TRUE);
    }

    private <E extends IInternalNamedEntity> E doFind(SessionData sessionData, Class<E> clazz, String string, SimpleEntity simpleEntity) {
        String string2 = "find:" + clazz.getName() + "." + SimpleEntity.id((SimpleEntity)simpleEntity) + "." + string;
        return (E)((IInternalNamedEntity)InvocationContext.ensure().getAttribute((Object)string2, () -> this.performFind(sessionData, clazz, string, simpleEntity)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Class<? extends SimpleEntity>, String> getOwnerData(Class<? extends SimpleEntity> clazz) {
        Pair pair = this.ownerDataCache.get(clazz);
        if (pair == null) {
            Map<Class<? extends SimpleEntity>, Pair<Class<? extends SimpleEntity>, String>> map = this.ownerDataCache;
            synchronized (map) {
                pair = this.ownerDataCache.get(clazz);
                if (pair == null) {
                    Field field = FieldHelper.getAnnotatedField(clazz, OwnerEntity.class);
                    pair = new Pair();
                    if (field != null) {
                        pair.setFirst(field.getType());
                        pair.setSecond((Object)field.getName());
                    }
                    this.ownerDataCache.put(clazz, (Pair<Class<? extends SimpleEntity>, String>)pair);
                }
            }
        }
        return pair.getFirst() == null ? null : pair;
    }

    private <E extends IInternalNamedEntity> E performFind(SessionData sessionData, Class<E> clazz, String string, SimpleEntity simpleEntity) {
        Field field = FieldHelper.getAnnotatedField(clazz, OwnerEntity.class);
        StringBuilder stringBuilder = new StringBuilder("FROM {0} e WHERE e.internalName = :fieldValue");
        if (field != null) {
            stringBuilder.append(simpleEntity == null ? " AND e.{1} IS NULL" : " AND e.{1} = :ownerEntity");
        } else if (simpleEntity != null) {
            throw new IllegalArgumentException(String.format("Owner entity value (used as filter) not supported for entity %s.", clazz));
        }
        this.applyNetworkFilter(sessionData, clazz, stringBuilder);
        String string2 = MessageFormat.format(stringBuilder.toString(), clazz.getSimpleName(), field == null ? null : field.getName());
        try {
            String string3;
            Query query = this.getEntityManager().createQuery(string2);
            Table table = (Table)AnnotationUtils.findAnnotation(clazz, Table.class);
            String string4 = string3 = table == null ? null : table.name();
            if (string3 != null) {
                query.setHint("eclipselink.sql.hint", (Object)("/* table: " + string3 + " */"));
            }
            query.setParameter("fieldValue", (Object)string);
            if (simpleEntity != null) {
                query.setParameter("ownerEntity", (Object)simpleEntity);
            }
            if (string2.contains(":currentNetwork")) {
                query.setParameter("currentNetwork", (Object)sessionData.getNetwork());
            }
            return (E)((IInternalNamedEntity)query.getSingleResult());
        }
        catch (NoResultException noResultException) {
            throw new EntityNotFoundException(clazz, string);
        }
    }

    private static class AccessKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SessionDataSubjectId subjectId;
        private final Class<?> entityClass;
        private final Long entityId;

        public AccessKey(SessionDataSubjectId sessionDataSubjectId, Class<?> clazz, Long l) {
            this.subjectId = sessionDataSubjectId;
            this.entityClass = clazz;
            this.entityId = l;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AccessKey accessKey = (AccessKey)object;
            if (this.entityClass == null ? accessKey.entityClass != null : !this.entityClass.equals(accessKey.entityClass)) {
                return false;
            }
            if (this.entityId == null ? accessKey.entityId != null : !this.entityId.equals(accessKey.entityId)) {
                return false;
            }
            return !(this.subjectId == null ? accessKey.subjectId != null : !this.subjectId.equals((Object)accessKey.subjectId));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.entityClass == null ? 0 : this.entityClass.hashCode());
            n = 31 * n + (this.entityId == null ? 0 : this.entityId.hashCode());
            n = 31 * n + (this.subjectId == null ? 0 : this.subjectId.hashCode());
            return n;
        }

        public String toString() {
            return String.valueOf(this.subjectId) + " can view " + this.entityClass.getSimpleName() + "#" + this.entityId;
        }
    }
}

