/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.system.QSmsOperationConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.InboundSmsHandler;
import org.cyclos.impl.utils.sms.SmsOperation;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationNature;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class HelpSmsOperation
extends BaseSmsOperation {
    @Autowired
    private InboundSmsHandler inboundSmsHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        Channel channel = this.channelService.getSms();
        ConfigurationAccessor configurationAccessor = this.getRequestDataConfiguration();
        SmsChannelConfiguration smsChannelConfiguration = (SmsChannelConfiguration)configurationAccessor.getChannelConfiguration(channel);
        String string = smsParameterProcessor.hasNext() ? smsParameterProcessor.remaining((Object)MessagingKeys.Notifications.SMS_HELP_PARAMETER_OPERATION_ALIAS, " ") : null;
        SmsOperationConfiguration smsOperationConfiguration2 = this.getAliasOperationConfiguration(string, smsChannelConfiguration);
        String string2 = smsOperationConfiguration2 == null || smsOperationConfiguration2.getNature() == SmsOperationConfigurationNature.HELP ? this.getHelpForHelpOperation(smsOperationConfiguration) : this.getHelpForOperation(smsOperationConfiguration2, string);
        this.sendResponse(mobilePhone, string2);
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        throw new UnsupportedOperationException("The help message for the help operation itlself is resolved in the getHelpForHelpOperation(...) method");
    }

    private SmsOperationConfiguration getAliasOperationConfiguration(String string, SmsChannelConfiguration smsChannelConfiguration) {
        if (string == null) {
            return null;
        }
        QSmsOperationConfiguration qSmsOperationConfiguration = QSmsOperationConfiguration.smsOperationConfiguration;
        SmsOperationConfiguration smsOperationConfiguration = (SmsOperationConfiguration)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qSmsOperationConfiguration}).where(new Predicate[]{qSmsOperationConfiguration.channelConfiguration().eq((Object)smsChannelConfiguration), qSmsOperationConfiguration.enabled.isTrue(), qSmsOperationConfiguration.aliases.contains((Object)string.toLowerCase())})).singleResult((Expression)qSmsOperationConfiguration);
        return smsOperationConfiguration;
    }

    private String getAvailableOperationsResponse(SmsOperationConfiguration smsOperationConfiguration, SmsChannelConfiguration smsChannelConfiguration) {
        QSmsOperationConfiguration qSmsOperationConfiguration = QSmsOperationConfiguration.smsOperationConfiguration;
        List list = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qSmsOperationConfiguration}).where(new Predicate[]{qSmsOperationConfiguration.channelConfiguration().eq((Object)smsChannelConfiguration), qSmsOperationConfiguration.id.ne((Object)smsOperationConfiguration.getId()), qSmsOperationConfiguration.enabled.isTrue()})).list((Expression)qSmsOperationConfiguration);
        StringBuilder stringBuilder = new StringBuilder();
        for (SmsOperationConfiguration smsOperationConfiguration2 : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getLongestAlias(smsOperationConfiguration2));
        }
        return stringBuilder.length() != 0 ? stringBuilder.toString() : null;
    }

    private String getHelpForHelpOperation(SmsOperationConfiguration smsOperationConfiguration) {
        String string = smsOperationConfiguration.getHelpMessage();
        if (StringHelper.isNotBlank((Object)string)) {
            return string;
        }
        String string2 = this.getAvailableOperationsResponse(smsOperationConfiguration, smsOperationConfiguration.getChannelConfiguration());
        if (StringHelper.isBlank((Object)string2)) {
            return this.message(MessagingKeys.Notifications.SMS_HELP_RESPONSE_NOT_AVAILABLE_OPERATIONS, new Object[0]);
        }
        return this.message(MessagingKeys.Notifications.SMS_HELP_RESPONSE_OPERATION_SYNTAX, this.getLongestAlias(smsOperationConfiguration) + " " + string2);
    }

    private String getHelpForOperation(SmsOperationConfiguration smsOperationConfiguration, String string) {
        String string2 = smsOperationConfiguration.getHelpMessage();
        if (StringHelper.isNotBlank((Object)string2)) {
            return string2;
        }
        SmsOperation smsOperation = this.inboundSmsHandler.getSmsOperation(smsOperationConfiguration);
        string2 = smsOperation.getHelp(smsOperationConfiguration, string);
        if (StringHelper.isNotBlank((Object)string2)) {
            return string2;
        }
        return this.message(MessagingKeys.Notifications.SMS_HELP_RESPONSE_HELP_NOT_AVAILABLE, string);
    }

    private ConfigurationAccessor getRequestDataConfiguration() {
        QConfiguration qConfiguration = QConfiguration.configuration;
        return this.configurationHandler.getAccessor((Configuration)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qConfiguration}).where((Predicate)qConfiguration.id.eq((Object)this.getSessionData().getRequestData().getConfigurationId()))).singleResult((Expression)qConfiguration));
    }
}

