/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cyclos.entities.messaging.InboundSms;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.sms.InboundSmsBasicData;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.InboundSmsRequestHandler;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class InboundSmsRequestHandlerImpl
implements InboundSmsRequestHandler {
    protected static final Pattern PARAM_PATTERN = Pattern.compile("(\\{\\w+\\})");
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public ResponseInfo generateResponse(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo, InboundSmsData inboundSmsData, InboundSms inboundSms) {
        return this.generateDefaultResponse();
    }

    public ResponseInfo generateResponseForError(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo, Exception exception) {
        ResponseInfo responseInfo = new ResponseInfo();
        responseInfo.setStatus(500);
        responseInfo.setStringBody("ERROR");
        return responseInfo;
    }

    public ResponseInfo generateResponseForMissingParameters(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo) {
        return this.generateDefaultResponse();
    }

    public InboundSmsBasicData resolveSmsData(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo) {
        String string = this.processParameters(configurationAccessor, smsChannelConfiguration, requestInfo, smsChannelConfiguration.getMobileNumberSource());
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, configurationAccessor);
        String string2 = this.processParameters(configurationAccessor, smsChannelConfiguration, requestInfo, smsChannelConfiguration.getSmsMessageSource());
        List<String> list = this.splitMessageParts(configurationAccessor, smsChannelConfiguration, requestInfo, string2);
        InboundSmsBasicData inboundSmsBasicData = new InboundSmsBasicData();
        inboundSmsBasicData.setPhoneNumber(phoneNumberDescriptor == null ? string : phoneNumberDescriptor.toE164());
        inboundSmsBasicData.setMessage(string2);
        inboundSmsBasicData.setMessageParts(list);
        return inboundSmsBasicData;
    }

    protected ResponseInfo generateDefaultResponse() {
        ResponseInfo responseInfo = new ResponseInfo();
        responseInfo.setStatus(200);
        responseInfo.setStringBody("OK");
        return responseInfo;
    }

    protected String processParameters(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo, String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = PARAM_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = StringHelper.removeEnd((String)StringHelper.removeStart((String)matcher.group(1), (String)"{"), (String)"}");
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(StringHelper.trim((Object)requestInfo.getParameter(string2))));
        }
        matcher.appendTail(stringBuffer);
        return StringHelper.trimToNull((Object)stringBuffer.toString());
    }

    protected List<String> splitMessageParts(ConfigurationAccessor configurationAccessor, SmsChannelConfiguration smsChannelConfiguration, RequestInfo requestInfo, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            for (String string2 : string.split("\\ ")) {
                if ((string2 = StringHelper.trimToNull((Object)string2)) == null) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }
}

