/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.util.ArrayList;
import java.util.List;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.RegisterSmsOperationConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.RegisterUserBySmsParams;
import org.cyclos.impl.users.RegisterUserBySmsResult;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationExecution;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class RegisterSmsOperation
extends BaseSmsOperation {
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private ChannelServiceLocal channelService;

    static boolean isManualAccessPassword(RegisterSmsOperationConfiguration registerSmsOperationConfiguration, ConfigurationHandler configurationHandler, ChannelServiceLocal channelServiceLocal) {
        ConfigurationAccessor configurationAccessor = configurationHandler.getAccessor((BasicGroup)registerSmsOperationConfiguration.getGroup());
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channelServiceLocal.getSms());
        return channelConfiguration.getAccessPassword().getPasswordMode() == PasswordMode.MANUAL;
    }

    @Override
    public SmsOperationExecution getOperationExecution(SmsOperationConfiguration smsOperationConfiguration) {
        return SmsOperationExecution.ONLY_BY_GUESTS;
    }

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        int n;
        RegisterSmsOperationConfiguration registerSmsOperationConfiguration = (RegisterSmsOperationConfiguration)smsOperationConfiguration;
        int n2 = n = !this.isManualAccessPassword((SmsOperationConfiguration)registerSmsOperationConfiguration) ? 1 : 2;
        if (CollectionHelper.size(list) < n) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[]{n, 99});
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        RegisterSmsOperationConfiguration registerSmsOperationConfiguration = (RegisterSmsOperationConfiguration)smsOperationConfiguration;
        RegisterUserBySmsParams registerUserBySmsParams = this.createNewRegisterUserParam(registerSmsOperationConfiguration, smsParameterProcessor, inboundSmsData.getPhoneNumber());
        RegisterUserBySmsResult registerUserBySmsResult = this.userService.registerBySms(registerUserBySmsParams);
        this.notifyRegistration(registerSmsOperationConfiguration, registerUserBySmsResult);
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.isGeneratedUserName((RegisterSmsOperationConfiguration)smsOperationConfiguration)) {
            arrayList.add(this.message(MessagingKeys.Notifications.SMS_REGISTER_PARAMETER_USERNAME, new Object[0]));
        }
        if (this.isManualAccessPassword(smsOperationConfiguration)) {
            arrayList.add(this.message(MessagingKeys.Notifications.SMS_REGISTER_PARAMETER_CREDENTIALS, new Object[0]));
        }
        arrayList.add(this.message(MessagingKeys.Notifications.SMS_REGISTER_PARAMETER_FULL_NAME, new Object[0]));
        return arrayList;
    }

    private RegisterUserBySmsParams createNewRegisterUserParam(RegisterSmsOperationConfiguration registerSmsOperationConfiguration, SmsParameterProcessor smsParameterProcessor, String string) {
        String string2 = null;
        if (!this.isGeneratedUserName(registerSmsOperationConfiguration)) {
            string2 = smsParameterProcessor.nextString((Object)MessagingKeys.Notifications.SMS_REGISTER_PARAMETER_USERNAME);
        }
        String string3 = null;
        if (this.isManualAccessPassword((SmsOperationConfiguration)registerSmsOperationConfiguration)) {
            string3 = smsParameterProcessor.nextString((Object)MessagingKeys.Notifications.SMS_REGISTER_PARAMETER_CREDENTIALS);
        }
        String string4 = null;
        string4 = smsParameterProcessor.hasNext() ? smsParameterProcessor.remaining((Object)MessagingKeys.Notifications.SMS_REGISTER_PARAMETER_FULL_NAME, " ") : string2;
        RegisterUserBySmsParams registerUserBySmsParams = new RegisterUserBySmsParams();
        registerUserBySmsParams.setGroup(registerSmsOperationConfiguration.getGroup());
        registerUserBySmsParams.setName(string4);
        registerUserBySmsParams.setUsername(string2);
        registerUserBySmsParams.setPassword(string3);
        registerUserBySmsParams.setPhoneNumber(string);
        return registerUserBySmsParams;
    }

    private boolean isGeneratedUserName(RegisterSmsOperationConfiguration registerSmsOperationConfiguration) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)registerSmsOperationConfiguration.getGroup());
        return configurationAccessor.isGeneratedUsername();
    }

    private boolean isManualAccessPassword(SmsOperationConfiguration smsOperationConfiguration) {
        return RegisterSmsOperation.isManualAccessPassword((RegisterSmsOperationConfiguration)smsOperationConfiguration, this.configurationHandler, this.channelService);
    }

    private void notifyRegistration(RegisterSmsOperationConfiguration registerSmsOperationConfiguration, RegisterUserBySmsResult registerUserBySmsResult) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)registerSmsOperationConfiguration.getGroup());
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(this.channelService.getSms());
        boolean bl = channelConfiguration.getAccessPassword().getPasswordMode() == PasswordMode.GENERATED;
        User user = (User)this.userService.find(registerUserBySmsResult.getResult().getUser().getId());
        String string = bl ? this.message(MessagingKeys.Notifications.SMS_REGISTER_RESPONSE_OK_GENERATED_PASS, registerUserBySmsResult.getGeneratedPassword()) : this.message(MessagingKeys.Notifications.SMS_REGISTER_RESPONSE_OK, new Object[0]);
        String string2 = this.message(user.getStatus() == UserStatus.ACTIVE ? MessagingKeys.Notifications.SMS_REGISTER_RESPONSE_ACTIVATED : MessagingKeys.Notifications.SMS_REGISTER_RESPONSE_PENDING_ACTIVATE, new Object[0]);
        MobilePhone mobilePhone = (MobilePhone)CollectionHelper.first((Iterable)user.getPhones());
        this.sendResponse(mobilePhone, this.message(MessagingKeys.Notifications.SMS_REGISTER_RESPONSE, string, string2));
    }
}

