/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractTask;
import org.cyclos.impl.utils.tasks.BackgroundTask;
import org.cyclos.model.messaging.ErrorLogType;
import org.cyclos.utils.ObjectHelper;

public abstract class AbstractBackgroundTask
extends AbstractTask
implements BackgroundTask {
    private static final Logger LOG = LogManager.getLogger(AbstractBackgroundTask.class);

    public final long execute(String string, String string2, ProfilingEntry profilingEntry) {
        long l = System.currentTimeMillis();
        try {
            LOG.debug("Running background task '{}' with context: {}", (Object)this, (Object)string2);
            if (profilingEntry != null) {
                profilingEntry.setName(this.getName());
                profilingEntry.setTaskClassName(this.getClass().getName());
            }
            long l2 = this.doExecute(string2, profilingEntry);
            if (profilingEntry != null && profilingEntry.getResult() == null) {
                profilingEntry.setResult((Object)l2);
            }
            this.logTaskSuccess(string, System.currentTimeMillis() - l, l2);
            return l2;
        }
        catch (Exception exception) {
            if (profilingEntry != null && profilingEntry.getErrorTrace() == null) {
                profilingEntry.setErrorTrace(ExceptionUtils.getStackTrace((Throwable)exception));
            }
            try {
                this.logTaskError(string, exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    protected abstract long doExecute(String var1, ProfilingEntry var2);

    @Override
    protected ErrorLogType getErrorLogType() {
        return ErrorLogType.BACKGROUND_TASK;
    }

    @Override
    protected boolean isVerbose() {
        return true;
    }

    @Override
    protected String logName(String string) {
        return (String)ObjectHelper.defaultValue((Object)string, () -> this.getClass().getSimpleName());
    }

    protected <T> T runInEntityNetwork(SimpleEntity simpleEntity, Supplier<T> supplier) {
        Network network = simpleEntity instanceof NetworkedEntity ? ((NetworkedEntity)simpleEntity).getNetwork() : null;
        return this.runInNetwork(network, supplier);
    }

    protected <T> T runInNetwork(Network network, Supplier<T> supplier) {
        return (T)this.invokerHandler.runAs(SessionDataFactory.system((Network)network), supplier::get);
    }
}

