/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.system.CustomBackgroundTask;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QCustomBackgroundTask;
import org.cyclos.entities.utils.ForkJoin;
import org.cyclos.entities.utils.QBackgroundTaskExecution;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.ApplicationInitializationListener;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.InlineScriptBackgroundTask;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingEntryType;
import org.cyclos.impl.system.ProfilingServiceLocal;
import org.cyclos.impl.system.RunScheduledBackgroundTask;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.tasks.AbstractTask;
import org.cyclos.impl.utils.tasks.BackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionContext;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionRecurringTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandlerImplementor;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.impl.utils.tasks.BaseBackgroundTaskScheduling;
import org.cyclos.impl.utils.tasks.CustomBackgroundTaskScheduling;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.tasks.RunningTaskDescriptor;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.messaging.ErrorLogType;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BackgroundTaskHandlerImpl
extends BaseGlobalHandlerImpl
implements BackgroundTaskHandlerImplementor,
ApplicationInitializationListener {
    private static final QBackgroundTaskExecution $ = QBackgroundTaskExecution.backgroundTaskExecution;
    private static final QCustomBackgroundTask c = QCustomBackgroundTask.customBackgroundTask;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private ClusterHandler clusterHandler;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    private Map<BackgroundTaskExecutionContext, RunningTaskDescriptor> runningTasks = Collections.synchronizedMap(new HashMap());
    private Map<String, BackgroundTask> allBackgroundTasks;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private EntityManagerHandler entityManagerHandler;
    @Autowired
    private ProfilingServiceLocal profilingService;

    public CustomBackgroundTaskScheduling custom(String string, String string2) {
        return this.custom(string, string2, null);
    }

    public CustomBackgroundTaskScheduling custom(String string, String string2, Long l) {
        CustomBackgroundTask customBackgroundTask = (CustomBackgroundTask)((DBQuery)this.from(new EntityPath[]{c}).where((Predicate)BackgroundTaskHandlerImpl.c.internalName.eq((Object)string))).requiredUniqueResult((Expression)c);
        return new CustomBackgroundTaskScheduling(this::doSchedule, customBackgroundTask, (Object)string2, l);
    }

    public void execute(BackgroundTaskExecutionContext backgroundTaskExecutionContext) {
        boolean bl;
        ProfilingEntry profilingEntry;
        Long l;
        if (this.applicationHandler.isShuttingDown()) {
            return;
        }
        try {
            l = Long.parseLong(backgroundTaskExecutionContext.getClassName());
        }
        catch (NumberFormatException numberFormatException) {
            l = null;
        }
        Exception exception = null;
        RequestContext requestContext = RequestContext.ensure();
        ProfilingEntryType profilingEntryType = l != null ? ProfilingEntryType.CUSTOM_BACKGROUND_TASK : (RunScheduledBackgroundTask.class.getName().equals(backgroundTaskExecutionContext.getClassName()) ? ProfilingEntryType.CUSTOM_RECURRING_TASK : ProfilingEntryType.BUILTIN_BACKGROUND_TASK);
        Pair pair = this.profilingService.newIfEnabled(profilingEntryType, null);
        ProfilingEntry profilingEntry2 = profilingEntry = pair == null ? null : (ProfilingEntry)pair.getSecond();
        if (profilingEntry != null) {
            requestContext.setProfiling(pair);
            profilingEntry.setParameters((Object)backgroundTaskExecutionContext.getContext());
            if (profilingEntryType == ProfilingEntryType.BUILTIN_BACKGROUND_TASK) {
                profilingEntry.setTaskClassName(backgroundTaskExecutionContext.getClassName());
            }
        }
        Pair pair2 = null;
        try {
            this.runningTasks.put(backgroundTaskExecutionContext, new RunningTaskDescriptor(new Date(), backgroundTaskExecutionContext));
            if (l == null) {
                BackgroundTask backgroundTask = this.allBackgroundTasks.get(backgroundTaskExecutionContext.getClassName());
                long l2 = backgroundTask.execute(backgroundTaskExecutionContext.getDisplay(), backgroundTaskExecutionContext.getContext(), profilingEntry);
                pair2 = Pair.create((Object)l2, null);
            } else {
                pair2 = this.executeCustom(l, backgroundTaskExecutionContext, profilingEntry);
            }
            this.runningTasks.remove(backgroundTaskExecutionContext);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                pair2 = Pair.create(null, (Object)exception2);
                throw exception2;
            }
            catch (Throwable throwable) {
                boolean bl2;
                this.runningTasks.remove(backgroundTaskExecutionContext);
                boolean bl3 = bl2 = exception != null && this.clusterHandler.isCausedByShutdown((Throwable)exception);
                if (!bl2) {
                    this.clusterHandler.finishBackgroundTaskExecution(backgroundTaskExecutionContext);
                }
                if (profilingEntry != null) {
                    if (pair2 != null && profilingEntry.getResult() == null) {
                        profilingEntry.setResult(pair2.getFirst());
                    }
                    this.profilingService.collect(profilingEntry, (Throwable)exception);
                }
                RequestContext.remove();
                throw throwable;
            }
        }
        boolean bl4 = bl = exception != null && this.clusterHandler.isCausedByShutdown((Throwable)exception);
        if (!bl) {
            this.clusterHandler.finishBackgroundTaskExecution(backgroundTaskExecutionContext);
        }
        if (profilingEntry != null) {
            if (pair2 != null && profilingEntry.getResult() == null) {
                profilingEntry.setResult(pair2.getFirst());
            }
            this.profilingService.collect(profilingEntry, (Throwable)exception);
        }
        RequestContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RunningTaskDescriptor> getRunningTasks() {
        Map<BackgroundTaskExecutionContext, RunningTaskDescriptor> map = this.runningTasks;
        synchronized (map) {
            return this.runningTasks.values().stream().collect(Collectors.toUnmodifiableSet());
        }
    }

    @PostConstruct
    public void initialize() {
        this.allBackgroundTasks = this.applicationContext.getBeansOfType(BackgroundTask.class).values().stream().collect(Collectors.toMap(backgroundTask -> backgroundTask.getClass().getName(), backgroundTask -> backgroundTask));
    }

    public boolean isScheduledOrRunning(Class<? extends BackgroundTask> clazz, Object object) {
        return ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{BackgroundTaskHandlerImpl.$.className.eq((Object)clazz.getName()), BackgroundTaskHandlerImpl.$.context.eq((Object)object.toString())})).singleResult((Expression)$) != null;
    }

    public Long newForkJoin(long l, String string2, String ... stringArray) {
        Set<String> set = new HashSet<String>();
        if (CollectionHelper.isNotEmpty((Object[])stringArray)) {
            set = Stream.of(stringArray).map(string -> (CustomScript)this.entityManagerHandler.find(CustomScript.class, string)).filter(customScript -> customScript.getType() == ScriptType.LIBRARY).map(ConfigurationEntity::getInternalName).collect(Collectors.toSet());
        }
        ForkJoin forkJoin = new ForkJoin();
        forkJoin.setTaskCount(l);
        forkJoin.setJoinCode(InlineScriptBackgroundTask.scheduling(string2, set).getContext().toString());
        this.persist((IEntity)forkJoin);
        return forkJoin.getId();
    }

    public void onApplicationInitialization() {
        this.rawEntityManagerHandler.update((EntityPath)$).setNull((Path)BackgroundTaskHandlerImpl.$.submittedAt).where(new Predicate[]{BackgroundTaskHandlerImpl.$.submittedAt.isNotNull()}).execute();
    }

    public boolean remove(Long l) {
        return this.entityManagerHandler.delete((EntityPath)$).where(new Predicate[]{BackgroundTaskHandlerImpl.$.id.eq((Object)l)}).execute() > 0L;
    }

    public Long schedule(BackgroundTaskScheduling backgroundTaskScheduling) {
        return this.doSchedule((BaseBackgroundTaskScheduling<?>)backgroundTaskScheduling);
    }

    protected Long doSchedule(BaseBackgroundTaskScheduling<?> baseBackgroundTaskScheduling) {
        long l = this.nativeQueryHandler.insertBackgroundTaskExecution(baseBackgroundTaskScheduling);
        if (baseBackgroundTaskScheduling.isAsSoonAsPossible()) {
            this.recurringTaskHandler.scheduleAwake(BackgroundTaskExecutionRecurringTask.class);
        }
        return l;
    }

    private Pair<Long, Exception> executeCustom(Long l, BackgroundTaskExecutionContext backgroundTaskExecutionContext, ProfilingEntry profilingEntry) {
        MutableObject mutableObject = new MutableObject();
        try {
            Long l2 = (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                CustomBackgroundTask customBackgroundTask;
                long l2 = System.currentTimeMillis();
                try {
                    customBackgroundTask = (CustomBackgroundTask)this.rawEntityManagerHandler.find(CustomBackgroundTask.class, l);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    return null;
                }
                if (profilingEntry != null) {
                    profilingEntry.setName(customBackgroundTask.getName());
                }
                return (Long)this.invokerHandler.runAs(SessionDataFactory.system((Network)customBackgroundTask.getNetwork()), () -> {
                    TaskAccessor taskAccessor = (TaskAccessor)this.beanHandler.autowireWithArgs(TaskAccessor.class, new Object[]{customBackgroundTask});
                    mutableObject.setValue((Object)taskAccessor);
                    Long l2 = (Long)this.customScriptService.newAccessor(customBackgroundTask.getScript(), customBackgroundTask.getScriptParameters()).bind("task", (Object)customBackgroundTask).bind("context", (Object)backgroundTaskExecutionContext.getContext()).run(Long.class);
                    l2 = (Long)ObjectHelper.defaultValue((Object)l2, (Object)1L);
                    taskAccessor.logTaskSuccess(backgroundTaskExecutionContext.getDisplay(), System.currentTimeMillis() - l2, l2);
                    return l2;
                });
            });
            return Pair.create((Object)l2, null);
        }
        catch (Exception exception) {
            if (!this.clusterHandler.isCausedByShutdown((Throwable)exception) && mutableObject.getValue() != null) {
                ((TaskAccessor)mutableObject.getValue()).logTaskError(backgroundTaskExecutionContext.getDisplay(), exception);
                return Pair.create(null, (Object)exception);
            }
            throw exception;
        }
    }

    public static class TaskAccessor
    extends AbstractTask {
        private final CustomBackgroundTask task;

        public TaskAccessor(CustomBackgroundTask customBackgroundTask) {
            this.task = customBackgroundTask;
        }

        public MessageKey getMessageKey() {
            return null;
        }

        @Override
        public void logTaskError(String string, Throwable throwable) {
            super.logTaskError(string, throwable);
        }

        @Override
        public void logTaskSuccess(String string, long l, long l2) {
            super.logTaskSuccess(string, l, l2);
        }

        @Override
        protected String getErrorLogName() {
            return this.task.getId().toString();
        }

        @Override
        protected ErrorLogType getErrorLogType() {
            return ErrorLogType.BACKGROUND_TASK;
        }

        @Override
        protected Network getNetwork() {
            return this.task.getNetwork();
        }

        @Override
        protected boolean isVerbose() {
            return this.task.isVerboseLog();
        }

        @Override
        protected String logName(String string) {
            return string;
        }

        @Override
        protected String resolveName() {
            return this.task.getName();
        }
    }
}

