/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractRecurringTask;
import org.cyclos.model.utils.TransactionLevel;
import org.springframework.transaction.TransactionStatus;

public abstract class SimpleRecurringTask
extends AbstractRecurringTask {
    @Override
    protected final void doRun() {
        long l = System.currentTimeMillis();
        RequestContext requestContext = RequestContext.get();
        ProfilingEntry profilingEntry = requestContext == null ? null : requestContext.getProfilingEntry();
        RunResult runResult = this.isRunInTransaction() ? (RunResult)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, this::doExecute) : this.doExecute(null);
        Throwable throwable = runResult.getError();
        if (throwable == null) {
            this.logTaskSuccess(null, System.currentTimeMillis() - l, runResult.getAffectedRecords());
            if (profilingEntry != null) {
                profilingEntry.setResult((Object)runResult.getAffectedRecords());
            }
        } else {
            this.logTaskError(null, throwable);
            if (profilingEntry != null) {
                profilingEntry.setErrorTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
        }
    }

    protected abstract long execute() throws Throwable;

    protected boolean isRunInTransaction() {
        return true;
    }

    private RunResult doExecute(TransactionStatus transactionStatus) {
        try {
            long l = this.execute();
            return new RunResult(l);
        }
        catch (Throwable throwable) {
            if (transactionStatus != null) {
                transactionStatus.setRollbackOnly();
            }
            return new RunResult(throwable);
        }
    }

    private class RunResult {
        private long affectedRecords;
        private Throwable error;

        public RunResult(long l) {
            this.affectedRecords = l;
        }

        public RunResult(Throwable throwable) {
            this.error = throwable;
        }

        public long getAffectedRecords() {
            return this.affectedRecords;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

