/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.BeanDataAccessor;
import org.cyclos.model.BeanDataAccessorFactory;
import org.cyclos.model.Property;
import org.cyclos.utils.Pair;

public abstract class Bean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Map<Class<?>, Map<String, Property<?, ?>>> cachedProperties = new HashMap();
    private BeanDataAccessor dataAccessor;
    private transient Map<String, Object> attributes = null;
    private transient Map<Property<?, ?>, Object> newValues = null;
    private transient PropertyChangeSupport changes;

    public void addPropertyChangeListener(Property<?, ?> property, PropertyChangeListener propertyChangeListener) {
        this.changes().addPropertyChangeListener(property.getName(), propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes().addPropertyChangeListener(propertyChangeListener);
    }

    public Set<String> attributeNames() {
        if (this.attributes == null) {
            return Collections.emptySet();
        }
        return this.attributes.keySet();
    }

    public void backup() {
        if (this.newValues == null) {
            this.newValues = new HashMap();
        }
    }

    public abstract String className();

    public void clearAttributes() {
        this.attributes = null;
    }

    public void copyPropertiesTo(Bean bean) {
        this.copyPropertiesTo(bean, (Property[])null);
    }

    public void copyPropertiesTo(Bean bean, List<Property<?, ?>> list) {
        List list2 = this.properties().stream().filter(property -> list == null || !list.contains(property)).collect(Collectors.toList());
        for (Property property2 : list2) {
            Object t = this.get(property2);
            try {
                bean.set(property2, t);
            }
            catch (Exception exception) {}
        }
    }

    public void copyPropertiesTo(Bean bean, Property<?, ?> ... propertyArray) {
        this.copyPropertiesTo(bean, propertyArray == null ? null : Arrays.asList(propertyArray));
    }

    public BeanDataAccessor dataAccessor() {
        return this.dataAccessor;
    }

    public final <T> T get(Property<T, ? extends Bean> property) {
        Object object = null;
        if (this.newValues != null && this.newValues.containsKey(property)) {
            return (T)this.newValues.get(property);
        }
        if (this.dataAccessor != null) {
            object = this.dataAccessor.get(property);
        }
        return (T)(object == null ? (Object)property.getValueWhenNull() : object);
    }

    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public void initDataAccessor(BeanDataAccessor beanDataAccessor) {
        if (this.dataAccessor != null) {
            throw new IllegalStateException("This bean already has a data accessor");
        }
        this.dataAccessor = beanDataAccessor;
    }

    public final List<Property<?, ?>> properties() {
        Map<String, Property<?, ?>> map = this.propertyMap();
        return new ArrayList(map.values());
    }

    public <P extends Property<T, DTO>, T, DTO extends Bean> P property(String string) {
        Map<String, Property<?, ?>> map = this.propertyMap();
        return (P)map.get(string);
    }

    public Map<String, Property<?, ?>> propertyMap() {
        Map<String, Property<?, ?>> map = cachedProperties.get(this.getClass());
        if (map == null) {
            map = new LinkedHashMap();
            for (Property<?, ?> property : this.doGetProperties()) {
                map.put(property.getName(), property);
            }
            cachedProperties.put(this.getClass(), map);
        }
        return map;
    }

    public boolean removeAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.remove(string) != null;
    }

    public void removePropertyChangeListener(Property<?, ?> property, PropertyChangeListener propertyChangeListener) {
        this.changes().removePropertyChangeListener(property.getName(), propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes().removePropertyChangeListener(propertyChangeListener);
    }

    public void restore() {
        this.newValues = null;
    }

    public final <T> T set(Property<T, ?> property, T t) {
        return this.set(property, t, true, null);
    }

    public final <T> T set(Property<T, ?> property, T t, boolean bl) {
        return this.set(property, t, bl, null);
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, object);
    }

    public final <T> T setWithPropagationId(Property<T, ?> property, T t, Object object) {
        return this.set(property, t, true, object);
    }

    public Map<String, Object> values() {
        return this.properties().stream().map(property -> Pair.create(property, this.get((Property)property))).filter(pair -> pair.getSecond() != null).collect(Collectors.toMap(pair -> ((Property)pair.getFirst()).getName(), Pair::getSecond));
    }

    protected PropertyChangeSupport changes() {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        return this.changes;
    }

    protected List<Property<?, ?>> doGetProperties() {
        return new ArrayList();
    }

    protected void firePropertyChange(Property<?, ?> property, Object object, Object object2) {
        if (Objects.equals(object, object2)) {
            return;
        }
        this.changes().firePropertyChange(property.getName(), object, object2);
    }

    private <T> T set(Property<T, ?> property, T t, boolean bl, Object object) {
        Object object2;
        if (t == null) {
            t = property.getValueWhenNull();
        }
        if (this.dataAccessor == null) {
            this.dataAccessor = BeanDataAccessorFactory.Instance.instance().newDataAccessor(this);
        }
        Object object3 = null;
        if (bl && this.changes != null) {
            object3 = this.dataAccessor.get(property);
        }
        if (this.newValues != null && !Objects.equals(object3, t)) {
            this.newValues.put(property, t);
            object2 = t;
        } else {
            object2 = this.dataAccessor.set(property, t);
        }
        if (bl && this.changes != null && !Objects.equals(object3, object2)) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, property.getName(), object3, object2);
            propertyChangeEvent.setPropagationId(object);
            this.changes.firePropertyChange(propertyChangeEvent);
        }
        return (T)object2;
    }
}

