/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AggregatedMap<K, V>
implements Map<K, V> {
    private Map<K, V> staticMap;
    private Map<K, V> dynamicMap;

    public AggregatedMap(Map<K, V> map) {
        this.staticMap = map;
        this.dynamicMap = new HashMap();
    }

    @Override
    public void clear() {
        this.dynamicMap.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.staticMap.containsKey(object) || this.dynamicMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.staticMap.containsValue(object) || this.dynamicMap.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (final K k : this.keySet()) {
            hashSet.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return k;
                }

                @Override
                public V getValue() {
                    return AggregatedMap.this.get(k);
                }

                @Override
                public V setValue(V v) {
                    return AggregatedMap.this.put(k, v);
                }
            });
        }
        return hashSet;
    }

    @Override
    public V get(Object object) {
        if (this.staticMap.containsKey(object)) {
            return this.staticMap.get(object);
        }
        return this.dynamicMap.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.staticMap.isEmpty() && this.dynamicMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> hashSet = new HashSet<K>(this.staticMap.keySet());
        hashSet.addAll(this.dynamicMap.keySet());
        return hashSet;
    }

    @Override
    public V put(K k, V v) {
        if (this.staticMap.containsKey(k)) {
            throw new UnsupportedOperationException();
        }
        return this.dynamicMap.put(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        if (this.staticMap.containsKey(object)) {
            throw new UnsupportedOperationException();
        }
        return this.dynamicMap.remove(object);
    }

    @Override
    public int size() {
        return this.staticMap.size() + this.dynamicMap.size();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> arrayList = new ArrayList<V>(this.size());
        arrayList.addAll(this.staticMap.values());
        arrayList.addAll(this.dynamicMap.values());
        return arrayList;
    }
}

