/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;

public class CollectionHelper {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @SafeVarargs
    public static <T> void addAll(Collection<T> collection, T ... TArray) {
        if (collection != null && TArray != null) {
            collection.addAll(Arrays.asList(TArray));
        }
    }

    public static <T> void addOrRemove(Collection<T> collection, T t, boolean bl) {
        if (bl) {
            collection.add(t);
        } else {
            collection.remove(t);
        }
    }

    public static <T> Page<T> asPage(Iterable<T> iterable) {
        List list = iterable instanceof List ? (List)iterable : CollectionHelper.asStream(iterable).collect(Collectors.toList());
        return CollectionHelper.asPage(list, list.size(), 0);
    }

    public static <T> Page<T> asPage(List<T> list, int n, int n2) {
        if (list == null || list.isEmpty()) {
            return PageImpl.empty(n, n2);
        }
        int n3 = n * n2;
        int n4 = list.size();
        if (n3 >= n4) {
            return PageImpl.empty(n, n2);
        }
        int n5 = Math.min(n4, n3 + n);
        List<T> list2 = list.subList(n3, n5);
        return PageImpl.withTotalCount(list2, n4, n, n2);
    }

    @SafeVarargs
    public static <T> Page<T> asPage(T ... TArray) {
        return CollectionHelper.asPage(Arrays.asList(TArray));
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return iterable == null ? Collections.emptySet() : CollectionHelper.asStream(iterable).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... TArray) {
        return CollectionHelper.asSet(TArray == null ? Collections.emptyList() : Arrays.asList(TArray));
    }

    public static <T> Stream<T> asStream(Enumeration<T> enumeration) {
        return enumeration == null ? Stream.empty() : CollectionHelper.asStream(CollectionHelper.iterable(enumeration));
    }

    public static <T> Stream<T> asStream(Iterable<T> iterable) {
        return iterable == null ? Stream.empty() : StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> asStream(Iterator<T> iterator) {
        if (iterator instanceof Closeable) {
            Iterable iterable = () -> iterator;
            Stream stream2 = (Stream)StreamSupport.stream(iterable.spliterator(), false).onClose(() -> {
                try {
                    ((Closeable)((Object)iterator)).close();
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            });
            return Stream.of(stream2).flatMap(stream -> stream);
        }
        return iterator == null ? Stream.empty() : CollectionHelper.asStream(() -> iterator);
    }

    public static <T> boolean containsAll(Collection<T> collection, Collection<T> collection2) {
        if (CollectionHelper.isEmpty(collection)) {
            return CollectionHelper.isEmpty(collection2);
        }
        if (CollectionHelper.isEmpty(collection2)) {
            return true;
        }
        return collection.containsAll(collection2);
    }

    public static boolean containsAny(Collection<?> collection, Collection<?> collection2) {
        if (CollectionHelper.isEmpty(collection) || CollectionHelper.isEmpty(collection2)) {
            return false;
        }
        for (Object obj : collection) {
            if (!collection2.contains(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<?> collection, Object ... objectArray) {
        return CollectionHelper.containsAny(collection, objectArray == null ? null : Arrays.asList(objectArray));
    }

    public static boolean equals(Map<?, ?> map, Map<?, ?> map2) {
        if (Objects.equals(map, map2)) {
            return true;
        }
        if (map == null || map2 == null || map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj;
            Object obj2 = entry.getValue();
            if (Objects.equals(obj2, obj = map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @GwtIncompatible
    public static <I, O extends I> Stream<O> filterByType(Stream<I> stream, Class<O> clazz) {
        return stream.filter(clazz::isInstance).map(clazz::cast);
    }

    public static <T> int findIndex(List<T> list, Predicate<T> predicate) {
        if (CollectionHelper.isNotEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                if (!predicate.test(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T first(Iterable<T> iterable) {
        return CollectionHelper.isEmpty(iterable) ? null : (T)iterable.iterator().next();
    }

    public static <T> T first(T[] TArray) {
        return CollectionHelper.isEmpty(TArray) ? null : (T)TArray[0];
    }

    public static Object[] flatten(Object ... objectArray) {
        if (CollectionHelper.isEmpty(objectArray)) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (object instanceof Iterable) {
                ((Iterable)object).iterator().forEachRemaining(arrayList::add);
                continue;
            }
            if (object instanceof Object[]) {
                Collections.addAll(arrayList, (Object[])object);
                continue;
            }
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public static Map<String, String> flattenKeys(Map<String, ?> map, String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        CollectionHelper.collectKeys(treeMap, "", string, map);
        return treeMap;
    }

    public static <T> void forEach(Collection<T> collection, Consumer<T> consumer) {
        if (collection != null) {
            collection.forEach(consumer);
        }
    }

    public static Integer getTotalCount(Iterable<?> iterable) {
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Page) {
            return ((Page)iterable).getTotalCount();
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int n = 0;
        for (Object obj : iterable) {
            ++n;
        }
        return n;
    }

    public static int hashCode(Map<?, ?> map) {
        if (map == null) {
            return -1;
        }
        int n = 23;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getKey();
            Object obj2 = entry.getValue();
            int n2 = obj == null ? 1 : obj.hashCode();
            int n3 = obj2 == null ? 1 : obj2.hashCode();
            n *= (n2 == 0 ? 1 : n2) + (n3 == 0 ? 1 : n3);
        }
        return n;
    }

    public static boolean hasOnlyOneElement(Collection<?> collection) {
        return CollectionHelper.size(collection) == 1;
    }

    public static List<Integer> intRange(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Range max must be grater than min");
        }
        int n3 = n2 - n + 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n3);
        for (int i = n; i <= n2; ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static <T> boolean isEmptyIgnoring(Collection<T> collection, Collection<T> collection2) {
        HashSet<T> hashSet = new HashSet<T>(CollectionHelper.orEmpty(collection));
        hashSet.removeAll(collection2);
        return hashSet.isEmpty();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return !CollectionHelper.isEmpty(iterable);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionHelper.isEmpty(map);
    }

    public static boolean isNotEmpty(Object[] objectArray) {
        return !CollectionHelper.isEmpty(objectArray);
    }

    public static <T> Iterable<T> iterable(Enumeration<T> enumeration) {
        return CollectionHelper.iterable(CollectionHelper.toIterator(enumeration));
    }

    public static <T> Iterable<T> iterable(Iterator<T> iterator) {
        if (iterator == null) {
            return Collections.emptyList();
        }
        return () -> iterator;
    }

    public static String join(Iterable<?> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iterable != null) {
            boolean bl = true;
            for (Object obj : iterable) {
                if (bl) {
                    bl = false;
                } else if (string != null) {
                    stringBuilder.append(string);
                }
                if (obj == null) continue;
                stringBuilder.append(obj.toString());
            }
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string) {
        return CollectionHelper.join(objectArray == null ? null : Arrays.asList(objectArray), string);
    }

    public static <T> T last(List<T> list) {
        return CollectionHelper.isEmpty(list) ? null : (T)list.get(list.size() - 1);
    }

    public static int length(Object[] objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static <I, O> List<O> map(Collection<I> collection, Function<I, O> function) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<O> arrayList = new ArrayList<O>(collection.size());
        for (I i : collection) {
            arrayList.add(function.apply(i));
        }
        return arrayList;
    }

    public static <T, V> boolean matchesAll(Collection<T> collection, Collection<V> collection2, BiPredicate<T, V> biPredicate) {
        int n = CollectionHelper.size(collection);
        int n2 = CollectionHelper.size(collection2);
        if (n2 == 0) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        return collection2.stream().allMatch(object -> collection.stream().anyMatch(object2 -> biPredicate.test(object2, object)));
    }

    public static Object maybeUnwrap(Collection<?> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return null;
        }
        return collection.size() == 1 ? CollectionHelper.first(collection) : collection;
    }

    public static Map<String, Object> nestKeys(Map<String, String> map, String string) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            List<String> list = StringHelper.splitTrimming(entry.getKey(), string);
            Map<String, Object> map2 = treeMap;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                String string2 = list.get(i);
                boolean bl2 = bl = i == n - 1;
                if (bl) {
                    map2.put(string2, map.get(entry.getKey()));
                    continue;
                }
                Object object = map2.get(string2);
                if (!(object instanceof Map)) {
                    object = new TreeMap();
                    map2.put(string2, object);
                }
                map2 = (Map)object;
            }
        }
        return treeMap;
    }

    public static <T> Collection<T> orEmpty(Collection<T> collection) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public static <T> List<T> orEmpty(List<T> list) {
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public static <K, V> Map<K, V> orEmpty(Map<K, V> map) {
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map;
    }

    public static <T> Set<T> orEmpty(Set<T> set) {
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public static <T> T random(List<T> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        int n = (int)(Math.random() * (double)list.size());
        return list.get(n);
    }

    public static void removeNulls(Collection<?> collection) {
        if (collection != null) {
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
            }
        }
    }

    public static int size(Collection<?> collection) {
        if (collection != null) {
            return collection.size();
        }
        return 0;
    }

    public static int size(Map<?, ?> map) {
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    public static int size(Object[] objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static <T extends Comparable<? super T>> List<T> sort(Collection<T> collection) {
        return CollectionHelper.sort(collection, null);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<T> arrayList = collection instanceof List ? (ArrayList<T>)collection : new ArrayList<T>(collection);
        try {
            arrayList.sort(comparator);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            arrayList = new ArrayList<T>(arrayList);
            arrayList.sort(comparator);
        }
        return arrayList;
    }

    public static <T> List<List<T>> split(List<T> list, int n) {
        if (CollectionHelper.isEmpty(list)) {
            return Collections.emptyList();
        }
        int n2 = list.size();
        ArrayList<List<T>> arrayList = new ArrayList<List<T>>((int)Math.ceil((double)list.size() / (double)n));
        for (int i = 0; i < n2; i += n) {
            List<T> list2 = list.subList(i, Math.min(i + n, n2));
            arrayList.add(list2);
        }
        return arrayList;
    }

    public static <T> Iterator<T> toIterator(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Collection<T> union(Collection<T> collection, Collection<T> collection2) {
        boolean bl = CollectionHelper.isEmpty(collection);
        boolean bl2 = CollectionHelper.isEmpty(collection2);
        if (bl && bl2) {
            return Collections.emptyList();
        }
        if (bl) {
            return collection2;
        }
        if (bl2) {
            return collection;
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.addAll(collection2);
        return arrayList;
    }

    private static void collectKeys(Map<String, String> map, String string, String string2, Map<String, ?> map2) {
        if (CollectionHelper.isEmpty(map2)) {
            return;
        }
        for (Map.Entry<String, ?> entry : map2.entrySet()) {
            String string3;
            String string4 = entry.getKey();
            Object obj = entry.getValue();
            String string5 = string3 = string == "" ? string4 : string + string2 + string4;
            if (obj instanceof String) {
                map.put(string3, (String)obj);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            CollectionHelper.collectKeys(map, string3, string2, (Map)obj);
        }
    }
}

