/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.cyclos.utils.GwtIncompatible;
import org.cyclos.utils.IDate;
import org.cyclos.utils.StringHelper;

public class DateTime
implements IDate,
Comparable<DateTime>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CLASS_NAME = "org.cyclos.utils.DateTime";
    public static final Comparator<DateTime> COMPARATOR = Comparator.comparing(DateTime::getYear).thenComparing(Comparator.comparing(DateTime::getMonth)).thenComparing(Comparator.comparing(DateTime::getDate)).thenComparing(Comparator.comparing(DateTime::getHours)).thenComparing(Comparator.comparing(DateTime::getMinutes)).thenComparing(Comparator.comparing(DateTime::getSeconds)).thenComparing(Comparator.comparing(DateTime::getMilliseconds)).thenComparing(Comparator.comparing(DateTime::getTimeZone, Comparator.nullsLast(Comparator.naturalOrder())));
    public static final int MAX_YEAR = 9999;
    public static final int MAX_MONTH = 11;
    public static final int MAX_HOUR = 23;
    public static final int MAX_MINUTE = 59;
    public static final int MAX_SECOND = 59;
    public static final int MAX_MILLISECOND = 999;
    private int year;
    private int month;
    private int date;
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;
    private String timeZone;

    @GwtIncompatible
    public static DateTime of(OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : new DateTime(offsetDateTime);
    }

    public static DateTime parse(String string) {
        if (StringHelper.isBlank(string)) {
            return null;
        }
        return new DateTime(string);
    }

    private static int getMaxDate(int n, int n2) {
        switch (n) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 1: {
                return n2 % 400 == 0 || n2 % 4 == 0 && n2 % 100 != 0 ? 29 : 28;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        throw new IllegalArgumentException("Invalid month ordinal. It must ve between 0 - 11");
    }

    private static int parse(String string, int n) {
        return DateTime.parse(string, 0, 0, n);
    }

    private static int parse(String string, int n, int n2, int n3) {
        int n4 = Integer.parseInt(string) + n;
        if (n4 < n2 || n4 > n3) {
            throw new IllegalArgumentException("Value outside range: " + n4 + " should be between " + n2 + " and " + n3);
        }
        return n4;
    }

    public DateTime() {
    }

    public DateTime(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0, 0, null);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0, 0, null);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, 0, null);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n, n2, n3, n4, n5, n6, n7, null);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        this.setYMD(n, n2, n3);
        this.setHMSM(n4, n5, n6, n7);
        this.setTimeZone(string);
    }

    @GwtIncompatible
    public DateTime(OffsetDateTime offsetDateTime) {
        this(offsetDateTime.getYear(), offsetDateTime.getMonthValue() - 1, offsetDateTime.getDayOfMonth(), offsetDateTime.getHour(), offsetDateTime.getMinute(), offsetDateTime.getSecond(), offsetDateTime.getNano() / 1000000, offsetDateTime.getOffset().getId());
    }

    public DateTime(String string) {
        this(string, false);
    }

    public DateTime(String string, boolean bl) {
        String string2;
        List<String> list;
        string = StringHelper.trimToNull(string);
        if (string == null) {
            return;
        }
        List<String> list2 = StringHelper.splitTrimming(string, "T");
        if (list2.size() == 1) {
            list2 = StringHelper.splitTrimming(string, " ");
        }
        if ((list = StringHelper.splitTrimming(string2 = list2.get(0), "-")).size() != 3) {
            throw new IllegalArgumentException("Invalid date/time: " + string);
        }
        try {
            this.setYear(DateTime.parse(list.get(0), 0, 1, 9999));
            this.setMonth(DateTime.parse(list.get(1), -1, 0, 11));
            this.setDate(DateTime.parse(list.get(2), DateTime.getMaxDate(this.getMonth(), this.getYear())));
            if (list2.size() == 2) {
                String string3 = list2.get(1);
                int n = string3.indexOf(45);
                if (n < 0) {
                    n = string3.indexOf(43);
                }
                if (n < 0) {
                    n = string3.indexOf(90);
                }
                if (n >= 0) {
                    this.setTimeZone(string3.substring(n));
                    string3 = string3.substring(0, n);
                }
                if (!string3.isEmpty()) {
                    List<String> list3 = StringHelper.split(string3.replace('.', ':'), ":");
                    this.setHours(DateTime.parse(list3.get(0), 23));
                    if (list3.size() > 1) {
                        this.setMinutes(DateTime.parse(list3.get(1), 59));
                    }
                    if (list3.size() > 2) {
                        this.setSeconds(DateTime.parse(list3.get(2), 59));
                    }
                    if (list3.size() > 3) {
                        this.setMilliseconds(DateTime.parse(list3.get(3), 999));
                    }
                }
            } else if (bl) {
                this.setHours(23);
                this.setMinutes(59);
                this.setSeconds(59);
                this.setMilliseconds(999);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string, exception);
        }
    }

    @GwtIncompatible
    public DateTime(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.getYear(), zonedDateTime.getMonthValue() - 1, zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.getNano() / 1000000, zonedDateTime.getOffset().getId());
    }

    public DateTime add(long l) throws IllegalArgumentException {
        if (l == 0L) {
            return this;
        }
        int n = (int)((l += (long)this.getMilliseconds()) % 1000L);
        l = this.getSeconds() + (int)Math.floor(l / 1000L);
        int n2 = (int)(l % 60L);
        l = this.getMinutes() + (int)Math.floor(l / 60L);
        int n3 = (int)(l % 60L);
        l = this.getHours() + (int)Math.floor(l / 60L);
        int n4 = (int)(l % 24L);
        int n5 = this.getDate() + (int)Math.floor(l / 24L);
        int n6 = this.getMonth();
        int n7 = this.getYear();
        int n8 = DateTime.getMaxDate(n6, this.getYear());
        while (n5 - n8 > 0) {
            n5 -= n8;
            if ((n6 = (n6 + 1) % 12) == 0) {
                ++n7;
            }
            n8 = DateTime.getMaxDate(n6, n7);
        }
        this.setYMD(n7, n6, n5);
        this.setHMSM(n4, n3, n2, n);
        return this;
    }

    public boolean after(DateTime dateTime) {
        return this.compareTo(dateTime) > 0;
    }

    public boolean afterOrEquals(DateTime dateTime) {
        return this.compareTo(dateTime) >= 0;
    }

    public boolean before(DateTime dateTime) {
        return this.compareTo(dateTime) < 0;
    }

    public boolean beforeOrEquals(DateTime dateTime) {
        return this.compareTo(dateTime) <= 0;
    }

    @GwtIncompatible
    public DateTime clone() {
        DateTime dateTime = new DateTime();
        dateTime.year = this.year;
        dateTime.month = this.month;
        dateTime.date = this.date;
        dateTime.hours = this.hours;
        dateTime.minutes = this.minutes;
        dateTime.seconds = this.seconds;
        dateTime.milliseconds = this.milliseconds;
        dateTime.timeZone = this.timeZone;
        return dateTime;
    }

    @Override
    public int compareTo(DateTime dateTime) {
        if (dateTime == null) {
            return -1;
        }
        return COMPARATOR.compare(this, dateTime);
    }

    public DateTime decDate() {
        int n = this.getDate();
        if (n == 1) {
            this.decMonth();
            this.setDate(this.getMaxDate());
        } else {
            this.setDate(n - 1);
        }
        return this;
    }

    public DateTime decMonth() {
        int n = this.getMonth();
        if (n == 0) {
            this.setMonth(11);
            this.decYear();
        } else {
            this.setMonth(n - 1);
        }
        return this;
    }

    public DateTime decYear() {
        this.setYear(this.getYear() - 1);
        return this;
    }

    public DateTime duplicate() {
        DateTime dateTime = new DateTime();
        dateTime.setYear(this.getYear());
        dateTime.setMonth(this.getMonth());
        dateTime.setDate(this.getDate());
        dateTime.setHours(this.getHours());
        dateTime.setMinutes(this.getMinutes());
        dateTime.setSeconds(this.getSeconds());
        dateTime.setMilliseconds(this.getMilliseconds());
        dateTime.setTimeZone(this.getTimeZone());
        return dateTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)object;
        return this.getYear() == dateTime.getYear() && this.getMonth() == dateTime.getMonth() && this.getDate() == dateTime.getDate() && this.getHours() == dateTime.getHours() && this.getMinutes() == dateTime.getMinutes() && this.getSeconds() == dateTime.getSeconds() && this.getMilliseconds() == dateTime.getMilliseconds() && Objects.equals(this.getTimeZone(), dateTime.getTimeZone());
    }

    public int getDate() {
        return this.date;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getMonth() {
        return this.month;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        return Objects.hash(this.getYear(), this.getMonth(), this.getDate(), this.getHours(), this.getMinutes(), this.getSeconds(), this.getMilliseconds(), this.getTimeZone());
    }

    public DateTime incDate() {
        int n = this.getDate();
        if (n == this.getMaxDate()) {
            this.setDate(1);
            this.incMonth();
        } else {
            this.setDate(n + 1);
        }
        return this;
    }

    public DateTime incMonth() {
        int n = this.getMonth();
        if (n == 11) {
            this.setMonth(0);
            this.incYear();
        } else {
            this.setMonth(n + 1);
        }
        return this;
    }

    public DateTime incYear() {
        this.setYear(this.getYear() + 1);
        return this;
    }

    public boolean isSameDay(DateTime dateTime) {
        if (dateTime == null) {
            return false;
        }
        return this.getYear() == dateTime.getYear() && this.getMonth() == dateTime.getMonth() && this.getDate() == dateTime.getDate();
    }

    public void setDate(int n) {
        this.date = Math.min(n, this.getMaxDate());
    }

    public void setHMSM(int n, int n2, int n3, int n4) {
        this.setHours(n);
        this.setMinutes(n2);
        this.setSeconds(n3);
        this.setMilliseconds(n4);
    }

    public void setHours(int n) {
        this.hours = Math.max(0, Math.min(n, 23));
    }

    public void setMilliseconds(int n) {
        this.milliseconds = Math.max(0, Math.min(n, 999));
    }

    public void setMinutes(int n) {
        this.minutes = Math.max(0, Math.min(n, 59));
    }

    public void setMonth(int n) {
        this.month = Math.max(0, Math.min(n, 11));
    }

    public void setSeconds(int n) {
        this.seconds = Math.max(0, Math.min(n, 59));
    }

    public void setTimeZone(String string) {
        this.timeZone = string;
    }

    public void setYear(int n) {
        this.year = Math.max(0, Math.min(n, 9999));
        this.setDate(Math.max(1, Math.min(this.getDate(), this.getMaxDate())));
    }

    public void setYMD(int n, int n2, int n3) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDate(n3);
    }

    public String toDateString() {
        return StringHelper.leftPad(String.valueOf(this.getYear()), 4, '0') + "-" + StringHelper.leftPad(String.valueOf(this.getMonth() + 1), 2, '0') + "-" + StringHelper.leftPad(String.valueOf(this.getDate()), 2, '0');
    }

    @GwtIncompatible
    public LocalDate toLocalDate() {
        return LocalDate.of(this.getYear(), this.getMonth() + 1, this.getDate());
    }

    @GwtIncompatible
    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.getYear(), this.getMonth() + 1, this.getDate(), this.getHours(), this.getMinutes(), this.getSeconds());
    }

    @GwtIncompatible
    public OffsetDateTime toOffsetDateTime(ZoneId zoneId) {
        LocalDateTime localDateTime = this.toLocalDateTime();
        ZoneOffset zoneOffset = null;
        try {
            if (!StringHelper.isBlank(this.timeZone)) {
                zoneOffset = ZoneOffset.of(this.timeZone);
            }
        }
        catch (Exception exception) {
            try {
                zoneOffset = ZoneId.of(this.timeZone).getRules().getOffset(localDateTime);
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("Invalid timezone: " + this.timeZone);
            }
        }
        if (zoneOffset == null) {
            zoneOffset = zoneId.getRules().getOffset(localDateTime);
        }
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    public String toString() {
        String string = this.toDateString() + "T" + this.toTimeString();
        String string2 = this.getTimeZone();
        if (string2 != null) {
            string = string + string2;
        }
        return string;
    }

    public String toTimeString() {
        return StringHelper.leftPad(String.valueOf(this.getHours()), 2, '0') + ":" + StringHelper.leftPad(String.valueOf(this.getMinutes()), 2, '0') + ":" + StringHelper.leftPad(String.valueOf(this.getSeconds()), 2, '0') + "." + StringHelper.leftPad(String.valueOf(this.getMilliseconds()), 3, '0');
    }

    private int getMaxDate() {
        return DateTime.getMaxDate(this.getMonth(), this.getYear());
    }
}

