/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;

public class MaskHelper {
    private static final Random random = new Random();
    public static final String MASK_VARIABLES = "#09aAlLuUcC?_";
    public static final String CONFUSING_CHARS = "BGIOQSbgiloqs0125689";
    private static final char[] DIGITS = "0123456789".toCharArray();
    private static final char[] SAFE_DIGITS = MaskHelper.excludeConfusingChars(DIGITS);
    private static final char[] UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] SAFE_UPPERCASE = MaskHelper.excludeConfusingChars(UPPERCASE);
    private static final char[] LOWERCASE = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] SAFE_LOWERCASE = MaskHelper.excludeConfusingChars(LOWERCASE);
    private static final char[] LETTERS = (new String(UPPERCASE) + new String(LOWERCASE)).toCharArray();
    private static final char[] SAFE_LETTERS = MaskHelper.excludeConfusingChars(LETTERS);
    private static final char[] ASCII = (new String(DIGITS) + new String(LETTERS)).toCharArray();
    private static final char[] SAFE_ASCII = MaskHelper.excludeConfusingChars(ASCII);

    public static String applyAndValidateMask(String string, String string2) {
        if (MaskHelper.isValidMaskedValue(string, string2) || string2 == null) {
            return string2;
        }
        String string3 = MaskHelper.applyMask(string, string2);
        if (MaskHelper.isValidMaskedValue(string, string3)) {
            return string3;
        }
        throw new IllegalArgumentException("Can not apply the mask (" + string + "): invalid value (" + string2 + ")");
    }

    public static String applyMask(String string, String string2) {
        if (StringHelper.isBlank(string) || string2 == null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (!bl && MASK_VARIABLES.indexOf(c) >= 0) {
                if (n >= string2.length()) {
                    return stringBuilder.toString();
                }
                char c2 = string2.charAt(n++);
                switch (c) {
                    case 'L': 
                    case 'l': {
                        c2 = Character.toLowerCase(c2);
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        c2 = Character.toUpperCase(c2);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        int n2 = stringBuilder.length();
                        boolean bl2 = n2 == 0 || !Character.isLetter(stringBuilder.charAt(n2 - 1));
                        c2 = bl2 ? Character.toUpperCase(c2) : Character.toLowerCase(c2);
                    }
                }
                stringBuilder.append(c2);
                continue;
            }
            bl = false;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int countPlaceholders(String string) {
        int n = 0;
        if (string != null) {
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl) {
                    bl = false;
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (MASK_VARIABLES.indexOf(c) < 0) continue;
                ++n;
            }
        }
        return n;
    }

    public static String generateMaskedValue(String string) {
        if (StringHelper.isBlank(string)) {
            throw new IllegalArgumentException("Can't generate a random value using a blank/null mask");
        }
        boolean bl = MaskHelper.usesMixedChars(string);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuilder.append(c);
                bl2 = false;
                continue;
            }
            if (c == '\\') {
                bl2 = true;
                continue;
            }
            switch (c) {
                case '#': 
                case '0': 
                case '9': {
                    stringBuilder.append(MaskHelper.randomChar(bl ? SAFE_DIGITS : DIGITS));
                    continue block8;
                }
                case 'A': 
                case 'a': {
                    stringBuilder.append(MaskHelper.randomChar(bl ? SAFE_LETTERS : LETTERS));
                    continue block8;
                }
                case 'L': 
                case 'l': {
                    stringBuilder.append(MaskHelper.randomChar(bl ? SAFE_LOWERCASE : LOWERCASE));
                    continue block8;
                }
                case 'U': 
                case 'u': {
                    stringBuilder.append(MaskHelper.randomChar(bl ? SAFE_UPPERCASE : UPPERCASE));
                    continue block8;
                }
                case 'C': 
                case 'c': {
                    boolean bl3;
                    boolean bl4 = bl3 = stringBuilder.length() > 0 && Character.isLetter(stringBuilder.charAt(stringBuilder.length() - 1));
                    if (bl3) {
                        stringBuilder.append(MaskHelper.randomChar(bl ? SAFE_LOWERCASE : LOWERCASE));
                        continue block8;
                    }
                    stringBuilder.append(MaskHelper.randomChar(bl ? SAFE_UPPERCASE : UPPERCASE));
                    continue block8;
                }
                case '?': 
                case '_': {
                    stringBuilder.append(MaskHelper.randomChar(SAFE_ASCII));
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String generateValue(String string) {
        return MaskHelper.generateValue(string, false);
    }

    public static String generateValue(String string, boolean bl) {
        String string2 = MaskHelper.generateMaskedValue(string);
        if (bl) {
            return string2;
        }
        return MaskHelper.removeMask(string, string2);
    }

    public static List<Character> getAlphabeticVariables() {
        return Arrays.asList(Character.valueOf('a'), Character.valueOf('A'));
    }

    public static List<Character> getAlphanumericVariables() {
        return Arrays.asList(Character.valueOf('?'), Character.valueOf('_'));
    }

    public static String getExample(String string) {
        if (StringHelper.isBlank(string)) {
            return null;
        }
        int n = 1;
        char c = 'A';
        char c2 = 'a';
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char c3 = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c4 = string.charAt(i);
            if (!bl && c4 == '\\') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(c4);
            } else if ("aAuU?_".indexOf(c4) >= 0 || "cC".indexOf(c4) >= 0 && "cC".indexOf(c3) < 0) {
                stringBuilder.append(c);
                c = (char)(c == 'Z' ? 65 : c + '\u0001');
            } else if ("lL".indexOf(c4) >= 0 || "cC".indexOf(c4) >= 0) {
                stringBuilder.append(c2);
                c2 = (char)(c2 == 'Z' ? 65 : c2 + '\u0001');
            } else if ("#09".indexOf(c4) >= 0) {
                stringBuilder.append(n);
                n = n == 9 ? 0 : n + 1;
            } else {
                stringBuilder.append(c4);
            }
            bl = false;
            c3 = c4;
        }
        return stringBuilder.toString();
    }

    public static int getMaskedValueLength(String string) {
        String string2 = string;
        if (string.indexOf("\\") != -1) {
            String string3 = "@@DBL_BS@@";
            string2 = StringHelper.replace(string, "\\\\", string3);
            string2 = StringHelper.replace(string2, "\\", "");
            string2 = StringHelper.replace(string2, string3, "\\");
        }
        return string2.length();
    }

    public static List<Character> getNumericVariables() {
        return Arrays.asList(Character.valueOf('#'), Character.valueOf('0'), Character.valueOf('9'));
    }

    public static boolean hasValidBeginning(String string, String string2) {
        if (StringHelper.isBlank(string) || StringHelper.isBlank(string2)) {
            return true;
        }
        int n = MaskHelper.getMaskedValueLength(string);
        if (string2.length() > n) {
            return false;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length() && n2 < string2.length(); ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(n2);
            if (n != 0) {
                if (c2 != c) {
                    return false;
                }
                n = 0;
            } else {
                char c3;
                if (c == '\\') {
                    n = 1;
                    continue;
                }
                char c4 = c3 = n2 == 0 ? (char)'\n' : (char)string2.charAt(n2 - 1);
                if (!MaskHelper.isValidChar(c, c2, c3)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValidMask(String string) {
        if (StringHelper.isBlank(string)) {
            return true;
        }
        if (string.contains("/") || string.contains("\\\\")) {
            return false;
        }
        String string2 = string.replaceAll("\\\\.", "");
        boolean bl = false;
        for (int i = 0; i < MASK_VARIABLES.length(); ++i) {
            if (!string2.contains("" + MASK_VARIABLES.charAt(i))) continue;
            bl = true;
            break;
        }
        return !string2.contains("\\") && bl;
    }

    public static boolean isValidMaskedValue(String string, String string2) {
        if (StringHelper.isBlank(string)) {
            return true;
        }
        if (StringHelper.isBlank(string2)) {
            return false;
        }
        int n = MaskHelper.getMaskedValueLength(string);
        if (string2.length() != n) {
            return false;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(n2);
            if (n != 0) {
                if (c2 != c) {
                    return false;
                }
                n = 0;
            } else {
                char c3;
                if (c == '\\') {
                    n = 1;
                    continue;
                }
                char c4 = c3 = n2 == 0 ? (char)'\n' : (char)string2.charAt(n2 - 1);
                if (!MaskHelper.isValidChar(c, c2, c3)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static String removeAndValidateMask(String string, String string2) {
        if (MaskHelper.isValidMaskedValue(string, string2) || string2 == null) {
            return MaskHelper.removeMask(string, string2);
        }
        String string3 = MaskHelper.applyMask(string, string2);
        if (MaskHelper.isValidMaskedValue(string, string3)) {
            return string2;
        }
        throw new IllegalArgumentException("Can not remove the mask (" + string + "): invalid value (" + string2 + ")");
    }

    public static String removeMask(String string, String string2) {
        return MaskHelper.removeMask(string, string2, true);
    }

    public static String removeMask(String string, String string2, boolean bl) {
        if (StringHelper.isBlank(string) || string2 == null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                bl2 = true;
                continue;
            }
            if (!bl2 && MASK_VARIABLES.indexOf(c) >= 0) {
                if (n >= string2.length()) break;
                stringBuilder.append(string2.charAt(n++));
                continue;
            }
            if (string2.length() <= n || string2.charAt(n) != c) continue;
            bl2 = false;
            ++n;
        }
        if (!bl && string2.length() > n) {
            stringBuilder.append(string2.substring(n));
        }
        return stringBuilder.toString();
    }

    public static String unescapeMask(String string) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        return string.replaceAll("\\\\([#09aAlLuUcC?_\\\\])", "$1");
    }

    protected static boolean usesMixedChars(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl4) {
                bl4 = false;
                continue;
            }
            if (c == '\\') {
                bl4 = true;
                continue;
            }
            switch (c) {
                case '#': 
                case '0': 
                case '9': {
                    bl = true;
                    continue block7;
                }
                case 'A': 
                case 'C': 
                case 'a': 
                case 'c': {
                    bl2 = true;
                    bl3 = true;
                    continue block7;
                }
                case 'U': 
                case 'u': {
                    bl2 = true;
                    continue block7;
                }
                case 'L': 
                case 'l': {
                    bl3 = true;
                    continue block7;
                }
                case '?': 
                case '_': {
                    bl = true;
                    bl2 = true;
                    bl3 = true;
                }
            }
        }
        return (bl ? 1 : 0) + (bl2 ? 1 : 0) + (bl3 ? 1 : 0) > 1;
    }

    private static char[] excludeConfusingChars(char[] cArray) {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (char c : cArray) {
            if (CONFUSING_CHARS.contains(String.valueOf(c))) continue;
            arrayList.add(Character.valueOf(c));
        }
        char[] cArray2 = new char[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            cArray2[i] = ((Character)arrayList.get(i)).charValue();
        }
        return cArray2;
    }

    private static boolean isValidChar(char c, char c2, char c3) {
        return !(ObjectHelper.isOneOf(Character.valueOf(c), Character.valueOf('#'), Character.valueOf('0'), Character.valueOf('9')) ? !Character.isDigit(c2) : (ObjectHelper.isOneOf(Character.valueOf(c), Character.valueOf('a'), Character.valueOf('A')) ? !Character.isLetter(c2) : (ObjectHelper.isOneOf(Character.valueOf(c), Character.valueOf('l'), Character.valueOf('L')) ? !Character.isLowerCase(c2) : (ObjectHelper.isOneOf(Character.valueOf(c), Character.valueOf('u'), Character.valueOf('U')) ? !Character.isUpperCase(c2) : (ObjectHelper.isOneOf(Character.valueOf(c), Character.valueOf('c'), Character.valueOf('C')) ? (Character.isLetter(c3) ? !Character.isLowerCase(c2) : !Character.isUpperCase(c2)) : (ObjectHelper.isOneOf(Character.valueOf(c), Character.valueOf('?'), Character.valueOf('_')) ? !Character.isDigit(c2) && !Character.isLetter(c2) : c2 != c))))));
    }

    private static char randomChar(char[] cArray) {
        return cArray[random.nextInt(cArray.length)];
    }
}

