/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.io.Serializable;
import java.util.Objects;

public class Pair<First, Second>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Pair PAIR_OF_NULL = Pair.create(null, null);
    private First first;
    private Second second;

    public static <F, S> Pair<F, S> create(F f, S s) {
        return new Pair<F, S>(f, s);
    }

    public static <F, S> Pair<F, S> createOnlyFirst(F f) {
        return new Pair<F, Object>(f, null);
    }

    public static <F, S> Pair<F, S> createOnlySecond(S s) {
        return Pair.create(null, s);
    }

    public static <F, S> Pair<F, S> ofNulls() {
        return PAIR_OF_NULL;
    }

    public Pair() {
    }

    public Pair(First First, Second Second) {
        this.first = First;
        this.second = Second;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)object;
        return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
    }

    public First getFirst() {
        return this.first;
    }

    public Second getSecond() {
        return this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public void setFirst(First First) {
        this.first = First;
    }

    public void setSecond(Second Second) {
        this.second = Second;
    }

    public String toString() {
        return "<" + String.valueOf(this.first) + "," + String.valueOf(this.second) + ">";
    }
}

