-- Cyclos4 Database Script 

-- Create required extensions
create extension IF NOT EXISTS cube;
create extension IF NOT EXISTS earthdistance;
create extension IF NOT EXISTS postgis;
create extension IF NOT EXISTS unaccent;
create extension IF NOT EXISTS pgcrypto;

-- FUNCTIONS USED ON INDEXES (delimited with EOF)
DELIMITER EOF

-- Immutable (index-usable) version of the unaccent function
CREATE OR REPLACE FUNCTION public.cy_immutable_unaccent(text)
  RETURNS text AS
$$
SELECT public.unaccent('public.unaccent', $1)
$$ LANGUAGE sql IMMUTABLE PARALLEL SAFE STRICT
EOF

-- Revert the delimiter
DELIMITER ;

-- TABLES
