package v4_13

import org.apache.commons.lang3.mutable.MutableInt
import org.cyclos.entities.system.Configuration
import org.cyclos.entities.system.QConfiguration
import org.cyclos.entities.users.QGroup
import org.cyclos.entities.users.QOperator
import org.cyclos.entities.users.QUser
import org.cyclos.impl.access.ConfigurationHandler
import org.cyclos.impl.system.ConfigurationAccessor
import org.cyclos.impl.utils.QueryHelper
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler
import org.cyclos.model.users.users.EmailValidation
import org.cyclos.model.users.users.UserRegistration

import com.mysema.commons.lang.CloseableIterator
import com.querydsl.jpa.impl.JPAQuery

import groovy.transform.Field
import groovy.transform.TypeChecked

@Field RawEntityManagerHandler rawEntityManagerHandler = binding.rawEntityManagerHandler
@Field ConfigurationHandler configurationHandler = binding.configurationHandler
@Field QUser u = QUser.user
@Field QOperator op = new QOperator("op")

@TypeChecked
int process() {
    QConfiguration c = QConfiguration.configuration
    QGroup g = QGroup.group
    CloseableIterator<Configuration> configurations = rawEntityManagerHandler.selectFrom(c).iterate()
    MutableInt affected = new MutableInt();
    QueryHelper.processBatch(rawEntityManagerHandler, configurations) { Configuration config ->
        ConfigurationAccessor accessor = configurationHandler.getAccessor(config)
        Set<EmailValidation> validateOn = accessor.emailValidation
        Set<UserRegistration> updateRegistrations = []
        if (validateOn.contains(EmailValidation.PUBLIC_REGISTRATION)
        || validateOn.contains(EmailValidation.OPERATOR_REGISTRATION_BY_MEMBER)) {
            updateRegistrations << UserRegistration.PUBLIC
        }
        if (validateOn.contains(EmailValidation.REGISTRATION_BY_ADMIN)) {
            updateRegistrations << UserRegistration.ADMIN
        }
        if (validateOn.contains(EmailValidation.REGISTRATION_BY_BROKER)) {
            updateRegistrations << UserRegistration.BROKER
        }
        if (validateOn.contains(EmailValidation.REGISTRATION_BY_MEMBER)) {
            updateRegistrations << UserRegistration.MEMBER
        }
        if (!updateRegistrations.empty) {
            // Update users
            int users = (int) rawEntityManagerHandler.update(u)
                    .set(u.emailVerified, true)
                    .where(
                    u.email.isNotNull(),
                    u.group().in(new JPAQuery().select(g).from(g).where(g.configuration().eq(config))),
                    u.registrationType.in(updateRegistrations))
                    .execute()
            // Update operators
            int operators = (int) rawEntityManagerHandler.update(op)
                    .set(op.emailVerified, true)
                    .where(
                    op.email.isNotNull(),
                    op.user().in(new JPAQuery().select(u).from(u).where(u.group().configuration().eq(config))),
                    op.registrationType.in(updateRegistrations))
                    .execute()
            affected.add(users + operators)
        }
    }
}

// Run the migration
return process()
