package v4_14

import java.sql.ResultSet

import org.cyclos.impl.storage.StoredFileHandler
import org.cyclos.model.EntityNotFoundException
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.jdbc.core.RowCallbackHandler

import groovy.transform.Field
import groovy.transform.TypeChecked

@Field StoredFileHandler storedFileHandler = binding.storedFileHandler
@Field JdbcTemplate jdbc = binding.jdbc

@TypeChecked
int process() {
    int affected = 0
    jdbc.query("select id from purge_theme_images", { ResultSet rs ->
        long id = rs.getLong(1)
        try {
            storedFileHandler.remove(id)
            affected++
        } catch (EntityNotFoundException e) {
            //ok, already removed, continue
        }
    } as RowCallbackHandler)
    jdbc.execute("drop table purge_theme_images")
    return affected
}

// Run the migration
return process()
