/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ClassElementValue;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnotations;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisibleAnnotations;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.MethodDelegateTypeMunger;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.bcel.BcelField;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.IdentityPointcutVisitor;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PerCflow;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerObject;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.PerTypeWithin;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.SimpleScope;
import org.aspectj.weaver.patterns.TypePattern;

public class AtAjAttributes {
    private static final List EMPTY_LIST = new ArrayList();
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String VALUE = "value";
    private static final String POINTCUT = "pointcut";
    private static final String THROWING = "throwing";
    private static final String RETURNING = "returning";
    private static final String STRING_DESC = "Ljava/lang/String;";

    public static boolean acceptAttribute(Attribute attribute) {
        return attribute instanceof RuntimeVisibleAnnotations;
    }

    public static List readAj5ClassAttributes(JavaClass javaClass, ReferenceType type, ISourceContext context, IMessageHandler msgHandler, boolean isCodeStyleAspect) {
        int j;
        int i;
        try {
            Constant[] cpool = javaClass.getConstantPool().getConstantPool();
            for (int i2 = 0; i2 < cpool.length; ++i2) {
                ConstantUtf8 constantUtf8;
                Constant constant = cpool[i2];
                if (constant == null || constant.getTag() != 1 || javaClass.getClassName().startsWith("org.aspectj.lang.annotation") || !"Lorg/aspectj/lang/annotation/DeclareAnnotation;".equals((constantUtf8 = (ConstantUtf8)constant).getBytes())) continue;
                msgHandler.handleMessage(new Message("Found @DeclareAnnotation while current release does not support it (see '" + type.getName() + "')", IMessage.WARNING, null, type.getSourceLocation()));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        AjAttributeStruct struct = new AjAttributeStruct(type, context, msgHandler);
        Attribute[] attributes = javaClass.getAttributes();
        boolean hasAtAspectAnnotation = false;
        boolean hasAtPrecedenceAnnotation = false;
        for (i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (!AtAjAttributes.acceptAttribute(attribute)) continue;
            RuntimeAnnotations rvs = (RuntimeAnnotations)attribute;
            if (isCodeStyleAspect || javaClass.isInterface()) break;
            hasAtAspectAnnotation = AtAjAttributes.handleAspectAnnotation(rvs, struct);
            hasAtPrecedenceAnnotation = AtAjAttributes.handlePrecedenceAnnotation(rvs, struct);
            break;
        }
        if (hasAtPrecedenceAnnotation && !hasAtAspectAnnotation) {
            msgHandler.handleMessage(new Message("Found @DeclarePrecedence on a non @Aspect type '" + type.getName() + "'", IMessage.WARNING, null, type.getSourceLocation()));
            return EMPTY_LIST;
        }
        if (!hasAtAspectAnnotation) {
            return EMPTY_LIST;
        }
        for (i = 0; i < javaClass.getMethods().length; ++i) {
            Method method = javaClass.getMethods()[i];
            if (method.getName().startsWith("ajc$")) continue;
            AjAttributeMethodStruct mstruct = new AjAttributeMethodStruct(method, null, type, context, msgHandler);
            Attribute[] mattributes = method.getAttributes();
            for (j = 0; j < mattributes.length; ++j) {
                Attribute mattribute = mattributes[j];
                if (!AtAjAttributes.acceptAttribute(mattribute)) continue;
                RuntimeAnnotations mrvs = (RuntimeAnnotations)mattribute;
                AtAjAttributes.handlePointcutAnnotation(mrvs, mstruct);
                break;
            }
            struct.ajAttributes.add(new AjAttribute.WeaverVersionInfo());
            struct.ajAttributes.addAll(mstruct.ajAttributes);
        }
        for (i = 0; i < javaClass.getFields().length; ++i) {
            Field field = javaClass.getFields()[i];
            if (field.getName().startsWith("ajc$")) continue;
            AjAttributeFieldStruct fstruct = new AjAttributeFieldStruct(field, null, type, context, msgHandler);
            Attribute[] fattributes = field.getAttributes();
            for (j = 0; j < fattributes.length; ++j) {
                Attribute fattribute = fattributes[j];
                if (!AtAjAttributes.acceptAttribute(fattribute)) continue;
                RuntimeAnnotations frvs = (RuntimeAnnotations)fattribute;
                if (!AtAjAttributes.handleDeclareErrorOrWarningAnnotation(frvs, fstruct) && !AtAjAttributes.handleDeclareParentsAnnotation(frvs, fstruct) || type.isAnnotationStyleAspect()) break;
                msgHandler.handleMessage(new Message("Found @AspectJ annotations in a non @Aspect type '" + type.getName() + "'", IMessage.WARNING, null, type.getSourceLocation()));
                break;
            }
            struct.ajAttributes.addAll(fstruct.ajAttributes);
        }
        return struct.ajAttributes;
    }

    public static List readAj5MethodAttributes(Method method, BcelMethod bMethod, ResolvedType type, ResolvedPointcutDefinition preResolvedPointcut, ISourceContext context, IMessageHandler msgHandler) {
        if (method.getName().startsWith("ajc$")) {
            return Collections.EMPTY_LIST;
        }
        AjAttributeMethodStruct struct = new AjAttributeMethodStruct(method, bMethod, type, context, msgHandler);
        Attribute[] attributes = method.getAttributes();
        boolean hasAtAspectJAnnotation = false;
        boolean hasAtAspectJAnnotationMustReturnVoid = false;
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            try {
                if (!AtAjAttributes.acceptAttribute(attribute)) continue;
                RuntimeAnnotations rvs = (RuntimeAnnotations)attribute;
                hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || AtAjAttributes.handleBeforeAnnotation(rvs, struct, preResolvedPointcut);
                hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || AtAjAttributes.handleAfterAnnotation(rvs, struct, preResolvedPointcut);
                hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || AtAjAttributes.handleAfterReturningAnnotation(rvs, struct, preResolvedPointcut, bMethod);
                hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || AtAjAttributes.handleAfterThrowingAnnotation(rvs, struct, preResolvedPointcut, bMethod);
                hasAtAspectJAnnotation = hasAtAspectJAnnotation || AtAjAttributes.handleAroundAnnotation(rvs, struct, preResolvedPointcut);
                break;
            }
            catch (ReturningFormalNotDeclaredInAdviceSignatureException e) {
                msgHandler.handleMessage(new Message(WeaverMessages.format("returningFormalNotDeclaredInAdvice", e.getFormalName()), IMessage.ERROR, null, bMethod.getSourceLocation()));
                continue;
            }
            catch (ThrownFormalNotDeclaredInAdviceSignatureException e) {
                msgHandler.handleMessage(new Message(WeaverMessages.format("thrownFormalNotDeclaredInAdvice", e.getFormalName()), IMessage.ERROR, null, bMethod.getSourceLocation()));
            }
        }
        boolean bl = hasAtAspectJAnnotation = hasAtAspectJAnnotation || hasAtAspectJAnnotationMustReturnVoid;
        if (hasAtAspectJAnnotation && !type.isAnnotationStyleAspect()) {
            msgHandler.handleMessage(new Message("Found @AspectJ annotations in a non @Aspect type '" + type.getName() + "'", IMessage.WARNING, null, type.getSourceLocation()));
        }
        if (hasAtAspectJAnnotation && !struct.method.isPublic()) {
            msgHandler.handleMessage(new Message("Found @AspectJ annotation on a non public advice '" + AtAjAttributes.methodToString(struct.method) + "'", IMessage.ERROR, null, type.getSourceLocation()));
        }
        if (hasAtAspectJAnnotation && struct.method.isStatic()) {
            msgHandler.handleMessage(MessageUtil.error("Advice cannot be declared static '" + AtAjAttributes.methodToString(struct.method) + "'", type.getSourceLocation()));
        }
        if (hasAtAspectJAnnotationMustReturnVoid && !Type.VOID.equals(struct.method.getReturnType())) {
            msgHandler.handleMessage(new Message("Found @AspectJ annotation on a non around advice not returning void '" + AtAjAttributes.methodToString(struct.method) + "'", IMessage.ERROR, null, type.getSourceLocation()));
        }
        return struct.ajAttributes;
    }

    public static List readAj5FieldAttributes(Field field, BcelField bField, ResolvedType type, ISourceContext context, IMessageHandler msgHandler) {
        return Collections.EMPTY_LIST;
    }

    private static boolean handleAspectAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeStruct struct) {
        Annotation aspect = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.ASPECT_ANNOTATION);
        if (aspect != null) {
            String perX;
            ElementNameValuePair aspectPerClause;
            boolean extendsAspect = false;
            if (!"java.lang.Object".equals(struct.enclosingType.getSuperclass().getName())) {
                if (!struct.enclosingType.getSuperclass().isAbstract() && struct.enclosingType.getSuperclass().isAspect()) {
                    AtAjAttributes.reportError("cannot extend a concrete aspect", struct);
                    return false;
                }
                extendsAspect = struct.enclosingType.getSuperclass().isAspect();
            }
            PerClause perClause = (aspectPerClause = AtAjAttributes.getAnnotationElement(aspect, VALUE)) == null ? (!extendsAspect ? new PerSingleton() : new PerFromSuper(struct.enclosingType.getSuperclass().getPerClause().getKind())) : ((perX = aspectPerClause.getValue().stringifyValue()) == null || perX.length() <= 0 ? new PerSingleton() : AtAjAttributes.parsePerClausePointcut(perX, struct));
            if (perClause == null) {
                return false;
            }
            perClause.setLocation(struct.context, -1, -1);
            struct.ajAttributes.add(new AjAttribute.WeaverVersionInfo());
            AjAttribute.Aspect aspectAttribute = new AjAttribute.Aspect(perClause);
            struct.ajAttributes.add(aspectAttribute);
            FormalBinding[] bindings = new FormalBinding[]{};
            BindingScope binding = new BindingScope(struct.enclosingType, struct.context, bindings);
            aspectAttribute.setResolutionScope(binding);
            return true;
        }
        return false;
    }

    private static PerClause parsePerClausePointcut(String perClauseString, AjAttributeStruct struct) {
        PerClause perClause;
        Pointcut pointcut = null;
        TypePattern typePattern = null;
        if (perClauseString.startsWith(PerClause.KindAnnotationPrefix.PERCFLOW.getName())) {
            String pointcutString = PerClause.KindAnnotationPrefix.PERCFLOW.extractPointcut(perClauseString);
            pointcut = AtAjAttributes.parsePointcut(pointcutString, struct, false);
            perClause = new PerCflow(pointcut, false);
        } else if (perClauseString.startsWith(PerClause.KindAnnotationPrefix.PERCFLOWBELOW.getName())) {
            String pointcutString = PerClause.KindAnnotationPrefix.PERCFLOWBELOW.extractPointcut(perClauseString);
            pointcut = AtAjAttributes.parsePointcut(pointcutString, struct, false);
            perClause = new PerCflow(pointcut, true);
        } else if (perClauseString.startsWith(PerClause.KindAnnotationPrefix.PERTARGET.getName())) {
            String pointcutString = PerClause.KindAnnotationPrefix.PERTARGET.extractPointcut(perClauseString);
            pointcut = AtAjAttributes.parsePointcut(pointcutString, struct, false);
            perClause = new PerObject(pointcut, false);
        } else if (perClauseString.startsWith(PerClause.KindAnnotationPrefix.PERTHIS.getName())) {
            String pointcutString = PerClause.KindAnnotationPrefix.PERTHIS.extractPointcut(perClauseString);
            pointcut = AtAjAttributes.parsePointcut(pointcutString, struct, false);
            perClause = new PerObject(pointcut, true);
        } else if (perClauseString.startsWith(PerClause.KindAnnotationPrefix.PERTYPEWITHIN.getName())) {
            String pointcutString = PerClause.KindAnnotationPrefix.PERTYPEWITHIN.extractPointcut(perClauseString);
            typePattern = AtAjAttributes.parseTypePattern(pointcutString, struct);
            perClause = new PerTypeWithin(typePattern);
        } else if (perClauseString.equalsIgnoreCase(PerClause.SINGLETON.getName() + "()")) {
            perClause = new PerSingleton();
        } else {
            AtAjAttributes.reportError("@Aspect per clause cannot be read '" + perClauseString + "'", struct);
            return null;
        }
        if (!PerClause.SINGLETON.equals(((PerClause)perClause).getKind()) && !PerClause.PERTYPEWITHIN.equals(((PerClause)perClause).getKind()) && pointcut == null) {
            return null;
        }
        if (PerClause.PERTYPEWITHIN.equals(((PerClause)perClause).getKind()) && typePattern == null) {
            return null;
        }
        return perClause;
    }

    private static boolean handlePrecedenceAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeStruct struct) {
        ElementNameValuePair precedence;
        Annotation aspect = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.DECLAREPRECEDENCE_ANNOTATION);
        if (aspect != null && (precedence = AtAjAttributes.getAnnotationElement(aspect, VALUE)) != null) {
            String precedencePattern = precedence.getValue().stringifyValue();
            PatternParser parser = new PatternParser(precedencePattern);
            DeclarePrecedence ajPrecedence = parser.parseDominates();
            struct.ajAttributes.add(new AjAttribute.DeclareAttribute(ajPrecedence));
            return true;
        }
        return false;
    }

    private static boolean handleDeclareParentsAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeFieldStruct struct) {
        ElementNameValuePair decpPatternNVP;
        String decpPattern;
        Annotation decp = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.DECLAREPARENTS_ANNOTATION);
        if (decp != null && (decpPattern = (decpPatternNVP = AtAjAttributes.getAnnotationElement(decp, VALUE)).getValue().stringifyValue()) != null) {
            TypePattern typePattern = AtAjAttributes.parseTypePattern(decpPattern, struct);
            ResolvedType fieldType = UnresolvedType.forSignature(struct.field.getSignature()).resolve(struct.enclosingType.getWorld());
            if (fieldType.isInterface()) {
                TypePattern parent = AtAjAttributes.parseTypePattern(fieldType.getName(), struct);
                FormalBinding[] bindings = new FormalBinding[]{};
                BindingScope binding = new BindingScope(struct.enclosingType, struct.context, bindings);
                ArrayList<TypePattern> parents = new ArrayList<TypePattern>(1);
                parents.add(parent);
                DeclareParents dp = new DeclareParents(typePattern, parents, false);
                dp.resolve(binding);
                typePattern = typePattern.resolveBindings(binding, Bindings.NONE, false, false);
                dp.setLocation(struct.context, -1, -1);
                struct.ajAttributes.add(new AjAttribute.DeclareAttribute(dp));
                String defaultImplClassName = null;
                ElementNameValuePair defaultImplNVP = AtAjAttributes.getAnnotationElement(decp, "defaultImpl");
                if (defaultImplNVP != null) {
                    ClassElementValue defaultImpl = (ClassElementValue)defaultImplNVP.getValue();
                    defaultImplClassName = UnresolvedType.forSignature(defaultImpl.getClassString()).getName();
                    if (defaultImplClassName.equals("org.aspectj.lang.annotation.DeclareParents")) {
                        defaultImplClassName = null;
                    } else {
                        ResolvedType impl = struct.enclosingType.getWorld().resolve(defaultImplClassName, false);
                        ResolvedMember[] mm = impl.getDeclaredMethods();
                        boolean hasNoCtorOrANoArgOne = true;
                        for (int i = 0; i < mm.length; ++i) {
                            ResolvedMember resolvedMember = mm[i];
                            if (resolvedMember.getName().equals("<init>")) {
                                hasNoCtorOrANoArgOne = false;
                                if (resolvedMember.getParameterTypes().length == 0 && resolvedMember.isPublic()) {
                                    hasNoCtorOrANoArgOne = true;
                                }
                            }
                            if (hasNoCtorOrANoArgOne) break;
                        }
                        if (!hasNoCtorOrANoArgOne) {
                            AtAjAttributes.reportError("@DeclareParents: defaultImpl=\"" + defaultImplClassName + "\" has no public no-arg constructor", struct);
                        }
                        if (!fieldType.isAssignableFrom(impl)) {
                            AtAjAttributes.reportError("@DeclareParents: defaultImpl=\"" + defaultImplClassName + "\" does not implement the interface '" + fieldType.toString() + "'", struct);
                        }
                    }
                }
                boolean hasAtLeastOneMethod = false;
                ResolvedMember[] methods = fieldType.getMethodsWithoutIterator(true, false).toArray(new ResolvedMember[0]);
                for (int i = 0; i < methods.length; ++i) {
                    ResolvedMember method = methods[i];
                    if (!method.isAbstract()) continue;
                    if (defaultImplClassName == null) {
                        AtAjAttributes.reportError("@DeclareParents: used with a non marker interface and no defaultImpl=\"...\" provided", struct);
                        return false;
                    }
                    hasAtLeastOneMethod = true;
                    struct.ajAttributes.add(new AjAttribute.TypeMunger(new MethodDelegateTypeMunger(method, struct.enclosingType, defaultImplClassName, typePattern)));
                }
                if (hasAtLeastOneMethod) {
                    struct.ajAttributes.add(new AjAttribute.TypeMunger(new MethodDelegateTypeMunger.FieldHostTypeMunger(AjcMemberMaker.itdAtDeclareParentsField(null, fieldType, struct.enclosingType), struct.enclosingType, typePattern)));
                }
                return true;
            }
            AtAjAttributes.reportError("@DeclareParents: can only be used on a field whose type is an interface", struct);
            return false;
        }
        return false;
    }

    private static boolean handleBeforeAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        ElementNameValuePair beforeAdvice;
        Annotation before = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.BEFORE_ANNOTATION);
        if (before != null && (beforeAdvice = AtAjAttributes.getAnnotationElement(before, VALUE)) != null) {
            FormalBinding[] bindings = new FormalBinding[]{};
            try {
                bindings = AtAjAttributes.extractBindings(struct);
            }
            catch (UnreadableDebugInfoException unreadableDebugInfoException) {
                return false;
            }
            BindingScope binding = new BindingScope(struct.enclosingType, struct.context, bindings);
            int extraArgument = AtAjAttributes.extractExtraArgument(struct.method);
            Pointcut pc = null;
            if (preResolvedPointcut != null) {
                pc = preResolvedPointcut.getPointcut();
            } else {
                pc = AtAjAttributes.parsePointcut(beforeAdvice.getValue().stringifyValue(), struct, false);
                if (pc == null) {
                    return false;
                }
                pc = pc.resolve(binding);
            }
            AtAjAttributes.setIgnoreUnboundBindingNames(pc, bindings);
            ISourceLocation sl = struct.context.makeSourceLocation(struct.bMethod.getDeclarationLineNumber(), struct.bMethod.getDeclarationOffset());
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.Before, pc, extraArgument, sl.getOffset(), sl.getOffset() + 1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAfterAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        ElementNameValuePair afterAdvice;
        Annotation after = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.AFTER_ANNOTATION);
        if (after != null && (afterAdvice = AtAjAttributes.getAnnotationElement(after, VALUE)) != null) {
            FormalBinding[] bindings = new FormalBinding[]{};
            try {
                bindings = AtAjAttributes.extractBindings(struct);
            }
            catch (UnreadableDebugInfoException unreadableDebugInfoException) {
                return false;
            }
            BindingScope binding = new BindingScope(struct.enclosingType, struct.context, bindings);
            int extraArgument = AtAjAttributes.extractExtraArgument(struct.method);
            Pointcut pc = null;
            if (preResolvedPointcut != null) {
                pc = preResolvedPointcut.getPointcut();
            } else {
                pc = AtAjAttributes.parsePointcut(afterAdvice.getValue().stringifyValue(), struct, false);
                if (pc == null) {
                    return false;
                }
                pc.resolve(binding);
            }
            AtAjAttributes.setIgnoreUnboundBindingNames(pc, bindings);
            ISourceLocation sl = struct.context.makeSourceLocation(struct.bMethod.getDeclarationLineNumber(), struct.bMethod.getDeclarationOffset());
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.After, pc, extraArgument, sl.getOffset(), sl.getOffset() + 1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAfterReturningAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut, BcelMethod owningMethod) throws ReturningFormalNotDeclaredInAdviceSignatureException {
        Annotation after = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.AFTERRETURNING_ANNOTATION);
        if (after != null) {
            ElementNameValuePair annValue = AtAjAttributes.getAnnotationElement(after, VALUE);
            ElementNameValuePair annPointcut = AtAjAttributes.getAnnotationElement(after, POINTCUT);
            ElementNameValuePair annReturned = AtAjAttributes.getAnnotationElement(after, RETURNING);
            String pointcut = null;
            String returned = null;
            if (annValue != null && annPointcut != null || annValue == null && annPointcut == null) {
                AtAjAttributes.reportError("@AfterReturning: either 'value' or 'poincut' must be provided, not both", struct);
                return false;
            }
            pointcut = annValue != null ? annValue.getValue().stringifyValue() : annPointcut.getValue().stringifyValue();
            if (AtAjAttributes.isNullOrEmpty(pointcut)) {
                AtAjAttributes.reportError("@AfterReturning: either 'value' or 'poincut' must be provided, not both", struct);
                return false;
            }
            if (annReturned != null) {
                returned = annReturned.getValue().stringifyValue();
                if (AtAjAttributes.isNullOrEmpty(returned)) {
                    returned = null;
                } else {
                    String[] pNames = owningMethod.getParameterNames();
                    if (pNames == null || pNames.length == 0 || !Arrays.asList(pNames).contains(returned)) {
                        throw new ReturningFormalNotDeclaredInAdviceSignatureException(returned);
                    }
                }
            }
            FormalBinding[] bindings = new FormalBinding[]{};
            try {
                bindings = returned == null ? AtAjAttributes.extractBindings(struct) : AtAjAttributes.extractBindings(struct, returned);
            }
            catch (UnreadableDebugInfoException unreadableDebugInfoException) {
                return false;
            }
            BindingScope binding = new BindingScope(struct.enclosingType, struct.context, bindings);
            int extraArgument = AtAjAttributes.extractExtraArgument(struct.method);
            if (returned != null) {
                extraArgument |= 1;
            }
            Pointcut pc = null;
            if (preResolvedPointcut != null) {
                pc = preResolvedPointcut.getPointcut();
            } else {
                pc = AtAjAttributes.parsePointcut(pointcut, struct, false);
                if (pc == null) {
                    return false;
                }
                pc.resolve(binding);
            }
            AtAjAttributes.setIgnoreUnboundBindingNames(pc, bindings);
            ISourceLocation sl = struct.context.makeSourceLocation(struct.bMethod.getDeclarationLineNumber(), struct.bMethod.getDeclarationOffset());
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.AfterReturning, pc, extraArgument, sl.getOffset(), sl.getOffset() + 1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAfterThrowingAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut, BcelMethod owningMethod) throws ThrownFormalNotDeclaredInAdviceSignatureException {
        Annotation after = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.AFTERTHROWING_ANNOTATION);
        if (after != null) {
            ElementNameValuePair annValue = AtAjAttributes.getAnnotationElement(after, VALUE);
            ElementNameValuePair annPointcut = AtAjAttributes.getAnnotationElement(after, POINTCUT);
            ElementNameValuePair annThrown = AtAjAttributes.getAnnotationElement(after, THROWING);
            String pointcut = null;
            String thrownFormal = null;
            if (annValue != null && annPointcut != null || annValue == null && annPointcut == null) {
                AtAjAttributes.reportError("@AfterThrowing: either 'value' or 'poincut' must be provided, not both", struct);
                return false;
            }
            pointcut = annValue != null ? annValue.getValue().stringifyValue() : annPointcut.getValue().stringifyValue();
            if (AtAjAttributes.isNullOrEmpty(pointcut)) {
                AtAjAttributes.reportError("@AfterThrowing: either 'value' or 'poincut' must be provided, not both", struct);
                return false;
            }
            if (annThrown != null) {
                thrownFormal = annThrown.getValue().stringifyValue();
                if (AtAjAttributes.isNullOrEmpty(thrownFormal)) {
                    thrownFormal = null;
                } else {
                    String[] pNames = owningMethod.getParameterNames();
                    if (pNames == null || pNames.length == 0 || !Arrays.asList(pNames).contains(thrownFormal)) {
                        throw new ThrownFormalNotDeclaredInAdviceSignatureException(thrownFormal);
                    }
                }
            }
            FormalBinding[] bindings = new FormalBinding[]{};
            try {
                bindings = thrownFormal == null ? AtAjAttributes.extractBindings(struct) : AtAjAttributes.extractBindings(struct, thrownFormal);
            }
            catch (UnreadableDebugInfoException unreadableDebugInfoException) {
                return false;
            }
            BindingScope binding = new BindingScope(struct.enclosingType, struct.context, bindings);
            int extraArgument = AtAjAttributes.extractExtraArgument(struct.method);
            if (thrownFormal != null) {
                extraArgument |= 1;
            }
            Pointcut pc = null;
            if (preResolvedPointcut != null) {
                pc = preResolvedPointcut.getPointcut();
            } else {
                pc = AtAjAttributes.parsePointcut(pointcut, struct, false);
                if (pc == null) {
                    return false;
                }
                pc.resolve(binding);
            }
            AtAjAttributes.setIgnoreUnboundBindingNames(pc, bindings);
            ISourceLocation sl = struct.context.makeSourceLocation(struct.bMethod.getDeclarationLineNumber(), struct.bMethod.getDeclarationOffset());
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.AfterThrowing, pc, extraArgument, sl.getOffset(), sl.getOffset() + 1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAroundAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        ElementNameValuePair aroundAdvice;
        Annotation around = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.AROUND_ANNOTATION);
        if (around != null && (aroundAdvice = AtAjAttributes.getAnnotationElement(around, VALUE)) != null) {
            FormalBinding[] bindings = new FormalBinding[]{};
            try {
                bindings = AtAjAttributes.extractBindings(struct);
            }
            catch (UnreadableDebugInfoException unreadableDebugInfoException) {
                return false;
            }
            BindingScope binding = new BindingScope(struct.enclosingType, struct.context, bindings);
            int extraArgument = AtAjAttributes.extractExtraArgument(struct.method);
            Pointcut pc = null;
            if (preResolvedPointcut != null) {
                pc = preResolvedPointcut.getPointcut();
            } else {
                pc = AtAjAttributes.parsePointcut(aroundAdvice.getValue().stringifyValue(), struct, false);
                if (pc == null) {
                    return false;
                }
                pc.resolve(binding);
            }
            AtAjAttributes.setIgnoreUnboundBindingNames(pc, bindings);
            ISourceLocation sl = struct.context.makeSourceLocation(struct.bMethod.getDeclarationLineNumber(), struct.bMethod.getDeclarationOffset());
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.Around, pc, extraArgument, sl.getOffset(), sl.getOffset() + 1, struct.context));
            return true;
        }
        return false;
    }

    private static void handlePointcutAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct) {
        Annotation pointcut = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.POINTCUT_ANNOTATION);
        if (pointcut != null) {
            BindingScope binding;
            ElementNameValuePair pointcutExpr = AtAjAttributes.getAnnotationElement(pointcut, VALUE);
            if (!(Type.VOID.equals(struct.method.getReturnType()) || Type.BOOLEAN.equals(struct.method.getReturnType()) && struct.method.isStatic() && struct.method.isPublic())) {
                AtAjAttributes.reportWarning("Found @Pointcut on a method not returning 'void' or not 'public static boolean'", struct);
            }
            if (struct.method.getExceptionTable() != null) {
                AtAjAttributes.reportWarning("Found @Pointcut on a method throwing exception", struct);
            }
            try {
                binding = new BindingScope(struct.enclosingType, struct.context, AtAjAttributes.extractBindings(struct));
            }
            catch (UnreadableDebugInfoException e) {
                return;
            }
            UnresolvedType[] argumentTypes = new UnresolvedType[struct.method.getArgumentTypes().length];
            for (int i = 0; i < argumentTypes.length; ++i) {
                argumentTypes[i] = UnresolvedType.forSignature(struct.method.getArgumentTypes()[i].getSignature());
            }
            Pointcut pc = null;
            if (struct.method.isAbstract()) {
                if (!(pointcutExpr != null && AtAjAttributes.isNullOrEmpty(pointcutExpr.getValue().stringifyValue()) || pointcutExpr == null)) {
                    AtAjAttributes.reportError("Found defined @Pointcut on an abstract method", struct);
                    return;
                }
            } else if (!(pointcutExpr == null || pointcutExpr != null && AtAjAttributes.isNullOrEmpty(pointcutExpr.getValue().stringifyValue()))) {
                if (pointcutExpr != null) {
                    pc = AtAjAttributes.parsePointcut(pointcutExpr.getValue().stringifyValue(), struct, true);
                    if (pc == null) {
                        return;
                    }
                    pc.setLocation(struct.context, -1, -1);
                } else {
                    AtAjAttributes.reportError("Found undefined @Pointcut on a non-abstract method", struct);
                    return;
                }
            }
            struct.ajAttributes.add(new AjAttribute.PointcutDeclarationAttribute(new LazyResolvedPointcutDefinition(struct.enclosingType, struct.method.getModifiers(), struct.method.getName(), argumentTypes, UnresolvedType.forSignature(struct.method.getReturnType().getSignature()), pc, binding)));
        }
    }

    private static boolean handleDeclareErrorOrWarningAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeFieldStruct struct) {
        ElementNameValuePair declareWarning;
        ElementNameValuePair declareError;
        Annotation error = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.DECLAREERROR_ANNOTATION);
        boolean hasError = false;
        if (error != null && (declareError = AtAjAttributes.getAnnotationElement(error, VALUE)) != null) {
            if (!STRING_DESC.equals(struct.field.getSignature()) || struct.field.getConstantValue() == null) {
                AtAjAttributes.reportError("@DeclareError used on a non String constant field", struct);
                return false;
            }
            Pointcut pc = AtAjAttributes.parsePointcut(declareError.getValue().stringifyValue(), struct, false);
            if (pc == null) {
                hasError = false;
            } else {
                DeclareErrorOrWarning deow = new DeclareErrorOrWarning(true, pc, struct.field.getConstantValue().toString());
                AtAjAttributes.setDeclareErrorOrWarningLocation(deow, struct);
                struct.ajAttributes.add(new AjAttribute.DeclareAttribute(deow));
                hasError = true;
            }
        }
        Annotation warning = AtAjAttributes.getAnnotation(runtimeAnnotations, AjcMemberMaker.DECLAREWARNING_ANNOTATION);
        boolean hasWarning = false;
        if (warning != null && (declareWarning = AtAjAttributes.getAnnotationElement(warning, VALUE)) != null) {
            if (!STRING_DESC.equals(struct.field.getSignature()) || struct.field.getConstantValue() == null) {
                AtAjAttributes.reportError("@DeclareWarning used on a non String constant field", struct);
                return false;
            }
            Pointcut pc = AtAjAttributes.parsePointcut(declareWarning.getValue().stringifyValue(), struct, false);
            if (pc == null) {
                hasWarning = false;
            } else {
                DeclareErrorOrWarning deow = new DeclareErrorOrWarning(false, pc, struct.field.getConstantValue().toString());
                AtAjAttributes.setDeclareErrorOrWarningLocation(deow, struct);
                struct.ajAttributes.add(new AjAttribute.DeclareAttribute(deow));
                hasWarning = true;
                return true;
            }
        }
        return hasError || hasWarning;
    }

    private static void setDeclareErrorOrWarningLocation(DeclareErrorOrWarning deow, AjAttributeFieldStruct struct) {
        IProgramElement ipe;
        IHierarchy top = AsmManager.getDefault().getHierarchy();
        if (top.getRoot() != null && (ipe = top.findElementForLabel(top.getRoot(), IProgramElement.Kind.FIELD, struct.field.getName())) != null && ipe.getSourceLocation() != null) {
            ISourceLocation sourceLocation = ipe.getSourceLocation();
            int start = sourceLocation.getOffset();
            int end = start + struct.field.getName().length();
            deow.setLocation(struct.context, start, end);
            return;
        }
        deow.setLocation(struct.context, -1, -1);
    }

    private static String methodToString(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append(method.getSignature());
        return sb.toString();
    }

    private static String fieldToString(Field field) {
        StringBuffer sb = new StringBuffer();
        sb.append(field.getName()).append(' ');
        sb.append(field.getSignature());
        return sb.toString();
    }

    private static FormalBinding[] extractBindings(AjAttributeMethodStruct struct) throws UnreadableDebugInfoException {
        Method method = struct.method;
        String[] argumentNames = struct.getArgumentNames();
        if (argumentNames.length != method.getArgumentTypes().length) {
            AtAjAttributes.reportError("Cannot read debug info for @Aspect to handle formal binding in pointcuts (please compile with 'javac -g' or '<javac debug='true'.../>' in Ant)", struct);
            throw new UnreadableDebugInfoException();
        }
        ArrayList<FormalBinding> bindings = new ArrayList<FormalBinding>();
        for (int i = 0; i < argumentNames.length; ++i) {
            String argumentName = argumentNames[i];
            UnresolvedType argumentType = UnresolvedType.forSignature(method.getArgumentTypes()[i].getSignature());
            if (AjcMemberMaker.TYPEX_JOINPOINT.equals(argumentType) || AjcMemberMaker.TYPEX_PROCEEDINGJOINPOINT.equals(argumentType) || AjcMemberMaker.TYPEX_STATICJOINPOINT.equals(argumentType) || AjcMemberMaker.TYPEX_ENCLOSINGSTATICJOINPOINT.equals(argumentType) || AjcMemberMaker.AROUND_CLOSURE_TYPE.equals(argumentType)) {
                bindings.add(new FormalBinding.ImplicitFormalBinding(argumentType, argumentName, i));
                continue;
            }
            bindings.add(new FormalBinding(argumentType, argumentName, i));
        }
        return bindings.toArray(new FormalBinding[0]);
    }

    private static FormalBinding[] extractBindings(AjAttributeMethodStruct struct, String excludeFormal) throws UnreadableDebugInfoException {
        FormalBinding[] bindings = AtAjAttributes.extractBindings(struct);
        int excludeIndex = -1;
        for (int i = 0; i < bindings.length; ++i) {
            FormalBinding binding = bindings[i];
            if (!binding.getName().equals(excludeFormal)) continue;
            excludeIndex = i;
            bindings[i] = new FormalBinding.ImplicitFormalBinding(binding.getType(), binding.getName(), binding.getIndex());
            break;
        }
        return bindings;
    }

    private static int extractExtraArgument(Method method) {
        Type[] methodArgs = method.getArgumentTypes();
        String[] sigs = new String[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            sigs[i] = methodArgs[i].getSignature();
        }
        return AtAjAttributes.extractExtraArgument(sigs);
    }

    public static int extractExtraArgument(String[] argumentSignatures) {
        int extraArgument = 0;
        for (int i = 0; i < argumentSignatures.length; ++i) {
            if (AjcMemberMaker.TYPEX_JOINPOINT.getSignature().equals(argumentSignatures[i])) {
                extraArgument |= 2;
                continue;
            }
            if (AjcMemberMaker.TYPEX_PROCEEDINGJOINPOINT.getSignature().equals(argumentSignatures[i])) {
                extraArgument |= 2;
                continue;
            }
            if (AjcMemberMaker.TYPEX_STATICJOINPOINT.getSignature().equals(argumentSignatures[i])) {
                extraArgument |= 4;
                continue;
            }
            if (!AjcMemberMaker.TYPEX_ENCLOSINGSTATICJOINPOINT.getSignature().equals(argumentSignatures[i])) continue;
            extraArgument |= 8;
        }
        return extraArgument;
    }

    private static Annotation getAnnotation(RuntimeAnnotations rvs, UnresolvedType annotationType) {
        String annotationTypeName = annotationType.getName();
        Iterator iterator = rvs.getAnnotations().iterator();
        while (iterator.hasNext()) {
            Annotation rv = (Annotation)iterator.next();
            if (!annotationTypeName.equals(rv.getTypeName())) continue;
            return rv;
        }
        return null;
    }

    private static ElementNameValuePair getAnnotationElement(Annotation annotation, String elementName) {
        Iterator iterator1 = annotation.getValues().iterator();
        while (iterator1.hasNext()) {
            ElementNameValuePair element = (ElementNameValuePair)iterator1.next();
            if (!elementName.equals(element.getNameString())) continue;
            return element;
        }
        return null;
    }

    private static String[] getMethodArgumentNamesAsInSource(Method method) {
        if (method.getArgumentTypes().length == 0) {
            return EMPTY_STRINGS;
        }
        int startAtStackIndex = method.isStatic() ? 0 : 1;
        ArrayList<MethodArgument> arguments = new ArrayList<MethodArgument>();
        LocalVariableTable lt = method.getLocalVariableTable();
        if (lt != null) {
            for (int j = 0; j < lt.getLocalVariableTable().length; ++j) {
                LocalVariable localVariable = lt.getLocalVariableTable()[j];
                if (localVariable.getStartPC() != 0 || localVariable.getIndex() < startAtStackIndex) continue;
                arguments.add(new MethodArgument(localVariable.getName(), localVariable.getIndex()));
            }
        }
        if (arguments.size() != method.getArgumentTypes().length) {
            return EMPTY_STRINGS;
        }
        Collections.sort(arguments, new Comparator(){

            public int compare(Object o, Object o1) {
                MethodArgument mo = (MethodArgument)o;
                MethodArgument mo1 = (MethodArgument)o1;
                if (mo.indexOnStack == mo1.indexOnStack) {
                    return 0;
                }
                if (mo.indexOnStack > mo1.indexOnStack) {
                    return 1;
                }
                return -1;
            }
        });
        String[] argumentNames = new String[arguments.size()];
        int i = 0;
        Iterator iterator = arguments.iterator();
        while (iterator.hasNext()) {
            MethodArgument methodArgument = (MethodArgument)iterator.next();
            argumentNames[i] = methodArgument.name;
            ++i;
        }
        return argumentNames;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() <= 0;
    }

    private static void setIgnoreUnboundBindingNames(Pointcut pointcut, FormalBinding[] bindings) {
        ArrayList<String> ignores = new ArrayList<String>();
        for (int i = 0; i < bindings.length; ++i) {
            FormalBinding formalBinding = bindings[i];
            if (!(formalBinding instanceof FormalBinding.ImplicitFormalBinding)) continue;
            ignores.add(formalBinding.getName());
        }
        pointcut.m_ignoreUnboundBindingForNames = ignores.toArray(new String[ignores.size()]);
    }

    private static void reportError(String message, AjAttributeStruct location) {
        if (!location.handler.isIgnoring(IMessage.ERROR)) {
            location.handler.handleMessage(new Message(message, location.enclosingType.getSourceLocation(), true));
        }
    }

    private static void reportWarning(String message, AjAttributeStruct location) {
        if (!location.handler.isIgnoring(IMessage.WARNING)) {
            location.handler.handleMessage(new Message(message, location.enclosingType.getSourceLocation(), false));
        }
    }

    private static Pointcut parsePointcut(String pointcutString, AjAttributeStruct struct, boolean allowIf) {
        try {
            PatternParser parser = new PatternParser(pointcutString, struct.context);
            Pointcut pointcut = parser.parsePointcut();
            parser.checkEof();
            if (!allowIf && pointcutString.indexOf("if()") >= 0 && AtAjAttributes.hasIf(pointcut)) {
                AtAjAttributes.reportError("if() pointcut is not allowed at this pointcut location '" + pointcutString + "'", struct);
                return null;
            }
            pointcut.setLocation(struct.context, -1, -1);
            return pointcut;
        }
        catch (ParserException e) {
            AtAjAttributes.reportError("Invalid pointcut '" + pointcutString + "': " + e.toString() + (e.getLocation() == null ? "" : " at position " + e.getLocation().getStart()), struct);
            return null;
        }
    }

    private static boolean hasIf(Pointcut pointcut) {
        IfFinder visitor = new IfFinder();
        pointcut.accept(visitor, null);
        return visitor.hasIf;
    }

    private static TypePattern parseTypePattern(String patternString, AjAttributeStruct location) {
        try {
            TypePattern typePattern = new PatternParser(patternString).parseTypePattern();
            typePattern.setLocation(location.context, -1, -1);
            return typePattern;
        }
        catch (ParserException e) {
            AtAjAttributes.reportError("Invalid type pattern'" + patternString + "' : " + e.getLocation(), location);
            return null;
        }
    }

    static class ReturningFormalNotDeclaredInAdviceSignatureException
    extends Exception {
        private String formalName;

        public ReturningFormalNotDeclaredInAdviceSignatureException(String formalName) {
            this.formalName = formalName;
        }

        public String getFormalName() {
            return this.formalName;
        }
    }

    static class ThrownFormalNotDeclaredInAdviceSignatureException
    extends Exception {
        private String formalName;

        public ThrownFormalNotDeclaredInAdviceSignatureException(String formalName) {
            this.formalName = formalName;
        }

        public String getFormalName() {
            return this.formalName;
        }
    }

    private static class IfFinder
    extends IdentityPointcutVisitor {
        boolean hasIf = false;

        private IfFinder() {
        }

        public Object visit(IfPointcut node, Object data) {
            if (!node.alwaysFalse() && !node.alwaysTrue()) {
                this.hasIf = true;
            }
            return node;
        }

        public Object visit(AndPointcut node, Object data) {
            if (!this.hasIf) {
                node.getLeft().accept(this, data);
            }
            if (!this.hasIf) {
                node.getRight().accept(this, data);
            }
            return node;
        }

        public Object visit(NotPointcut node, Object data) {
            if (!this.hasIf) {
                node.getNegatedPointcut().accept(this, data);
            }
            return node;
        }

        public Object visit(OrPointcut node, Object data) {
            if (!this.hasIf) {
                node.getLeft().accept(this, data);
            }
            if (!this.hasIf) {
                node.getRight().accept(this, data);
            }
            return node;
        }
    }

    private static class UnreadableDebugInfoException
    extends Exception {
        private UnreadableDebugInfoException() {
        }
    }

    public static class LazyResolvedPointcutDefinition
    extends ResolvedPointcutDefinition {
        private Pointcut m_pointcutUnresolved;
        private IScope m_binding;
        private Pointcut m_lazyPointcut = null;

        public LazyResolvedPointcutDefinition(ResolvedType declaringType, int modifiers, String name, UnresolvedType[] parameterTypes, UnresolvedType returnType, Pointcut pointcut, IScope binding) {
            super(declaringType, modifiers, name, parameterTypes, returnType, null);
            this.m_pointcutUnresolved = pointcut;
            this.m_binding = binding;
        }

        public Pointcut getPointcut() {
            if (this.m_lazyPointcut == null) {
                this.m_lazyPointcut = this.m_pointcutUnresolved.resolve(this.m_binding);
                this.m_lazyPointcut.copyLocationFrom(this.m_pointcutUnresolved);
            }
            return this.m_lazyPointcut;
        }
    }

    public static class BindingScope
    extends SimpleScope {
        private ResolvedType m_enclosingType;
        private ISourceContext m_sourceContext;

        public BindingScope(ResolvedType type, ISourceContext sourceContext, FormalBinding[] bindings) {
            super(type.getWorld(), bindings);
            this.m_enclosingType = type;
            this.m_sourceContext = sourceContext;
        }

        public ResolvedType getEnclosingType() {
            return this.m_enclosingType;
        }

        public ISourceLocation makeSourceLocation(IHasPosition location) {
            return this.m_sourceContext.makeSourceLocation(location);
        }

        public UnresolvedType lookupType(String name, IHasPosition location) {
            String pkgName;
            if (this.m_enclosingType != null && (pkgName = this.m_enclosingType.getPackageName()) != null && !pkgName.equals("")) {
                String[] currentImports = this.getImportedPrefixes();
                String[] newImports = new String[currentImports.length + 1];
                for (int i = 0; i < currentImports.length; ++i) {
                    newImports[i] = currentImports[i];
                }
                newImports[currentImports.length] = pkgName.concat(".");
                this.setImportedPrefixes(newImports);
            }
            return super.lookupType(name, location);
        }
    }

    private static class MethodArgument {
        String name;
        int indexOnStack;

        public MethodArgument(String name, int indexOnStack) {
            this.name = name;
            this.indexOnStack = indexOnStack;
        }
    }

    private static class AjAttributeFieldStruct
    extends AjAttributeStruct {
        final Field field;
        final BcelField bField;

        public AjAttributeFieldStruct(Field field, BcelField bField, ResolvedType type, ISourceContext sourceContext, IMessageHandler messageHandler) {
            super(type, sourceContext, messageHandler);
            this.field = field;
            this.bField = bField;
        }
    }

    private static class AjAttributeMethodStruct
    extends AjAttributeStruct {
        private String[] m_argumentNamesLazy = null;
        final Method method;
        final BcelMethod bMethod;

        public AjAttributeMethodStruct(Method method, BcelMethod bMethod, ResolvedType type, ISourceContext sourceContext, IMessageHandler messageHandler) {
            super(type, sourceContext, messageHandler);
            this.method = method;
            this.bMethod = bMethod;
        }

        public String[] getArgumentNames() {
            if (this.m_argumentNamesLazy == null) {
                this.m_argumentNamesLazy = AtAjAttributes.getMethodArgumentNamesAsInSource(this.method);
            }
            return this.m_argumentNamesLazy;
        }
    }

    private static class AjAttributeStruct {
        List ajAttributes = new ArrayList();
        final ResolvedType enclosingType;
        final ISourceContext context;
        final IMessageHandler handler;

        public AjAttributeStruct(ResolvedType type, ISourceContext sourceContext, IMessageHandler messageHandler) {
            this.enclosingType = type;
            this.context = sourceContext;
            this.handler = messageHandler;
        }
    }
}

