/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerVector;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.Double3Vector;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class Complex3Vector
extends AbstractComplexVector {
    protected double xre;
    protected double xim;
    protected double yre;
    protected double yim;
    protected double zre;
    protected double zim;

    public Complex3Vector() {
        super(3);
    }

    public Complex3Vector(Complex complex, Complex complex2, Complex complex3) {
        this();
        this.xre = complex.real();
        this.xim = complex.imag();
        this.yre = complex2.real();
        this.yim = complex2.imag();
        this.zre = complex3.real();
        this.zim = complex3.imag();
    }

    public Complex3Vector(double d, double d2, double d3, double d4, double d5, double d6) {
        this();
        this.xre = d;
        this.xim = d2;
        this.yre = d3;
        this.yim = d4;
        this.zre = d5;
        this.zim = d6;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Complex3Vector) {
            Complex3Vector complex3Vector = (Complex3Vector)object;
            return Math.abs(this.xre - complex3Vector.xre) <= GlobalSettings.ZERO_TOL && Math.abs(this.xim - complex3Vector.xim) <= GlobalSettings.ZERO_TOL && Math.abs(this.yre - complex3Vector.yre) <= GlobalSettings.ZERO_TOL && Math.abs(this.yim - complex3Vector.yim) <= GlobalSettings.ZERO_TOL && Math.abs(this.zre - complex3Vector.zre) <= GlobalSettings.ZERO_TOL && Math.abs(this.zim - complex3Vector.zim) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(Complex.toString(this.xre, this.xim)).append(',').append(Complex.toString(this.yre, this.yim)).append(',').append(Complex.toString(this.zre, this.zim));
        return stringBuffer.toString();
    }

    public AbstractDoubleVector real() {
        return new Double3Vector(this.xre, this.yre, this.zre);
    }

    public AbstractDoubleVector imag() {
        return new Double3Vector(this.xim, this.yim, this.zim);
    }

    public Complex getComponent(int n) {
        switch (n) {
            case 0: {
                return new Complex(this.xre, this.xim);
            }
            case 1: {
                return new Complex(this.yre, this.yim);
            }
            case 2: {
                return new Complex(this.zre, this.zim);
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, Complex complex) {
        switch (n) {
            case 0: {
                this.xre = complex.real();
                this.xim = complex.imag();
                break;
            }
            case 1: {
                this.yre = complex.real();
                this.yim = complex.imag();
                break;
            }
            case 2: {
                this.zre = complex.real();
                this.zim = complex.imag();
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    public void setComponent(int n, double d, double d2) {
        switch (n) {
            case 0: {
                this.xre = d;
                this.xim = d2;
                break;
            }
            case 1: {
                this.yre = d;
                this.yim = d2;
                break;
            }
            case 2: {
                this.zre = d;
                this.zim = d2;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    public double norm() {
        return Math.sqrt(this.xre * this.xre + this.xim * this.xim + this.yre * this.yre + this.yim * this.yim + this.zre * this.zre + this.zim * this.zim);
    }

    public double infNorm() {
        double d = this.xre * this.xre + this.xim * this.xim;
        double d2 = 0.0;
        if (d > d2) {
            d2 = d;
        }
        if ((d = this.yre * this.yre + this.yim * this.yim) > d2) {
            d2 = d;
        }
        if ((d = this.zre * this.zre + this.zim * this.zim) > d2) {
            d2 = d;
        }
        return Math.sqrt(d2);
    }

    public AbelianGroup.Member negate() {
        return new Complex3Vector(-this.xre, -this.xim, -this.yre, -this.yim, -this.zre, -this.zim);
    }

    public AbstractComplexVector conjugate() {
        return new Complex3Vector(this.xre, -this.xim, this.yre, -this.yim, this.zre, -this.zim);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexVector) {
            return this.add((AbstractComplexVector)member);
        }
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        if (member instanceof AbstractIntegerVector) {
            return this.add((AbstractIntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector add(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector.N == 3) {
            return new Complex3Vector(this.xre + abstractComplexVector.getComponent(0).real(), this.xim + abstractComplexVector.getComponent(0).imag(), this.yre + abstractComplexVector.getComponent(1).real(), this.yim + abstractComplexVector.getComponent(1).imag(), this.zre + abstractComplexVector.getComponent(2).real(), this.zim + abstractComplexVector.getComponent(2).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 3) {
            return new Complex3Vector(this.xre + abstractDoubleVector.getComponent(0), this.xim, this.yre + abstractDoubleVector.getComponent(1), this.yim, this.zre + abstractDoubleVector.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector.N == 3) {
            return new Complex3Vector(this.xre + (double)abstractIntegerVector.getComponent(0), this.xim, this.yre + (double)abstractIntegerVector.getComponent(1), this.yim, this.zre + (double)abstractIntegerVector.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractComplexVector) {
            return this.subtract((AbstractComplexVector)member);
        }
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        if (member instanceof AbstractIntegerVector) {
            return this.subtract((AbstractIntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector subtract(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector.N == 3) {
            return new Complex3Vector(this.xre - abstractComplexVector.getComponent(0).real(), this.xim - abstractComplexVector.getComponent(0).imag(), this.yre - abstractComplexVector.getComponent(1).real(), this.yim - abstractComplexVector.getComponent(1).imag(), this.zre - abstractComplexVector.getComponent(2).real(), this.zim - abstractComplexVector.getComponent(2).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector.N == 3) {
            return new Complex3Vector(this.xre - abstractDoubleVector.getComponent(0), this.xim, this.yre - abstractDoubleVector.getComponent(1), this.yim, this.zre - abstractDoubleVector.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector.N == 3) {
            return new Complex3Vector(this.xre - (double)abstractIntegerVector.getComponent(0), this.xim, this.yre - (double)abstractIntegerVector.getComponent(1), this.yim, this.zre - (double)abstractIntegerVector.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        return new Complex3Vector(this.xre * d - this.xim * d2, this.xre * d2 + this.xim * d, this.yre * d - this.yim * d2, this.yre * d2 + this.yim * d, this.zre * d - this.zim * d2, this.zre * d2 + this.zim * d);
    }

    public AbstractComplexVector scalarMultiply(double d) {
        return new Complex3Vector(d * this.xre, d * this.xim, d * this.yre, d * this.yim, d * this.zre, d * this.zim);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractComplexVector scalarDivide(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        if (Math.abs(d) < Math.abs(d2)) {
            double d3 = d / d2;
            double d4 = d * d3 + d2;
            return new Complex3Vector((this.xre * d3 + this.xim) / d4, (this.xim * d3 - this.xre) / d4, (this.yre * d3 + this.yim) / d4, (this.yim * d3 - this.yre) / d4, (this.zre * d3 + this.zim) / d4, (this.zim * d3 - this.zre) / d4);
        }
        double d5 = d2 / d;
        double d6 = d + d2 * d5;
        return new Complex3Vector((this.xre + this.xim * d5) / d6, (this.xim - this.xre * d5) / d6, (this.yre + this.yim * d5) / d6, (this.yim - this.yre * d5) / d6, (this.zre + this.zim * d5) / d6, (this.zim - this.zre * d5) / d6);
    }

    public AbstractComplexVector scalarDivide(double d) {
        return new Complex3Vector(this.xre / d, this.xim / d, this.yre / d, this.yim / d, this.zre / d, this.zim / d);
    }

    public Complex scalarProduct(HilbertSpace.Member member) {
        if (member instanceof AbstractComplexVector) {
            return this.scalarProduct((AbstractComplexVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex scalarProduct(AbstractComplexVector abstractComplexVector) {
        if (abstractComplexVector instanceof Complex3Vector) {
            return this.scalarProduct((Complex3Vector)abstractComplexVector);
        }
        if (abstractComplexVector.N == 3) {
            return new Complex(this.xre * abstractComplexVector.getComponent(0).real() + this.xim * abstractComplexVector.getComponent(0).imag() + this.yre * abstractComplexVector.getComponent(1).real() + this.yim * abstractComplexVector.getComponent(1).imag() + this.zre * abstractComplexVector.getComponent(2).real() + this.zim * abstractComplexVector.getComponent(2).imag(), this.xim * abstractComplexVector.getComponent(0).real() - this.xre * abstractComplexVector.getComponent(0).imag() + this.yim * abstractComplexVector.getComponent(1).real() - this.yre * abstractComplexVector.getComponent(1).imag() + this.zim * abstractComplexVector.getComponent(2).real() - this.zre * abstractComplexVector.getComponent(2).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Complex scalarProduct(Complex3Vector complex3Vector) {
        return new Complex(this.xre * complex3Vector.xre + this.xim * complex3Vector.xim + this.yre * complex3Vector.yre + this.yim * complex3Vector.yim + this.zre * complex3Vector.zre + this.zim * complex3Vector.zim, this.xim * complex3Vector.xre - this.xre * complex3Vector.xim + this.yim * complex3Vector.yre - this.yre * complex3Vector.yim + this.zim * complex3Vector.zre - this.zre * complex3Vector.zim);
    }

    public Complex3Vector multiply(Complex3Vector complex3Vector) {
        return new Complex3Vector(this.yre * complex3Vector.zre - this.yim * complex3Vector.zim - this.zre * complex3Vector.yre + this.zim * complex3Vector.yim, this.yre * complex3Vector.zim + this.yim * complex3Vector.zre - this.zre * complex3Vector.yim - this.zim * complex3Vector.yre, this.zre * complex3Vector.xre - this.zim * complex3Vector.xim - this.xre * complex3Vector.zre + this.xim * complex3Vector.zim, this.zre * complex3Vector.xim + this.zim * complex3Vector.xre - this.xre * complex3Vector.zim - this.xim * complex3Vector.zre, this.xre * complex3Vector.yre - this.xim * complex3Vector.yim - this.yre * complex3Vector.xre + this.yim * complex3Vector.xim, this.xre * complex3Vector.yim + this.xim * complex3Vector.yre - this.yre * complex3Vector.xim - this.yim * complex3Vector.xre);
    }

    public AbstractComplexVector mapComponents(ComplexMapping complexMapping) {
        return new Complex3Vector(complexMapping.map(this.xre, this.xim), complexMapping.map(this.yre, this.yim), complexMapping.map(this.zre, this.zim));
    }
}

