/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class ComplexDiagonalMatrix
extends ComplexTridiagonalMatrix
implements DiagonalMatrix {
    protected static final int DIAGONAL = 4;

    protected ComplexDiagonalMatrix(int n, int n2) {
        super(n, n2);
    }

    public ComplexDiagonalMatrix(int n) {
        this(n, 4);
        this.matrixRe = new double[1][n];
        this.matrixIm = new double[1][n];
        this.diagRe = this.matrixRe[0];
        this.diagIm = this.matrixIm[0];
    }

    public ComplexDiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        if (complexArray.length == complexArray[0].length) {
            int n = 0;
            while (n < this.numRows) {
                this.diagRe[n] = complexArray[n][n].real();
                this.diagIm[n] = complexArray[n][n].imag();
                ++n;
            }
        } else {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("Array must be square.");
        }
    }

    public ComplexDiagonalMatrix(double[] dArray, double[] dArray2) {
        this(dArray.length, 4);
        this.matrixRe = new double[1][];
        this.matrixIm = new double[1][];
        this.matrixRe[0] = dArray;
        this.matrixIm[0] = dArray2;
        this.diagRe = this.matrixRe[0];
        this.diagIm = this.matrixIm[0];
    }

    public ComplexDiagonalMatrix(Complex[] complexArray) {
        this(complexArray.length);
        this.diagRe[0] = complexArray[0].real();
        this.diagIm[0] = complexArray[0].imag();
        int n = 1;
        while (n < complexArray.length) {
            this.diagRe[n] = complexArray[n].real();
            this.diagIm[n] = complexArray[n].imag();
            ++n;
        }
    }

    public static ComplexDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 1.0;
            ++n2;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public boolean equals(Object object) {
        if (object instanceof ComplexDiagonalMatrix && this.numRows == ((ComplexDiagonalMatrix)object).rows()) {
            ComplexDiagonalMatrix complexDiagonalMatrix = (ComplexDiagonalMatrix)object;
            int n = 0;
            while (n < this.numRows) {
                if (!complexDiagonalMatrix.getElement(n, n).equals(this.diagRe[n], this.diagIm[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public DoubleMatrix real() {
        return new DoubleDiagonalMatrix(this.diagRe);
    }

    public DoubleMatrix imag() {
        return new DoubleDiagonalMatrix(this.diagIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return new Complex(this.diagRe[n], this.diagIm[n]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diagRe[n] = complex.real();
        this.diagIm[n] = complex.imag();
    }

    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diagRe[n] = d;
        this.diagIm[n] = d2;
    }

    public boolean isHermitian() {
        return this.equals(this.conjugate());
    }

    public boolean isUnitary() {
        return this.multiply(this.conjugate()).equals(ComplexDiagonalMatrix.identity(this.numRows));
    }

    public Complex det() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            double d3 = d * this.diagRe[n] - d2 * this.diagIm[n];
            d2 = d2 * this.diagRe[n] + d * this.diagIm[n];
            d = d3;
            ++n;
        }
        return new Complex(d, d2);
    }

    public Complex trace() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diagRe[n];
            d2 += this.diagIm[n];
            ++n;
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            double d2 = this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n];
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public double frobeniusNorm() {
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            d += this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public double operatorNorm() {
        return this.infNorm();
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(complexMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(complexMatrix);
            }
        }
        if (this.numRows == complexMatrix.rows() && this.numCols == complexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexMatrix.getElement(n, 0);
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexMatrix.getElement(n, n2);
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                System.arraycopy(complexMatrix.matrixRe[n], 0, dArray[n], 0, this.numCols);
                System.arraycopy(complexMatrix.matrixIm[n], 0, dArray2[n], 0, this.numCols);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numRows) {
                double[] dArray3 = dArray[n2];
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + this.diagRe[n2];
                double[] dArray4 = dArray2[n2];
                int n4 = n2;
                dArray4[n4] = dArray4[n4] + this.diagIm[n2];
                ++n2;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(complexSquareMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(complexSquareMatrix);
            }
        }
        if (this.numRows == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexSquareMatrix.getElement(n, 0);
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexSquareMatrix.getElement(n, n2);
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        switch (complexTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(complexTridiagonalMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(complexTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            Complex complex = complexTridiagonalMatrix.getElement(0, 0);
            complexTridiagonalMatrix2.matrixRe[1][0] = this.diagRe[0] + complex.real();
            complexTridiagonalMatrix2.matrixIm[1][0] = this.diagIm[0] + complex.imag();
            complex = complexTridiagonalMatrix.getElement(0, 1);
            complexTridiagonalMatrix2.matrixRe[2][0] = complex.real();
            complexTridiagonalMatrix2.matrixIm[2][0] = complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = complexTridiagonalMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix2.matrixRe[0][n2] = complex.real();
                complexTridiagonalMatrix2.matrixIm[0][n2] = complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2);
                complexTridiagonalMatrix2.matrixRe[1][n2] = this.diagRe[n2] + complex.real();
                complexTridiagonalMatrix2.matrixIm[1][n2] = this.diagIm[n2] + complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix2.matrixRe[2][n2] = complex.real();
                complexTridiagonalMatrix2.matrixIm[2][n2] = complex.imag();
                ++n2;
            }
            complex = complexTridiagonalMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix2.matrixRe[0][n] = complex.real();
            complexTridiagonalMatrix2.matrixIm[0][n] = complex.imag();
            complex = complexTridiagonalMatrix.getElement(n, n);
            complexTridiagonalMatrix2.matrixRe[1][n] = this.diagRe[n] + complex.real();
            complexTridiagonalMatrix2.matrixIm[1][n] = this.diagIm[n] + complex.imag();
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix rawAddTridiagonal(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.numRows);
            System.arraycopy(complexMatrix.matrixRe[0], 0, complexTridiagonalMatrix.matrixRe[0], 0, complexMatrix.matrixRe[0].length);
            System.arraycopy(complexMatrix.matrixIm[0], 0, complexTridiagonalMatrix.matrixIm[0], 0, complexMatrix.matrixIm[0].length);
            System.arraycopy(complexMatrix.matrixRe[2], 0, complexTridiagonalMatrix.matrixRe[2], 0, complexMatrix.matrixRe[2].length);
            System.arraycopy(complexMatrix.matrixIm[2], 0, complexTridiagonalMatrix.matrixIm[2], 0, complexMatrix.matrixIm[2].length);
            complexTridiagonalMatrix.matrixRe[1][0] = this.diagRe[0] + complexMatrix.matrixRe[1][0];
            complexTridiagonalMatrix.matrixIm[1][0] = this.diagIm[0] + complexMatrix.matrixIm[1][0];
            int n = 1;
            while (n < this.numRows) {
                complexTridiagonalMatrix.matrixRe[1][n] = this.diagRe[n] + complexMatrix.matrixRe[1][n];
                complexTridiagonalMatrix.matrixIm[1][n] = this.diagIm[n] + complexMatrix.matrixIm[1][n];
                ++n;
            }
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix add(ComplexDiagonalMatrix complexDiagonalMatrix) {
        return this.rawAddDiagonal(complexDiagonalMatrix);
    }

    private ComplexDiagonalMatrix rawAddDiagonal(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] + complexMatrix.matrixRe[0][0];
            dArray2[0] = this.diagIm[0] + complexMatrix.matrixIm[0][0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diagRe[n] + complexMatrix.matrixRe[0][n];
                dArray2[n] = this.diagIm[n] + complexMatrix.matrixIm[0][n];
                ++n;
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(complexMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(complexMatrix);
            }
        }
        if (this.numRows == complexMatrix.rows() && this.numCols == complexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexMatrix.getElement(n, 0);
                dArray[n][0] = -complex.real();
                dArray2[n][0] = -complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexMatrix.getElement(n, n2);
                    dArray[n][n2] = -complex.real();
                    dArray2[n][n2] = -complex.imag();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = -complexMatrix.matrixRe[n][0];
                dArray2[n][0] = -complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = -complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = -complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(complexSquareMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(complexSquareMatrix);
            }
        }
        if (this.numRows == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexSquareMatrix.getElement(n, 0);
                dArray[n][0] = -complex.real();
                dArray2[n][0] = -complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexSquareMatrix.getElement(n, n2);
                    dArray[n][n2] = -complex.real();
                    dArray2[n][n2] = -complex.imag();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.numRows) {
                double[] dArray3 = dArray[n3];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + this.diagRe[n3];
                double[] dArray4 = dArray2[n3];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] + this.diagIm[n3];
                ++n3;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        switch (complexTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(complexTridiagonalMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(complexTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            Complex complex = complexTridiagonalMatrix.getElement(0, 0);
            complexTridiagonalMatrix2.matrixRe[1][0] = this.diagRe[0] - complex.real();
            complexTridiagonalMatrix2.matrixIm[1][0] = this.diagIm[0] - complex.imag();
            complex = complexTridiagonalMatrix.getElement(0, 1);
            complexTridiagonalMatrix2.matrixRe[2][0] = -complex.real();
            complexTridiagonalMatrix2.matrixIm[2][0] = -complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = complexTridiagonalMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix2.matrixRe[0][n2] = -complex.real();
                complexTridiagonalMatrix2.matrixIm[0][n2] = -complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2);
                complexTridiagonalMatrix2.matrixRe[1][n2] = this.diagRe[n2] - complex.real();
                complexTridiagonalMatrix2.matrixIm[1][n2] = this.diagIm[n2] - complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix2.matrixRe[2][n2] = -complex.real();
                complexTridiagonalMatrix2.matrixIm[2][n2] = -complex.imag();
                ++n2;
            }
            complex = complexTridiagonalMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix2.matrixRe[0][n] = -complex.real();
            complexTridiagonalMatrix2.matrixIm[0][n] = -complex.imag();
            complex = complexTridiagonalMatrix.getElement(n, n);
            complexTridiagonalMatrix2.matrixRe[1][n] = this.diagRe[n] - complex.real();
            complexTridiagonalMatrix2.matrixIm[1][n] = this.diagIm[n] - complex.imag();
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix rawSubtractTridiagonal(ComplexMatrix complexMatrix) {
        int n = this.numRows;
        if (n == complexMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix.matrixRe[1][0] = this.diagRe[0] - complexMatrix.matrixRe[1][0];
            complexTridiagonalMatrix.matrixIm[1][0] = this.diagIm[0] - complexMatrix.matrixIm[1][0];
            complexTridiagonalMatrix.matrixRe[2][0] = -complexMatrix.matrixRe[2][0];
            complexTridiagonalMatrix.matrixIm[2][0] = -complexMatrix.matrixIm[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix.matrixRe[0][n2] = -complexMatrix.matrixRe[0][n2];
                complexTridiagonalMatrix.matrixIm[0][n2] = -complexMatrix.matrixIm[0][n2];
                complexTridiagonalMatrix.matrixRe[1][n2] = this.diagRe[n2] - complexMatrix.matrixRe[1][n2];
                complexTridiagonalMatrix.matrixIm[1][n2] = this.diagIm[n2] - complexMatrix.matrixIm[1][n2];
                complexTridiagonalMatrix.matrixRe[2][n2] = -complexMatrix.matrixRe[2][n2];
                complexTridiagonalMatrix.matrixIm[2][n2] = -complexMatrix.matrixIm[2][n2];
                ++n2;
            }
            complexTridiagonalMatrix.matrixRe[0][n] = -complexMatrix.matrixRe[0][n];
            complexTridiagonalMatrix.matrixIm[0][n] = -complexMatrix.matrixIm[0][n];
            complexTridiagonalMatrix.matrixRe[1][n] = this.diagRe[n] - complexMatrix.matrixRe[1][n];
            complexTridiagonalMatrix.matrixIm[1][n] = this.diagIm[n] - complexMatrix.matrixIm[1][n];
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix subtract(ComplexDiagonalMatrix complexDiagonalMatrix) {
        return this.rawSubtractDiagonal(complexDiagonalMatrix);
    }

    private ComplexDiagonalMatrix rawSubtractDiagonal(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] - complexMatrix.matrixRe[0][0];
            dArray2[0] = this.diagIm[0] - complexMatrix.matrixIm[0][0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diagRe[n] - complexMatrix.matrixRe[0][n];
                dArray2[n] = this.diagIm[n] - complexMatrix.matrixIm[0][n];
                ++n;
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        dArray[0] = d * this.diagRe[0] - d2 * this.diagIm[0];
        dArray2[0] = d2 * this.diagRe[0] + d * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = d * this.diagRe[n] - d2 * this.diagIm[n];
            dArray2[n] = d2 * this.diagRe[n] + d * this.diagIm[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public ComplexMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        dArray[0] = d * this.diagRe[0];
        dArray2[0] = d * this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = d * this.diagRe[n];
            dArray2[n] = d * this.diagIm[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.numCols == complexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            Complex complex = complexVector.getComponent(0);
            dArray[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            dArray2[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            int n = 1;
            while (n < this.numRows) {
                complex = complexVector.getComponent(n);
                dArray[n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                dArray2[n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(complexMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(complexMatrix);
            }
        }
        if (this.numCols == complexMatrix.rows()) {
            double[][] dArray = new double[this.numRows][complexMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][complexMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexMatrix.getElement(n, 0);
                dArray[n][0] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                dArray2[n][0] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                int n2 = 1;
                while (n2 < complexMatrix.columns()) {
                    complex = complexMatrix.getElement(n, n2);
                    dArray[n][n2] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                    dArray2[n][n2] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.numCols == complexMatrix.numRows) {
            double[][] dArray = new double[this.numRows][complexMatrix.numCols];
            double[][] dArray2 = new double[this.numRows][complexMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diagRe[n] * complexMatrix.matrixRe[n][0] - this.diagIm[n] * complexMatrix.matrixIm[n][0];
                dArray2[n][0] = this.diagIm[n] * complexMatrix.matrixRe[n][0] + this.diagRe[n] * complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < complexMatrix.numCols) {
                    dArray[n][n2] = this.diagRe[n] * complexMatrix.matrixRe[n][n2] - this.diagIm[n] * complexMatrix.matrixIm[n][n2];
                    dArray2[n][n2] = this.diagIm[n] * complexMatrix.matrixRe[n][n2] + this.diagRe[n] * complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(complexSquareMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(complexSquareMatrix);
            }
        }
        if (this.numCols == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexSquareMatrix.getElement(n, 0);
                dArray[n][0] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                dArray2[n][0] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexSquareMatrix.getElement(n, n2);
                    dArray[n][n2] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
                    dArray2[n][n2] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.diagRe[n] * complexSquareMatrix.matrixRe[n][0] - this.diagIm[n] * complexSquareMatrix.matrixIm[n][0];
                dArray2[n][0] = this.diagIm[n] * complexSquareMatrix.matrixRe[n][0] + this.diagRe[n] * complexSquareMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.diagRe[n] * complexSquareMatrix.matrixRe[n][n2] - this.diagIm[n] * complexSquareMatrix.matrixIm[n][n2];
                    dArray2[n][n2] = this.diagIm[n] * complexSquareMatrix.matrixRe[n][n2] + this.diagRe[n] * complexSquareMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        switch (complexTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(complexTridiagonalMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(complexTridiagonalMatrix);
            }
        }
        int n = this.numRows;
        if (this.numCols == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            Complex complex = complexTridiagonalMatrix.getElement(0, 0);
            complexTridiagonalMatrix2.matrixRe[1][0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            complexTridiagonalMatrix2.matrixIm[1][0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            complex = complexTridiagonalMatrix.getElement(0, 1);
            complexTridiagonalMatrix2.matrixRe[2][0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            complexTridiagonalMatrix2.matrixIm[2][0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = complexTridiagonalMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix2.matrixRe[0][n2] = this.diagRe[n2] * complex.real() - this.diagIm[n2] * complex.imag();
                complexTridiagonalMatrix2.matrixIm[0][n2] = this.diagIm[n2] * complex.real() + this.diagRe[n2] * complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2);
                complexTridiagonalMatrix2.matrixRe[1][n2] = this.diagRe[n2] * complex.real() - this.diagIm[n2] * complex.imag();
                complexTridiagonalMatrix2.matrixIm[1][n2] = this.diagIm[n2] * complex.real() + this.diagRe[n2] * complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix2.matrixRe[2][n2] = this.diagRe[n2] * complex.real() - this.diagIm[n2] * complex.imag();
                complexTridiagonalMatrix2.matrixIm[2][n2] = this.diagIm[n2] * complex.real() + this.diagRe[n2] * complex.imag();
                ++n2;
            }
            complex = complexTridiagonalMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix2.matrixRe[0][n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
            complexTridiagonalMatrix2.matrixIm[0][n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
            complex = complexTridiagonalMatrix.getElement(n, n);
            complexTridiagonalMatrix2.matrixRe[1][n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
            complexTridiagonalMatrix2.matrixIm[1][n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawMultiplyTridiagonal(ComplexMatrix complexMatrix) {
        int n = this.numRows;
        if (this.numCols == complexMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix.matrixRe[1][0] = this.diagRe[0] * complexMatrix.matrixRe[1][0] - this.diagIm[0] * complexMatrix.matrixIm[1][0];
            complexTridiagonalMatrix.matrixIm[1][0] = this.diagIm[0] * complexMatrix.matrixRe[1][0] + this.diagRe[0] * complexMatrix.matrixIm[1][0];
            complexTridiagonalMatrix.matrixRe[2][0] = this.diagRe[0] * complexMatrix.matrixRe[2][0] - this.diagIm[0] * complexMatrix.matrixIm[2][0];
            complexTridiagonalMatrix.matrixIm[2][0] = this.diagIm[0] * complexMatrix.matrixRe[2][0] + this.diagRe[0] * complexMatrix.matrixIm[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix.matrixRe[0][n2] = this.diagRe[n2] * complexMatrix.matrixRe[0][n2] - this.diagIm[n2] * complexMatrix.matrixIm[0][n2];
                complexTridiagonalMatrix.matrixIm[0][n2] = this.diagIm[n2] * complexMatrix.matrixRe[0][n2] + this.diagRe[n2] * complexMatrix.matrixIm[0][n2];
                complexTridiagonalMatrix.matrixRe[1][n2] = this.diagRe[n2] * complexMatrix.matrixRe[1][n2] - this.diagIm[n2] * complexMatrix.matrixIm[1][n2];
                complexTridiagonalMatrix.matrixIm[1][n2] = this.diagIm[n2] * complexMatrix.matrixRe[1][n2] + this.diagRe[n2] * complexMatrix.matrixIm[1][n2];
                complexTridiagonalMatrix.matrixRe[2][n2] = this.diagRe[n2] * complexMatrix.matrixRe[2][n2] - this.diagIm[n2] * complexMatrix.matrixIm[2][n2];
                complexTridiagonalMatrix.matrixIm[2][n2] = this.diagIm[n2] * complexMatrix.matrixRe[2][n2] + this.diagRe[n2] * complexMatrix.matrixIm[2][n2];
                ++n2;
            }
            complexTridiagonalMatrix.matrixRe[0][n] = this.diagRe[n] * complexMatrix.matrixRe[0][n] - this.diagIm[n] * complexMatrix.matrixIm[0][n];
            complexTridiagonalMatrix.matrixIm[0][n] = this.diagIm[n] * complexMatrix.matrixRe[0][n] + this.diagRe[n] * complexMatrix.matrixIm[0][n];
            complexTridiagonalMatrix.matrixRe[1][n] = this.diagRe[n] * complexMatrix.matrixRe[1][n] - this.diagIm[n] * complexMatrix.matrixIm[1][n];
            complexTridiagonalMatrix.matrixIm[1][n] = this.diagIm[n] * complexMatrix.matrixRe[1][n] + this.diagRe[n] * complexMatrix.matrixIm[1][n];
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix multiply(ComplexDiagonalMatrix complexDiagonalMatrix) {
        return this.rawMultiplyDiagonal(complexDiagonalMatrix);
    }

    private ComplexDiagonalMatrix rawMultiplyDiagonal(ComplexMatrix complexMatrix) {
        if (this.numCols == complexMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] * complexMatrix.matrixRe[0][0] - this.diagIm[0] * complexMatrix.matrixIm[0][0];
            dArray2[0] = this.diagIm[0] * complexMatrix.matrixRe[0][0] + this.diagRe[0] * complexMatrix.matrixIm[0][0];
            int n = 1;
            while (n < this.numRows) {
                dArray[n] = this.diagRe[n] * complexMatrix.matrixRe[0][n] - this.diagIm[n] * complexMatrix.matrixIm[0][n];
                dArray2[n] = this.diagIm[n] * complexMatrix.matrixRe[0][n] + this.diagRe[n] * complexMatrix.matrixIm[0][n];
                ++n;
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        dArray[0] = this.diagRe[0] / d;
        dArray2[0] = -this.diagIm[0] / d;
        int n = 1;
        while (n < this.numRows) {
            d = this.diagRe[n] * this.diagRe[n] + this.diagIm[n] * this.diagIm[n];
            dArray[n] = this.diagRe[n] / d;
            dArray2[n] = -this.diagIm[n] / d;
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public ComplexMatrix hermitianAdjoint() {
        return this.conjugate();
    }

    public ComplexMatrix conjugate() {
        double[] dArray = new double[this.numRows];
        dArray[0] = -this.diagIm[0];
        int n = 1;
        while (n < this.numRows) {
            dArray[n] = -this.diagIm[n];
            ++n;
        }
        return new ComplexDiagonalMatrix(this.diagRe, dArray);
    }

    public Matrix transpose() {
        return this;
    }

    public ComplexSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.numRows] = 1;
        this.LU = new ComplexDiagonalMatrix[2];
        this.LU[0] = ComplexDiagonalMatrix.identity(this.numRows);
        this.LU[1] = this;
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public ComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[] complexArray = new Complex[this.numRows];
        complexArray[0] = complexMapping.map(this.diagRe[0], this.diagIm[0]);
        int n = 1;
        while (n < this.numRows) {
            complexArray[n] = complexMapping.map(this.diagRe[n], this.diagIm[n]);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }
}

