/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class DoubleMatrix
extends Matrix {
    protected static final int ARRAY_2D = 1;
    protected double[][] matrix;

    protected DoubleMatrix(int n, int n2, int n3) {
        super(n, n2);
        this.storageFormat = n3;
    }

    public DoubleMatrix(int n, int n2) {
        this(n, n2, 1);
        this.matrix = new double[n][n2];
    }

    public DoubleMatrix(double[][] dArray) {
        this(dArray.length, dArray[0].length, 1);
        this.matrix = dArray;
    }

    public DoubleMatrix(DoubleVector[] doubleVectorArray) {
        this(doubleVectorArray[0].dimension(), doubleVectorArray.length);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                this.matrix[n][n2] = doubleVectorArray[n2].getComponent(n);
                ++n2;
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleMatrix && this.numRows == ((DoubleMatrix)object).rows() && this.numCols == ((DoubleMatrix)object).columns()) {
            DoubleMatrix doubleMatrix = (DoubleMatrix)object;
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (Math.abs(this.matrix[n][n2] - doubleMatrix.getElement(n, n2)) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.matrix[n][n2]);
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public IntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                nArray[n][n2] = Math.round((float)this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        return new ComplexMatrix(this.matrix, new double[this.numRows][this.numCols]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n][n2] = d;
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.numCols) {
                d2 += Math.abs(this.matrix[n][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d = ExtraMath.hypot(d, this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof DoubleMatrix) {
            return this.add((DoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof DoubleMatrix) {
            return this.subtract((DoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.matrix[n][0] / d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrix[n][n2] / d;
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.matrix[n][0] * doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.matrix[n][n2] * doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.matrix[n][0] * doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.matrix[n][n2] * doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                dArray[n] = this.matrix[n][0] * abstractDoubleVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[n][n2] * abstractDoubleVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
        }
        if (this.numCols == doubleMatrix.rows()) {
            double[][] dArray = new double[this.numRows][doubleMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.columns()) {
                    dArray[n][n2] = this.matrix[n][0] * doubleMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == doubleMatrix.columns()) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.numCols) {
                    dArray[n][n2] = this.matrix[n][0] * doubleMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == doubleMatrix.numCols) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleMatrix directSum(DoubleMatrix doubleMatrix) {
        double[][] dArray = new double[this.numRows + doubleMatrix.numRows][this.numCols + doubleMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < doubleMatrix.numRows) {
            int n4 = 0;
            while (n4 < doubleMatrix.numCols) {
                dArray[n3 + this.numRows][n4 + this.numCols] = doubleMatrix.getElement(n3, n4);
                ++n4;
            }
            ++n3;
        }
        return new DoubleMatrix(dArray);
    }

    public DoubleMatrix tensorProduct(DoubleMatrix doubleMatrix) {
        double[][] dArray = new double[this.numRows * doubleMatrix.numRows][this.numCols * doubleMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < doubleMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < doubleMatrix.numCols) {
                        dArray[n * doubleMatrix.numRows + n3][n2 * doubleMatrix.numCols + n4] = this.matrix[n][n2] * doubleMatrix.getElement(n3, n4);
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = mapping.map(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = mapping.map(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }
}

