/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSparseSquareMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class DoubleSparseMatrix
extends DoubleMatrix {
    protected static final int SPARSE = 2;
    private int[] colPos;
    private int[] rows;

    public DoubleSparseMatrix(int n, int n2) {
        super(n, n2, 2);
        this.matrix = new double[1][0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseMatrix(double[][] dArray) {
        super(dArray.length, dArray[0].length, 2);
        this.rows = new int[this.numRows + 1];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            while (n3 < this.numCols) {
                if (Math.abs(dArray[n2][n3]) > GlobalSettings.ZERO_TOL) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        this.matrix = new double[1][n];
        this.colPos = new int[n];
        n = 0;
        int n4 = 0;
        while (n4 < this.numRows) {
            this.rows[n4] = n;
            int n5 = 0;
            while (n5 < this.numCols) {
                if (Math.abs(dArray[n4][n5]) > GlobalSettings.ZERO_TOL) {
                    this.matrix[0][n] = dArray[n4][n5];
                    this.colPos[n] = n5;
                    ++n;
                }
                ++n5;
            }
            ++n4;
        }
        this.rows[this.numRows] = n;
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleSparseMatrix && this.numRows == ((DoubleSparseMatrix)object).numRows && this.numCols == ((DoubleSparseMatrix)object).numCols) {
            DoubleSparseMatrix doubleSparseMatrix = (DoubleSparseMatrix)object;
            if (this.colPos.length != doubleSparseMatrix.colPos.length) {
                return false;
            }
            int n = 1;
            while (n < this.rows.length) {
                if (this.rows[n] != doubleSparseMatrix.rows[n]) {
                    return false;
                }
                ++n;
            }
            int n2 = 1;
            while (n2 < this.colPos.length) {
                if (this.colPos[n2] != doubleSparseMatrix.colPos[n2]) {
                    return false;
                }
                if (Math.abs(this.matrix[0][n2] - doubleSparseMatrix.matrix[0][n2]) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public IntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                nArray[n][n2] = Math.round((float)this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, new double[this.numRows][this.numCols]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    return this.matrix[0][n3];
                }
                ++n3;
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                return;
            }
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    this.matrix[0][n3] = d;
                    return;
                }
                ++n3;
            }
            double[] dArray = this.matrix[0];
            int[] nArray = this.colPos;
            this.matrix[0] = new double[dArray.length + 1];
            this.colPos = new int[nArray.length + 1];
            System.arraycopy(dArray, 0, this.matrix[0], 0, this.rows[n]);
            System.arraycopy(nArray, 0, this.colPos, 0, this.rows[n]);
            n3 = this.rows[n];
            while (n3 < this.rows[n + 1] && nArray[n3] < n2) {
                this.matrix[0][n3] = dArray[n3];
                this.colPos[n3] = nArray[n3];
                ++n3;
            }
            this.matrix[0][n3] = d;
            this.colPos[n3] = n2;
            System.arraycopy(dArray, n3, this.matrix[0], n3 + 1, dArray.length - n3);
            System.arraycopy(nArray, n3, this.colPos, n3 + 1, nArray.length - n3);
            n3 = n + 1;
            while (n3 < this.rows.length) {
                int n4 = n3++;
                this.rows[n4] = this.rows[n4] + 1;
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = this.rows[n];
            while (n2 < this.rows[n + 1]) {
                d2 += Math.abs(this.matrix[0][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.colPos.length) {
            d += this.matrix[0][n] * this.matrix[0][n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 2: {
                return this.add((DoubleSparseMatrix)doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.matrix[0][n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] + doubleMatrix.matrix[n][0];
                n2 = 1;
                while (n2 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n3 = n2;
                    dArray3[n3] = dArray3[n3] + doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix add(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.numRows, this.numCols);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseMatrix2.setElement(n, n2, this.getElement(n, n2) + doubleSparseMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 2: {
                return this.subtract((DoubleSparseMatrix)doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.matrix[0][n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] - doubleMatrix.matrix[n][0];
                n2 = 1;
                while (n2 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n3 = n2;
                    dArray3[n3] = dArray3[n3] - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix subtract(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.numRows, this.numCols);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseMatrix2.setElement(n, n2, this.getElement(n, n2) - doubleSparseMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.matrix[0] = new double[this.matrix[0].length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseMatrix.matrix[0][n] = d * this.matrix[0][n];
            ++n;
        }
        return doubleSparseMatrix;
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
            case 2: {
                return this.scalarProduct((DoubleSparseMatrix)doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.matrix[0][n2] * doubleMatrix.getElement(n, this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.matrix[0][n2] * doubleMatrix.matrix[n][this.colPos[n2]];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numRows == doubleSparseMatrix.numRows && this.numCols == doubleSparseMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.matrix[0][n2] * doubleSparseMatrix.getElement(n, this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.numCols == doubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[0][n2] * doubleVector.getComponent(this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 2: {
                return this.multiply((DoubleSparseMatrix)doubleMatrix);
            }
        }
        if (this.numCols == doubleMatrix.rows()) {
            double[][] dArray = new double[this.numRows][doubleMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.columns()) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[0][n3] * doubleMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == doubleMatrix.columns()) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[0][n3] * doubleMatrix.matrix[this.colPos[n3]][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == doubleMatrix.numCols) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleMatrix multiply(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.numCols == doubleSparseMatrix.numRows) {
            DoubleMatrix doubleMatrix = this.numRows == doubleSparseMatrix.numCols ? new DoubleSparseSquareMatrix(this.numRows) : new DoubleSparseMatrix(this.numRows, doubleSparseMatrix.numCols);
            int n = 0;
            while (n < doubleMatrix.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.numCols) {
                    double d = 0.0;
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        d += this.matrix[0][n3] * doubleSparseMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    doubleMatrix.setElement(n, n2, d);
                    ++n2;
                }
                ++n;
            }
            return doubleMatrix;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numCols, this.numRows);
        int n = 0;
        while (n < this.numRows) {
            doubleSparseMatrix.setElement(0, n, this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.numCols) {
                doubleSparseMatrix.setElement(n2, n, this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return doubleSparseMatrix;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.numRows, this.numCols);
        doubleSparseMatrix.matrix[0] = new double[this.matrix[0].length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseMatrix.matrix[0][n] = mapping.map(this.matrix[0][n]);
            ++n;
        }
        return doubleSparseMatrix;
    }
}

