/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.SquareMatrix;

public final class DoubleSparseSquareMatrix
extends DoubleSquareMatrix
implements SquareMatrix {
    protected static final int SPARSE = 2;
    private int[] colPos;
    private int[] rows;

    public DoubleSparseSquareMatrix(int n) {
        super(n, 2);
        this.matrix = new double[1][0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseSquareMatrix(double[][] dArray) {
        super(dArray.length, 2);
        if (dArray.length != dArray[0].length) {
            this.matrix = null;
            this.colPos = null;
            this.rows = null;
            throw new MatrixDimensionException("The array is not square.");
        }
        this.rows = new int[this.numRows + 1];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            while (n3 < this.numCols) {
                if (Math.abs(dArray[n2][n3]) > GlobalSettings.ZERO_TOL) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        this.matrix = new double[1][n];
        this.colPos = new int[n];
        n = 0;
        int n4 = 0;
        while (n4 < this.numRows) {
            this.rows[n4] = n;
            int n5 = 0;
            while (n5 < this.numCols) {
                if (Math.abs(dArray[n4][n5]) > GlobalSettings.ZERO_TOL) {
                    this.matrix[0][n] = dArray[n4][n5];
                    this.colPos[n] = n5;
                    ++n;
                }
                ++n5;
            }
            ++n4;
        }
        this.rows[this.numRows] = n;
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleSparseSquareMatrix && this.numRows == ((DoubleSparseSquareMatrix)object).numRows) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix = (DoubleSparseSquareMatrix)object;
            if (this.colPos.length != doubleSparseSquareMatrix.colPos.length) {
                return false;
            }
            int n = 1;
            while (n < this.rows.length) {
                if (this.rows[n] != doubleSparseSquareMatrix.rows[n]) {
                    return false;
                }
                ++n;
            }
            int n2 = 1;
            while (n2 < this.colPos.length) {
                if (this.colPos[n2] != doubleSparseSquareMatrix.colPos[n2]) {
                    return false;
                }
                if (Math.abs(this.matrix[0][n2] - doubleSparseSquareMatrix.matrix[0][n2]) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public IntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                nArray[n][n2] = Math.round((float)this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, new double[this.numRows][this.numCols]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    return this.matrix[0][n3];
                }
                ++n3;
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                return;
            }
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    this.matrix[0][n3] = d;
                    return;
                }
                ++n3;
            }
            double[] dArray = this.matrix[0];
            int[] nArray = this.colPos;
            this.matrix[0] = new double[dArray.length + 1];
            this.colPos = new int[nArray.length + 1];
            System.arraycopy(dArray, 0, this.matrix[0], 0, this.rows[n]);
            System.arraycopy(nArray, 0, this.colPos, 0, this.rows[n]);
            n3 = this.rows[n];
            while (n3 < this.rows[n + 1] && nArray[n3] < n2) {
                this.matrix[0][n3] = dArray[n3];
                this.colPos[n3] = nArray[n3];
                ++n3;
            }
            this.matrix[0][n3] = d;
            this.colPos[n3] = n2;
            System.arraycopy(dArray, n3, this.matrix[0], n3 + 1, dArray.length - n3);
            System.arraycopy(nArray, n3, this.colPos, n3 + 1, nArray.length - n3);
            n3 = n + 1;
            while (n3 < this.rows.length) {
                int n4 = n3++;
                this.rows[n4] = this.rows[n4] + 1;
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
    }

    public double det() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose(null);
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.numRows) {
            d *= doubleSquareMatrixArray[1].matrix[n][n];
            ++n;
        }
        return d * (double)this.LUpivot[this.numRows];
    }

    public double trace() {
        double d = this.getElement(0, 0);
        int n = 1;
        while (n < this.numRows) {
            d += this.getElement(n, n);
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = this.rows[n];
            while (n2 < this.rows[n + 1]) {
                d2 += Math.abs(this.matrix[0][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.colPos.length) {
            d += this.matrix[0][n] * this.matrix[0][n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 2: {
                return this.add((DoubleSparseSquareMatrix)doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.matrix[0][n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] + doubleMatrix.matrix[n][0];
                n2 = 1;
                while (n2 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n3 = n2;
                    dArray3[n3] = dArray3[n3] + doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
            case 2: {
                return this.add((DoubleSparseSquareMatrix)doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) + doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix add(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numRows == doubleSparseSquareMatrix.numRows) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseSquareMatrix2.setElement(n, n2, this.getElement(n, n2) + doubleSparseSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 2: {
                return this.subtract((DoubleSparseSquareMatrix)doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    dArray[n][this.colPos[n2]] = this.matrix[0][n2];
                    ++n2;
                }
                double[] dArray2 = dArray[n];
                dArray2[0] = dArray2[0] - doubleMatrix.matrix[n][0];
                n2 = 1;
                while (n2 < this.numCols) {
                    double[] dArray3 = dArray[n];
                    int n3 = n2;
                    dArray3[n3] = dArray3[n3] - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
            case 2: {
                return this.subtract((DoubleSparseSquareMatrix)doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.getElement(n, 0) - doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseSquareMatrix subtract(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numRows == doubleSparseSquareMatrix.numRows) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    doubleSparseSquareMatrix2.setElement(n, n2, this.getElement(n, n2) - doubleSparseSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.matrix[0] = new double[this.matrix[0].length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseSquareMatrix.matrix[0][n] = d * this.matrix[0][n];
            ++n;
        }
        return doubleSparseSquareMatrix;
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
            case 2: {
                return this.scalarProduct((DoubleSparseSquareMatrix)doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.matrix[0][n2] * doubleMatrix.getElement(n, this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.matrix[0][n2] * doubleMatrix.matrix[n][this.colPos[n2]];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleSquareMatrix);
            }
            case 2: {
                return this.scalarProduct((DoubleSparseSquareMatrix)doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.matrix[0][n2] * doubleSquareMatrix.getElement(n, this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numRows == doubleSparseSquareMatrix.numRows) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    d += this.matrix[0][n2] * doubleSparseSquareMatrix.getElement(n, this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.numCols == doubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[0][n2] * doubleVector.getComponent(this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 2: {
                return this.multiply((DoubleSparseSquareMatrix)doubleMatrix);
            }
        }
        if (this.numCols == doubleMatrix.rows()) {
            double[][] dArray = new double[this.numRows][doubleMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.columns()) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[0][n3] * doubleMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < doubleMatrix.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[0][n3] * doubleMatrix.matrix[this.colPos[n3]][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
            case 2: {
                return this.multiply((DoubleSparseSquareMatrix)doubleSquareMatrix);
            }
        }
        if (this.numCols == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[0][n3] * doubleSquareMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[0][n3] * doubleSquareMatrix.matrix[this.colPos[n3]][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSparseSquareMatrix multiply(DoubleSparseSquareMatrix doubleSparseSquareMatrix) {
        if (this.numCols == doubleSparseSquareMatrix.numRows) {
            DoubleSparseSquareMatrix doubleSparseSquareMatrix2 = new DoubleSparseSquareMatrix(this.numRows);
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    double d = 0.0;
                    int n3 = this.rows[n];
                    while (n3 < this.rows[n + 1]) {
                        d += this.matrix[0][n3] * doubleSparseSquareMatrix.getElement(this.colPos[n3], n2);
                        ++n3;
                    }
                    doubleSparseSquareMatrix2.setElement(n, n2, d);
                    ++n2;
                }
                ++n;
            }
            return doubleSparseSquareMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        int n = 0;
        while (n < this.numRows) {
            doubleSparseSquareMatrix.setElement(0, n, this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.numCols) {
                doubleSparseSquareMatrix.setElement(n2, n, this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return doubleSparseSquareMatrix;
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        double[] dArray3 = new double[this.numRows];
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        int n = 0;
        while (n < this.numRows) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.numRows] = 1;
        int n2 = 0;
        while (n2 < this.numCols) {
            int n3;
            double d;
            n = 0;
            while (n < n2) {
                d = this.getElement(nArray[n], n2);
                n3 = 0;
                while (n3 < n) {
                    d -= dArray2[n][n3] * dArray2[n3][n2];
                    ++n3;
                }
                dArray2[n][n2] = d;
                ++n;
            }
            double d2 = 0.0;
            int n4 = n2;
            n = n2;
            while (n < this.numRows) {
                d = this.getElement(nArray[n], n2);
                n3 = 0;
                while (n3 < n2) {
                    d -= dArray2[n][n3] * dArray2[n3][n2];
                    ++n3;
                }
                dArray2[n][n2] = d;
                if ((d = Math.abs(d)) > d2) {
                    d2 = d;
                    n4 = n;
                }
                ++n;
            }
            if (n4 != n2) {
                System.arraycopy(dArray2[n2], 0, dArray3, 0, n2 + 1);
                System.arraycopy(dArray2[n4], 0, dArray2[n2], 0, n2 + 1);
                System.arraycopy(dArray3, 0, dArray2[n4], 0, n2 + 1);
                n3 = nArray[n2];
                nArray[n2] = nArray[n4];
                nArray[n4] = n3;
                nArray[this.numRows] = -nArray[this.numRows];
            }
            n = n2 + 1;
            while (n < this.numRows) {
                double[] dArray4 = dArray2[n];
                int n5 = n2;
                dArray4[n5] = dArray4[n5] / dArray2[n2][n2];
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numCols) {
            dArray[n2][n2] = 1.0;
            n = n2 + 1;
            while (n < this.numRows) {
                dArray[n][n2] = dArray2[n][n2];
                dArray2[n][n2] = 0.0;
                ++n;
            }
            ++n2;
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        double[][][] dArray = new double[2][this.numRows][this.numCols];
        double d = Math.sqrt(this.getElement(0, 0));
        dArray[1][0][0] = d;
        dArray[0][0][0] = d;
        int n = 1;
        while (n < this.numRows) {
            double d2 = this.getElement(n, 0) / dArray[0][0][0];
            dArray[1][0][n] = d2;
            dArray[0][n][0] = d2;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.numCols) {
            double d3 = this.getElement(n2, n2);
            n = 0;
            while (n < n2) {
                d3 -= dArray[0][n2][n] * dArray[0][n2][n];
                ++n;
            }
            double d4 = Math.sqrt(d3);
            dArray[1][n2][n2] = d4;
            dArray[0][n2][n2] = d4;
            n = n2 + 1;
            while (n < this.numRows) {
                d3 = this.getElement(n, n2);
                int n3 = 0;
                while (n3 < n) {
                    d3 -= dArray[0][n2][n3] * dArray[1][n3][n];
                    ++n3;
                }
                double d5 = d3 / dArray[1][n2][n2];
                dArray[1][n2][n] = d5;
                dArray[0][n][n2] = d5;
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        DoubleSparseSquareMatrix doubleSparseSquareMatrix = new DoubleSparseSquareMatrix(this.numRows);
        doubleSparseSquareMatrix.matrix[0] = new double[this.matrix[0].length];
        doubleSparseSquareMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseSquareMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseSquareMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseSquareMatrix.matrix[0][n] = mapping.map(this.matrix[0][n]);
            ++n;
        }
        return doubleSparseSquareMatrix;
    }
}

