/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerVector;
import JSci.maths.ComplexVector;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerVector;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class DoubleVector
extends AbstractDoubleVector {
    protected double[] vector;

    public DoubleVector(int n) {
        super(n);
        this.vector = new double[n];
    }

    public DoubleVector(double[] dArray) {
        super(dArray.length);
        this.vector = dArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof AbstractDoubleVector && this.N == ((AbstractDoubleVector)object).N) {
            AbstractDoubleVector abstractDoubleVector = (AbstractDoubleVector)object;
            int n = 0;
            while (n < this.N) {
                if (Math.abs(this.vector[n] - abstractDoubleVector.getComponent(n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }

    public AbstractIntegerVector toIntegerVector() {
        int[] nArray = new int[this.N];
        int n = 0;
        while (n < this.N) {
            nArray[n] = Math.round((float)this.vector[n]);
            ++n;
        }
        return new IntegerVector(nArray);
    }

    public AbstractComplexVector toComplexVector() {
        return new ComplexVector(this.vector, new double[this.N]);
    }

    public double getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        this.vector[n] = d;
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.vector[0]), n);
        int n2 = 1;
        while (n2 < this.N) {
            d += Math.pow(Math.abs(this.vector[n2]), n);
            ++n2;
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.vector[0];
        int n = 1;
        while (n < this.N) {
            d = ExtraMath.hypot(d, this.vector[n]);
            ++n;
        }
        return d;
    }

    public void normalize() {
        double d = this.norm();
        int n = 0;
        while (n < this.N) {
            int n2 = n++;
            this.vector[n2] = this.vector[n2] / d;
        }
    }

    public double infNorm() {
        double d = Math.abs(this.vector[0]);
        int n = 1;
        while (n < this.N) {
            double d2 = Math.abs(this.vector[n]);
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        double[] dArray = new double[this.N];
        dArray[0] = -this.vector[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = -this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.add((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] + abstractDoubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] + abstractDoubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector add(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] + doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] + doubleVector.vector[n];
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - abstractDoubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] - abstractDoubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] - doubleVector.vector[n];
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarMultiply(double d) {
        double[] dArray = new double[this.N];
        dArray[0] = d * this.vector[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = d * this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarDivide(double d) {
        double[] dArray = new double[this.N];
        dArray[0] = this.vector[0] / d;
        int n = 1;
        while (n < this.N) {
            dArray[n] = this.vector[n] / d;
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public double scalarProduct(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.scalarProduct((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double d = this.vector[0] * abstractDoubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                d += this.vector[n] * abstractDoubleVector.getComponent(n);
                ++n;
            }
            return d;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public double scalarProduct(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double d = this.vector[0] * doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                d += this.vector[n] * doubleVector.vector[n];
                ++n;
            }
            return d;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractDoubleVector mapComponents(Mapping mapping) {
        double[] dArray = new double[this.N];
        dArray[0] = mapping.map(this.vector[0]);
        int n = 1;
        while (n < this.N) {
            dArray[n] = mapping.map(this.vector[n]);
            ++n;
        }
        return new DoubleVector(dArray);
    }
}

