/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractIntegerVector;
import JSci.maths.ComplexVector;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class IntegerVector
extends AbstractIntegerVector {
    protected int[] vector;

    public IntegerVector(int n) {
        super(n);
        this.vector = new int[n];
    }

    public IntegerVector(int[] nArray) {
        super(nArray.length);
        this.vector = nArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof AbstractIntegerVector && this.N == ((AbstractIntegerVector)object).N) {
            AbstractIntegerVector abstractIntegerVector = (AbstractIntegerVector)object;
            int n = 0;
            while (n < this.N) {
                if (this.vector[n] != abstractIntegerVector.getComponent(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }

    public AbstractDoubleVector toDoubleVector() {
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.N) {
            dArray[n] = this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public AbstractComplexVector toComplexVector() {
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.N) {
            dArray[n] = this.vector[n];
            ++n;
        }
        return new ComplexVector(dArray, new double[this.N]);
    }

    public int getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
    }

    public void setComponent(int n, int n2) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        this.vector[n] = n2;
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.vector[0]), n);
        int n2 = 1;
        while (n2 < this.N) {
            d += Math.pow(Math.abs(this.vector[n2]), n);
            ++n2;
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.vector[0];
        int n = 1;
        while (n < this.N) {
            d = ExtraMath.hypot(d, this.vector[n]);
            ++n;
        }
        return d;
    }

    public double infNorm() {
        int n = Math.abs(this.vector[0]);
        int n2 = 1;
        while (n2 < this.N) {
            int n3 = Math.abs(this.vector[n2]);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public AbelianGroup.Member negate() {
        int[] nArray = new int[this.N];
        nArray[0] = -this.vector[0];
        int n = 1;
        while (n < this.N) {
            nArray[n] = -this.vector[n];
            ++n;
        }
        return new IntegerVector(nArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof IntegerVector) {
            return this.add((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector add(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.add((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] + abstractIntegerVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] + abstractIntegerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public IntegerVector add(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] + integerVector.vector[0];
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] + integerVector.vector[n];
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof IntegerVector) {
            return this.subtract((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector subtract(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.subtract((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] - abstractIntegerVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] - abstractIntegerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public IntegerVector subtract(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] - integerVector.vector[0];
            int n = 1;
            while (n < this.N) {
                nArray[n] = this.vector[n] - integerVector.vector[n];
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector scalarMultiply(int n) {
        int[] nArray = new int[this.N];
        nArray[0] = n * this.vector[0];
        int n2 = 1;
        while (n2 < this.N) {
            nArray[n2] = n * this.vector[n2];
            ++n2;
        }
        return new IntegerVector(nArray);
    }

    public int scalarProduct(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.scalarProduct((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            int n = this.vector[0] * abstractIntegerVector.getComponent(0);
            int n2 = 1;
            while (n2 < this.N) {
                n += this.vector[n2] * abstractIntegerVector.getComponent(n2);
                ++n2;
            }
            return n;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public int scalarProduct(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int n = this.vector[0] * integerVector.vector[0];
            int n2 = 1;
            while (n2 < this.N) {
                n += this.vector[n2] * integerVector.vector[n2];
                ++n2;
            }
            return n;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }
}

