/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractComplexVector;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.AbstractMath;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.polynomials.RealPolynomial;

public final class LinearMath
extends AbstractMath {
    private static final int EIGEN_MAX_ITERATIONS = 250;

    private LinearMath() {
    }

    public static AbstractDoubleVector solve(DoubleSquareMatrix doubleSquareMatrix, AbstractDoubleVector abstractDoubleVector) {
        int n;
        double d;
        int n2 = abstractDoubleVector.dimension();
        double[] dArray = new double[n2];
        int[] nArray = new int[n2 + 1];
        DoubleSquareMatrix[] doubleSquareMatrixArray = doubleSquareMatrix.luDecompose(nArray);
        int n3 = 0;
        while (n3 < n2) {
            d = abstractDoubleVector.getComponent(nArray[n3]);
            n = 0;
            while (n < n3) {
                d -= doubleSquareMatrixArray[0].getElement(n3, n) * dArray[n];
                ++n;
            }
            dArray[n3] = d / doubleSquareMatrixArray[0].getElement(n3, n3);
            ++n3;
        }
        n3 = n2 - 1;
        while (n3 >= 0) {
            d = dArray[n3];
            n = n3 + 1;
            while (n < n2) {
                d -= doubleSquareMatrixArray[1].getElement(n3, n) * dArray[n];
                ++n;
            }
            dArray[n3] = d / doubleSquareMatrixArray[1].getElement(n3, n3);
            --n3;
        }
        return new DoubleVector(dArray);
    }

    private static double[] solveCholesky(double[][] dArray, double[] dArray2) {
        int n;
        double d;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n2];
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix(dArray).choleskyDecompose();
        int n3 = 0;
        while (n3 < n2) {
            d = dArray2[n3];
            n = 0;
            while (n < n3) {
                d -= doubleSquareMatrixArray[0].getElement(n3, n) * dArray3[n];
                ++n;
            }
            dArray3[n3] = d / doubleSquareMatrixArray[0].getElement(n3, n3);
            ++n3;
        }
        n3 = n2 - 1;
        while (n3 >= 0) {
            d = dArray3[n3];
            n = n3 + 1;
            while (n < n2) {
                d -= doubleSquareMatrixArray[1].getElement(n3, n) * dArray3[n];
                ++n;
            }
            dArray3[n3] = d / doubleSquareMatrixArray[1].getElement(n3, n3);
            --n3;
        }
        return dArray3;
    }

    private static double[] solveQR(double[][] dArray, double[] dArray2) {
        int n;
        double d;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n2];
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix(dArray).qrDecompose();
        int n3 = 0;
        while (n3 < n2) {
            d = 0.0;
            n = 0;
            while (n < n2) {
                d += doubleSquareMatrixArray[0].getElement(n, n3) * dArray2[n];
                ++n;
            }
            dArray3[n3] = d;
            ++n3;
        }
        n3 = n2 - 1;
        while (n3 >= 0) {
            d = dArray3[n3];
            n = n3 + 1;
            while (n < n2) {
                d -= doubleSquareMatrixArray[1].getElement(n3, n) * dArray3[n];
                ++n;
            }
            dArray3[n3] = d / doubleSquareMatrixArray[1].getElement(n3, n3);
            --n3;
        }
        return dArray3;
    }

    public static AbstractDoubleVector solveGMRes(DoubleMatrix doubleMatrix, AbstractDoubleVector abstractDoubleVector, int n, double d) throws MaximumIterationsExceededException {
        double d2;
        if (n <= 0) {
            throw new IllegalArgumentException("Number of allowed iterations must be a positive integer: " + n + " <= 0.");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive or zero: " + d + " < 0.");
        }
        int n2 = doubleMatrix.rows();
        int n3 = 1;
        double[] dArray = new double[n2 + 1];
        double[][] dArray2 = new double[n2 + 1][2];
        double[] dArray3 = new double[2];
        AbstractDoubleVector abstractDoubleVector2 = new DoubleVector(doubleMatrix.rows());
        double d3 = abstractDoubleVector.norm();
        AbstractDoubleVector abstractDoubleVector3 = abstractDoubleVector.subtract(doubleMatrix.multiply(abstractDoubleVector2));
        double d4 = abstractDoubleVector3.norm();
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        double d5 = abstractDoubleVector3.norm() / d3;
        if (d2 <= d) {
            d = d5;
            n = 0;
            throw new IllegalArgumentException("There is a bug.");
        }
        AbstractDoubleVector[] abstractDoubleVectorArray = new DoubleVector[n2 + 1];
        DoubleMatrix doubleMatrix2 = new DoubleMatrix(n2 + 1, n2);
        while (n3 <= n) {
            double d6;
            abstractDoubleVectorArray[0] = abstractDoubleVector3.scalarMultiply(1.0 / d4);
            int n4 = 0;
            while (n4 < n2 + 1) {
                dArray[n4] = 0.0;
                ++n4;
            }
            dArray[0] = d4;
            n4 = 0;
            while (n4 < n2 && n3 <= n) {
                double d7;
                AbstractDoubleVector abstractDoubleVector4 = doubleMatrix.multiply(abstractDoubleVectorArray[n4]);
                int n5 = 0;
                while (n5 <= n4) {
                    doubleMatrix2.matrix[n5][n4] = abstractDoubleVector4.scalarProduct(abstractDoubleVectorArray[n5]);
                    abstractDoubleVector4 = abstractDoubleVector4.subtract(abstractDoubleVectorArray[n5].scalarMultiply(doubleMatrix2.matrix[n5][n4]));
                    ++n5;
                }
                doubleMatrix2.matrix[n4 + 1][n4] = abstractDoubleVector4.norm();
                abstractDoubleVectorArray[n4 + 1] = abstractDoubleVector4.scalarMultiply(1.0 / doubleMatrix2.matrix[n4 + 1][n4]);
                n5 = 0;
                while (n5 < n4) {
                    dArray3 = LinearMath.applyPlaneRotation(doubleMatrix2.matrix[n5][n4], doubleMatrix2.matrix[n5 + 1][n4], dArray2[n5][0], dArray2[n5][1]);
                    doubleMatrix2.matrix[n5][n4] = dArray3[0];
                    doubleMatrix2.matrix[n5 + 1][n4] = dArray3[1];
                    ++n5;
                }
                dArray2[n4] = LinearMath.generatePlaneRotation(doubleMatrix2.matrix[n4][n4], doubleMatrix2.matrix[n4 + 1][n4]);
                dArray3 = LinearMath.applyPlaneRotation(doubleMatrix2.matrix[n4][n4], doubleMatrix2.matrix[n4 + 1][n4], dArray2[n4][0], dArray2[n4][1]);
                doubleMatrix2.matrix[n4][n4] = dArray3[0];
                doubleMatrix2.matrix[n4 + 1][n4] = dArray3[1];
                dArray3 = LinearMath.applyPlaneRotation(dArray[n4], dArray[n4 + 1], dArray2[n4][0], dArray2[n4][1]);
                dArray[n4] = dArray3[0];
                dArray[n4 + 1] = dArray3[1];
                d5 = Math.abs(dArray[n4 + 1]) / d3;
                if (d7 < d) {
                    abstractDoubleVector2 = LinearMath.update(abstractDoubleVector2, n4, doubleMatrix2, dArray, abstractDoubleVectorArray);
                    d = d5;
                    n = n3;
                    return abstractDoubleVector2;
                }
                ++n4;
                ++n3;
            }
            abstractDoubleVector2 = LinearMath.update(abstractDoubleVector2, n2 - 1, doubleMatrix2, dArray, abstractDoubleVectorArray);
            abstractDoubleVector3 = abstractDoubleVector.subtract(doubleMatrix.multiply(abstractDoubleVector2));
            d4 = abstractDoubleVector3.norm();
            d5 = d4 / d3;
            if (!(d6 < d)) continue;
            d = d5;
            n = n3;
            return abstractDoubleVector2;
        }
        d = d5;
        throw new MaximumIterationsExceededException("(tol) " + d + ". It doesn't converge in " + n + "iterations. Try raising the number of allowed iterations or raising the tolerance.");
    }

    private static double[] generatePlaneRotation(double d, double d2) {
        double[] dArray = new double[2];
        if (d2 == 0.0) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
        } else if (Math.abs(d2) > Math.abs(d)) {
            double d3 = d / d2;
            dArray[1] = 1.0 / Math.sqrt(1.0 + d3 * d3);
            dArray[0] = d3 * dArray[1];
        } else {
            double d4 = d2 / d;
            dArray[0] = 1.0 / Math.sqrt(1.0 + d4 * d4);
            dArray[1] = d4 * dArray[0];
        }
        return dArray;
    }

    private static double[] applyPlaneRotation(double d, double d2, double d3, double d4) {
        double[] dArray = new double[]{d3 * d + d4 * d2, -d4 * d + d3 * d2};
        return dArray;
    }

    private static AbstractDoubleVector update(AbstractDoubleVector abstractDoubleVector, int n, DoubleMatrix doubleMatrix, double[] dArray, AbstractDoubleVector[] abstractDoubleVectorArray) {
        int n2;
        DoubleVector doubleVector = new DoubleVector(dArray);
        int n3 = n;
        while (n3 >= 0) {
            doubleVector.vector[n3] = doubleVector.vector[n3] / doubleMatrix.matrix[n3][n3];
            n2 = n3 - 1;
            while (n2 >= 0) {
                doubleVector.vector[n2] = doubleVector.vector[n2] - doubleMatrix.matrix[n2][n3] * doubleVector.vector[n3];
                --n2;
            }
            --n3;
        }
        n2 = 0;
        while (n2 <= n) {
            abstractDoubleVector = abstractDoubleVector.add(abstractDoubleVectorArray[n2].scalarMultiply(doubleVector.vector[n2]));
            ++n2;
        }
        return abstractDoubleVector;
    }

    public static RealPolynomial leastSquaresFit(int n, double[][] dArray) {
        int n2;
        double d;
        int n3 = n++;
        double[][] dArray2 = new double[n][n];
        double[] dArray3 = new double[n];
        int n4 = 0;
        while (n4 < n) {
            double d2 = 0.0;
            d = 0.0;
            n2 = 0;
            while (n2 < dArray[0].length) {
                double d3 = Math.pow(dArray[0][n2], n4);
                d += d3;
                d2 += d3 * dArray[1][n2];
                ++n2;
            }
            dArray2[0][n4] = d;
            dArray3[n4] = d2;
            ++n4;
        }
        n4 = 1;
        while (n4 < n) {
            System.arraycopy(dArray2[n4 - 1], 1, dArray2[n4], 0, n3);
            d = 0.0;
            n2 = 0;
            while (n2 < dArray[0].length) {
                d += Math.pow(dArray[0][n2], n3 + n4);
                ++n2;
            }
            dArray2[n4][n3] = d;
            ++n4;
        }
        return new RealPolynomial(LinearMath.solveCholesky(dArray2, dArray3));
    }

    public static AbstractDoubleVector linearRegression(double[][] dArray) {
        int n;
        double d;
        int n2 = dArray.length - 1;
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double[] dArray3 = new double[dArray.length];
        dArray2[0][0] = dArray[0].length;
        int n3 = 1;
        while (n3 < dArray.length) {
            d = 0.0;
            n = 0;
            while (n < dArray[0].length) {
                d += dArray[n3 - 1][n];
                ++n;
            }
            double d2 = d;
            dArray2[n3][0] = d2;
            dArray2[0][n3] = d2;
            ++n3;
        }
        double d3 = 0.0;
        n = 0;
        while (n < dArray[0].length) {
            d3 += dArray[n2][n];
            ++n;
        }
        dArray3[0] = d3;
        int n4 = 1;
        while (n4 < dArray.length) {
            n3 = n4;
            while (n3 < dArray.length) {
                d = 0.0;
                n = 0;
                while (n < dArray[0].length) {
                    d += dArray[n4 - 1][n] * dArray[n3 - 1][n];
                    ++n;
                }
                double d4 = d;
                dArray2[n3][n4] = d4;
                dArray2[n4][n3] = d4;
                ++n3;
            }
            d3 = 0.0;
            n = 0;
            while (n < dArray[0].length) {
                d3 += dArray[n4 - 1][n] * dArray[n2][n];
                ++n;
            }
            dArray3[n4] = d3;
            ++n4;
        }
        return new DoubleVector(LinearMath.solveCholesky(dArray2, dArray3));
    }

    public static AbstractDoubleVector[] orthonormalize(AbstractDoubleVector[] abstractDoubleVectorArray) {
        int n = abstractDoubleVectorArray.length;
        AbstractDoubleVector[] abstractDoubleVectorArray2 = new DoubleVector[n];
        int n2 = 0;
        while (n2 < n) {
            abstractDoubleVectorArray2[n2] = abstractDoubleVectorArray[n2];
            int n3 = 0;
            while (n3 < n2) {
                abstractDoubleVectorArray2[n2] = abstractDoubleVectorArray2[n2].subtract(abstractDoubleVectorArray2[n3].scalarMultiply(abstractDoubleVectorArray2[n3].scalarProduct(abstractDoubleVectorArray[n2])));
                ++n3;
            }
            abstractDoubleVectorArray2[n2].normalize();
            ++n2;
        }
        return abstractDoubleVectorArray2;
    }

    public static double[] eigenvalueSolveHermitian(ComplexSquareMatrix complexSquareMatrix) throws MaximumIterationsExceededException {
        int n = complexSquareMatrix.rows();
        double[][] dArray = new double[2 * n][2 * n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                double d = complexSquareMatrix.getElement(n2, n3).real();
                double d2 = complexSquareMatrix.getElement(n2, n3).imag();
                dArray[n2][n3] = d;
                dArray[n + n2][n + n3] = d;
                dArray[n + n2][n3] = d2;
                dArray[n2][n + n3] = -d2;
                ++n3;
            }
            ++n2;
        }
        double[] dArray2 = new double[2 * n];
        double[] dArray3 = new double[2 * n];
        LinearMath.reduceSymmetric1_SquareToTridiagonal(dArray, dArray2, dArray3);
        System.arraycopy(dArray3, 1, dArray3, 0, n - 1);
        dArray3[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray2, dArray3);
        double[] dArray4 = new double[n];
        System.arraycopy(dArray2, 0, dArray4, 0, n);
        return dArray4;
    }

    public static double[] eigenSolveHermitian(ComplexSquareMatrix complexSquareMatrix, AbstractComplexVector[] abstractComplexVectorArray) throws MaximumIterationsExceededException {
        int n;
        int n2 = complexSquareMatrix.rows();
        double[][] dArray = new double[2 * n2][2 * n2];
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                double d = complexSquareMatrix.getElement(n3, n).real();
                double d2 = complexSquareMatrix.getElement(n3, n).imag();
                dArray[n3][n] = d;
                dArray[n2 + n3][n2 + n] = d;
                dArray[n2 + n3][n] = d2;
                dArray[n3][n2 + n] = -d2;
                ++n;
            }
            ++n3;
        }
        double[] dArray2 = new double[2 * n2];
        double[] dArray3 = new double[2 * n2];
        LinearMath.reduceSymmetric2_SquareToTridiagonal(dArray, dArray2, dArray3);
        System.arraycopy(dArray3, 1, dArray3, 0, n2 - 1);
        dArray3[n2 - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray2, dArray3, dArray);
        double[] dArray4 = new double[n2];
        n3 = 0;
        while (n3 < n2) {
            dArray4[n3] = dArray2[n3];
            double[] dArray5 = new double[n2];
            double[] dArray6 = new double[n2];
            n = 0;
            while (n < n2) {
                dArray5[n] = dArray[n][n3];
                dArray6[n] = dArray[n + n2][n3];
                ++n;
            }
            abstractComplexVectorArray[n3] = new ComplexVector(dArray5, dArray6);
            ++n3;
        }
        return dArray4;
    }

    public static double[] eigenvalueSolveSymmetric(DoubleTridiagonalMatrix doubleTridiagonalMatrix) throws MaximumIterationsExceededException {
        int n = doubleTridiagonalMatrix.rows();
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = doubleTridiagonalMatrix.getElement(n3, n3);
            dArray2[n3] = doubleTridiagonalMatrix.getElement(n3, n3 + 1);
            ++n3;
        }
        dArray[n2] = doubleTridiagonalMatrix.getElement(n2, n2);
        dArray2[n2] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray, dArray2);
        return dArray;
    }

    public static double[] eigenSolveSymmetric(DoubleTridiagonalMatrix doubleTridiagonalMatrix, AbstractDoubleVector[] abstractDoubleVectorArray) throws MaximumIterationsExceededException {
        int n = doubleTridiagonalMatrix.rows();
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[n][n];
        int n3 = 0;
        while (n3 < n2) {
            dArray3[n3][n3] = 1.0;
            dArray[n3] = doubleTridiagonalMatrix.getElement(n3, n3);
            dArray2[n3] = doubleTridiagonalMatrix.getElement(n3, n3 + 1);
            ++n3;
        }
        dArray3[n2][n2] = 1.0;
        dArray[n2] = doubleTridiagonalMatrix.getElement(n2, n2);
        dArray2[n2] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray, dArray2, dArray3);
        n3 = 0;
        while (n3 < n) {
            DoubleVector doubleVector = new DoubleVector(n);
            int n4 = 0;
            while (n4 < n) {
                doubleVector.vector[n4] = dArray3[n4][n3];
                ++n4;
            }
            abstractDoubleVectorArray[n3] = doubleVector;
            ++n3;
        }
        return dArray;
    }

    public static double[] eigenvalueSolveSymmetric(DoubleSquareMatrix doubleSquareMatrix) throws MaximumIterationsExceededException {
        int n = doubleSquareMatrix.rows();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray3[n2][n3] = doubleSquareMatrix.getElement(n2, n3);
                ++n3;
            }
            ++n2;
        }
        LinearMath.reduceSymmetric1_SquareToTridiagonal(dArray3, dArray, dArray2);
        System.arraycopy(dArray2, 1, dArray2, 0, n - 1);
        dArray2[n - 1] = 0.0;
        LinearMath.eigenvalueSolveSymmetricTridiagonalMatrix(dArray, dArray2);
        return dArray;
    }

    public static double[] eigenSolveSymmetric(DoubleSquareMatrix doubleSquareMatrix, AbstractDoubleVector[] abstractDoubleVectorArray) throws MaximumIterationsExceededException {
        int n;
        int n2 = doubleSquareMatrix.rows();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[][] dArray3 = new double[n2][n2];
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n2) {
                dArray3[n3][n] = doubleSquareMatrix.getElement(n3, n);
                ++n;
            }
            ++n3;
        }
        LinearMath.reduceSymmetric2_SquareToTridiagonal(dArray3, dArray, dArray2);
        System.arraycopy(dArray2, 1, dArray2, 0, n2 - 1);
        dArray2[n2 - 1] = 0.0;
        LinearMath.eigenSolveSymmetricTridiagonalMatrix(dArray, dArray2, dArray3);
        n3 = 0;
        while (n3 < n2) {
            DoubleVector doubleVector = new DoubleVector(n2);
            n = 0;
            while (n < n2) {
                doubleVector.vector[n] = dArray3[n][n3];
                ++n;
            }
            abstractDoubleVectorArray[n3] = doubleVector;
            ++n3;
        }
        return dArray;
    }

    private static void eigenvalueSolveSymmetricTridiagonalMatrix(double[] dArray, double[] dArray2) throws MaximumIterationsExceededException {
        int n = dArray.length;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = 0;
            do {
                n4 = n3;
                while (n4 < n2) {
                    double d = Math.abs(dArray[n4]) + Math.abs(dArray[n4 + 1]);
                    if (Math.abs(dArray2[n4]) + d == d) break;
                    ++n4;
                }
                if (n4 == n3) continue;
                if (n5++ == 250) {
                    throw new MaximumIterationsExceededException("No convergence after 250 iterations.");
                }
                double d = (dArray[n3 + 1] - dArray[n3]) / (2.0 * dArray2[n3]);
                double d2 = Math.sqrt(d * d + 1.0);
                d = dArray[n4] - dArray[n3] + dArray2[n3] / (d + (d < 0.0 ? -Math.abs(d2) : Math.abs(d2)));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                int n6 = n4 - 1;
                while (n6 >= n3) {
                    double d6 = d4 * dArray2[n6];
                    double d7 = d3 * dArray2[n6];
                    if (Math.abs(d6) >= Math.abs(d)) {
                        d3 = d / d6;
                        d2 = Math.sqrt(d3 * d3 + 1.0);
                        dArray2[n6 + 1] = d6 * d2;
                        d4 = 1.0 / d2;
                        d3 *= d4;
                    } else {
                        d4 = d6 / d;
                        d2 = Math.sqrt(d4 * d4 + 1.0);
                        dArray2[n6 + 1] = d * d2;
                        d3 = 1.0 / d2;
                        d4 *= d3;
                    }
                    d = dArray[n6 + 1] - d5;
                    d2 = (dArray[n6] - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    dArray[n6 + 1] = d + d5;
                    d = d3 * d2 - d7;
                    --n6;
                }
                dArray[n3] = dArray[n3] - d5;
                dArray2[n3] = d;
                dArray2[n4] = 0.0;
            } while (n4 != n3);
            ++n3;
        }
    }

    private static void reduceSymmetric1_SquareToTridiagonal(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = n2 - 1;
            double d = 0.0;
            double d2 = 0.0;
            if (n3 > 0) {
                int n4 = 0;
                while (n4 <= n3) {
                    d += Math.abs(dArray[n2][n4]);
                    ++n4;
                }
                if (d == 0.0) {
                    dArray3[n2] = dArray[n2][n3];
                } else {
                    n4 = 0;
                    while (n4 <= n3) {
                        double[] dArray4 = dArray[n2];
                        int n5 = n4;
                        dArray4[n5] = dArray4[n5] / d;
                        d2 += dArray[n2][n4] * dArray[n2][n4];
                        ++n4;
                    }
                    double d3 = dArray[n2][n3];
                    double d4 = d3 >= 0.0 ? -Math.sqrt(d2) : Math.sqrt(d2);
                    dArray3[n2] = d * d4;
                    d2 -= d3 * d4;
                    dArray[n2][n3] = d3 - d4;
                    d3 = 0.0;
                    int n6 = 0;
                    while (n6 <= n3) {
                        d4 = 0.0;
                        n4 = 0;
                        while (n4 <= n6) {
                            d4 += dArray[n6][n4] * dArray[n2][n4];
                            ++n4;
                        }
                        n4 = n6 + 1;
                        while (n4 <= n3) {
                            d4 += dArray[n4][n6] * dArray[n2][n4];
                            ++n4;
                        }
                        dArray3[n6] = d4 / d2;
                        d3 += dArray3[n6] * dArray[n2][n6];
                        ++n6;
                    }
                    double d5 = d3 / (d2 + d2);
                    n6 = 0;
                    while (n6 <= n3) {
                        d3 = dArray[n2][n6];
                        dArray3[n6] = d4 = dArray3[n6] - d5 * d3;
                        n4 = 0;
                        while (n4 <= n6) {
                            double[] dArray5 = dArray[n6];
                            int n7 = n4;
                            dArray5[n7] = dArray5[n7] - (d3 * dArray3[n4] + d4 * dArray[n2][n4]);
                            ++n4;
                        }
                        ++n6;
                    }
                }
            } else {
                dArray3[n2] = dArray[n2][n3];
            }
            dArray2[n2] = d2;
            --n2;
        }
        dArray3[0] = 0.0;
        n2 = 0;
        while (n2 < n) {
            dArray2[n2] = dArray[n2][n2];
            ++n2;
        }
    }

    private static void eigenSolveSymmetricTridiagonalMatrix(double[] dArray, double[] dArray2, double[][] dArray3) throws MaximumIterationsExceededException {
        int n = dArray.length;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = 0;
            do {
                n4 = n3;
                while (n4 < n2) {
                    double d = Math.abs(dArray[n4]) + Math.abs(dArray[n4 + 1]);
                    if (Math.abs(dArray2[n4]) + d == d) break;
                    ++n4;
                }
                if (n4 == n3) continue;
                if (n5++ == 250) {
                    throw new MaximumIterationsExceededException("No convergence after 250 iterations.");
                }
                double d = (dArray[n3 + 1] - dArray[n3]) / (2.0 * dArray2[n3]);
                double d2 = Math.sqrt(d * d + 1.0);
                d = dArray[n4] - dArray[n3] + dArray2[n3] / (d + (d < 0.0 ? -Math.abs(d2) : Math.abs(d2)));
                double d3 = 1.0;
                double d4 = 1.0;
                double d5 = 0.0;
                int n6 = n4 - 1;
                while (n6 >= n3) {
                    double d6 = d4 * dArray2[n6];
                    double d7 = d3 * dArray2[n6];
                    if (Math.abs(d6) >= Math.abs(d)) {
                        d3 = d / d6;
                        d2 = Math.sqrt(d3 * d3 + 1.0);
                        dArray2[n6 + 1] = d6 * d2;
                        d4 = 1.0 / d2;
                        d3 *= d4;
                    } else {
                        d4 = d6 / d;
                        d2 = Math.sqrt(d4 * d4 + 1.0);
                        dArray2[n6 + 1] = d * d2;
                        d3 = 1.0 / d2;
                        d4 *= d3;
                    }
                    d = dArray[n6 + 1] - d5;
                    d2 = (dArray[n6] - d) * d4 + 2.0 * d3 * d7;
                    d5 = d4 * d2;
                    dArray[n6 + 1] = d + d5;
                    d = d3 * d2 - d7;
                    int n7 = 0;
                    while (n7 < n) {
                        d6 = dArray3[n7][n6 + 1];
                        dArray3[n7][n6 + 1] = d4 * dArray3[n7][n6] + d3 * d6;
                        dArray3[n7][n6] = d3 * dArray3[n7][n6] - d4 * d6;
                        ++n7;
                    }
                    --n6;
                }
                dArray[n3] = dArray[n3] - d5;
                dArray2[n3] = d;
                dArray2[n4] = 0.0;
            } while (n4 != n3);
            ++n3;
        }
    }

    private static void reduceSymmetric2_SquareToTridiagonal(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n;
        double d;
        int n2;
        int n3;
        int n4 = dArray2.length;
        int n5 = n4 - 1;
        while (n5 > 0) {
            n3 = n5 - 1;
            double d2 = 0.0;
            double d3 = 0.0;
            if (n3 > 0) {
                n2 = 0;
                while (n2 <= n3) {
                    d2 += Math.abs(dArray[n5][n2]);
                    ++n2;
                }
                if (d2 == 0.0) {
                    dArray3[n5] = dArray[n5][n3];
                } else {
                    n2 = 0;
                    while (n2 <= n3) {
                        double[] dArray4 = dArray[n5];
                        int n6 = n2;
                        dArray4[n6] = dArray4[n6] / d2;
                        d3 += dArray[n5][n2] * dArray[n5][n2];
                        ++n2;
                    }
                    double d4 = dArray[n5][n3];
                    d = d4 >= 0.0 ? -Math.sqrt(d3) : Math.sqrt(d3);
                    dArray3[n5] = d2 * d;
                    d3 -= d4 * d;
                    dArray[n5][n3] = d4 - d;
                    d4 = 0.0;
                    n = 0;
                    while (n <= n3) {
                        dArray[n][n5] = dArray[n5][n] / d3;
                        d = 0.0;
                        n2 = 0;
                        while (n2 <= n) {
                            d += dArray[n][n2] * dArray[n5][n2];
                            ++n2;
                        }
                        n2 = n + 1;
                        while (n2 <= n3) {
                            d += dArray[n2][n] * dArray[n5][n2];
                            ++n2;
                        }
                        dArray3[n] = d / d3;
                        d4 += dArray3[n] * dArray[n5][n];
                        ++n;
                    }
                    double d5 = d4 / (d3 + d3);
                    n = 0;
                    while (n <= n3) {
                        d4 = dArray[n5][n];
                        dArray3[n] = d = dArray3[n] - d5 * d4;
                        n2 = 0;
                        while (n2 <= n) {
                            double[] dArray5 = dArray[n];
                            int n7 = n2;
                            dArray5[n7] = dArray5[n7] - (d4 * dArray3[n2] + d * dArray[n5][n2]);
                            ++n2;
                        }
                        ++n;
                    }
                }
            } else {
                dArray3[n5] = dArray[n5][n3];
            }
            dArray2[n5] = d3;
            --n5;
        }
        dArray3[0] = 0.0;
        dArray2[0] = 0.0;
        n5 = 0;
        while (n5 < n4) {
            n3 = n5 - 1;
            if (dArray2[n5] != 0.0) {
                n = 0;
                while (n <= n3) {
                    d = 0.0;
                    n2 = 0;
                    while (n2 <= n3) {
                        d += dArray[n5][n2] * dArray[n2][n];
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 <= n3) {
                        double[] dArray6 = dArray[n2];
                        int n8 = n;
                        dArray6[n8] = dArray6[n8] - d * dArray[n2][n5];
                        ++n2;
                    }
                    ++n;
                }
            }
            dArray2[n5] = dArray[n5][n5];
            dArray[n5][n5] = 1.0;
            n = 0;
            while (n <= n3) {
                dArray[n5][n] = 0.0;
                dArray[n][n5] = 0.0;
                ++n;
            }
            ++n5;
        }
    }
}

