/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class CyclosConfiguration {
    private static final String MAX_PAYMENT_REQUEST_SENDER_THREADS = "cyclos.maxPaymentRequestSenderThreads";
    private static final String MAX_SMS_SENDER_THREADS = "cyclos.maxSmsSenderThreads";
    private static final String MAX_MAIL_SENDER_THREADS = "cyclos.maxMailSenderThreads";
    private static final String TRANSACTION_QUEUE_CAPACITY = "cyclos.transaction.queueCapacity";
    private static final String TRANSACTION_MAX_POOL_SIZE = "cyclos.transaction.maxPoolSize";
    private static final String TRANSACTION_CORE_POOL_SIZE = "cyclos.transaction.corePoolSize";
    private static final String HIBERNATE_C3P0_MAX_POOL_SIZE = "hibernate.c3p0.maxPoolSize";
    private static final int HIBERNATE_C3P0_MAX_POOL_SIZE_DEFAULT = 20;
    public static final String CYCLOS_PROPERTIES_FILE = "/cyclos.properties";

    public static Properties getCyclosProperties() throws IOException {
        Properties properties = new Properties();
        properties.put(MAX_MAIL_SENDER_THREADS, "5");
        properties.put(MAX_SMS_SENDER_THREADS, "50");
        properties.put(MAX_PAYMENT_REQUEST_SENDER_THREADS, "50");
        properties.load(CyclosConfiguration.class.getResourceAsStream(CYCLOS_PROPERTIES_FILE));
        String dbMaxPoolSizeStr = properties.getProperty(HIBERNATE_C3P0_MAX_POOL_SIZE);
        Integer dbMaxPoolSize = StringUtils.isEmpty((String)dbMaxPoolSizeStr) ? 20 : Integer.parseInt(dbMaxPoolSizeStr);
        CyclosConfiguration.ensureProperty(TRANSACTION_CORE_POOL_SIZE, dbMaxPoolSize, properties);
        CyclosConfiguration.ensureProperty(TRANSACTION_MAX_POOL_SIZE, dbMaxPoolSize * 3, properties);
        CyclosConfiguration.ensureProperty(TRANSACTION_QUEUE_CAPACITY, dbMaxPoolSize * 5, properties);
        return properties;
    }

    private static void ensureProperty(String property, Integer value, Properties properties) {
        if (!properties.containsKey(property)) {
            properties.put(property, value.toString());
        }
    }
}

