/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.access;

import nl.strohalm.cyclos.access.AdminPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public enum AdminAdminPermission implements AdminPermission
{
    ADMINS_VIEW(Module.ADMIN_ADMINS),
    ADMINS_REGISTER(Module.ADMIN_ADMINS),
    ADMINS_CHANGE_PROFILE(Module.ADMIN_ADMINS),
    ADMINS_CHANGE_GROUP(Module.ADMIN_ADMINS),
    ADMINS_REMOVE(Module.ADMIN_ADMINS),
    ACCESS_CHANGE_PASSWORD(Module.ADMIN_ADMIN_ACCESS),
    ACCESS_TRANSACTION_PASSWORD(Module.ADMIN_ADMIN_ACCESS),
    ACCESS_DISCONNECT(Module.ADMIN_ADMIN_ACCESS),
    ACCESS_ENABLE_LOGIN(Module.ADMIN_ADMIN_ACCESS),
    RECORDS_VIEW(Module.ADMIN_ADMIN_RECORDS, AdminGroup.Relationships.VIEW_ADMIN_RECORD_TYPES),
    RECORDS_CREATE(Module.ADMIN_ADMIN_RECORDS, AdminGroup.Relationships.CREATE_ADMIN_RECORD_TYPES),
    RECORDS_MODIFY(Module.ADMIN_ADMIN_RECORDS, AdminGroup.Relationships.MODIFY_ADMIN_RECORD_TYPES),
    RECORDS_DELETE(Module.ADMIN_ADMIN_RECORDS, AdminGroup.Relationships.DELETE_ADMIN_RECORD_TYPES);

    private final Module module;
    private String value;
    private String qualifiedName;
    private Relationship relationship;

    private AdminAdminPermission(Module module) {
        this(module, null);
    }

    private AdminAdminPermission(Module module, Relationship relationship) {
        this.module = module;
        this.relationship = relationship;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = PermissionHelper.getQualifiedPermissionName(this);
        }
        return this.qualifiedName;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = PermissionHelper.getValue(this);
        }
        return this.value;
    }

    @Override
    public Relationship relationship() {
        return this.relationship;
    }
}

