/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.access;

import nl.strohalm.cyclos.access.AdminPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public enum AdminSystemPermission implements AdminPermission
{
    CURRENCIES_MANAGE(Module.SYSTEM_CURRENCIES),
    CURRENCIES_VIEW(Module.SYSTEM_CURRENCIES),
    ACCOUNTS_MANAGE(Module.SYSTEM_ACCOUNTS),
    ACCOUNTS_VIEW(Module.SYSTEM_ACCOUNTS),
    ACCOUNTS_INFORMATION(Module.SYSTEM_ACCOUNTS, AdminGroup.Relationships.VIEW_INFORMATION_OF),
    ACCOUNTS_AUTHORIZED_INFORMATION(Module.SYSTEM_ACCOUNTS),
    ACCOUNTS_SCHEDULED_INFORMATION(Module.SYSTEM_ACCOUNTS),
    SETTINGS_MANAGE_LOCAL(Module.SYSTEM_SETTINGS),
    SETTINGS_MANAGE_ALERT(Module.SYSTEM_SETTINGS),
    SETTINGS_MANAGE_ACCESS(Module.SYSTEM_SETTINGS),
    SETTINGS_MANAGE_MAIL(Module.SYSTEM_SETTINGS),
    SETTINGS_MANAGE_LOG(Module.SYSTEM_SETTINGS),
    SETTINGS_VIEW(Module.SYSTEM_SETTINGS),
    SETTINGS_FILE(Module.SYSTEM_SETTINGS),
    CUSTOMIZED_FILES_MANAGE(Module.SYSTEM_CUSTOMIZED_FILES),
    CUSTOMIZED_FILES_VIEW(Module.SYSTEM_CUSTOMIZED_FILES),
    CUSTOM_IMAGES_MANAGE(Module.SYSTEM_CUSTOM_IMAGES),
    CUSTOM_IMAGES_VIEW(Module.SYSTEM_CUSTOM_IMAGES),
    CUSTOM_FIELDS_MANAGE(Module.SYSTEM_CUSTOM_FIELDS),
    CUSTOM_FIELDS_VIEW(Module.SYSTEM_CUSTOM_FIELDS),
    TRANSLATION_MANAGE(Module.SYSTEM_TRANSLATION),
    TRANSLATION_VIEW(Module.SYSTEM_TRANSLATION),
    TRANSLATION_FILE(Module.SYSTEM_TRANSLATION),
    TRANSLATION_MANAGE_MAIL_TRANSLATION(Module.SYSTEM_TRANSLATION),
    TRANSLATION_MANAGE_NOTIFICATION(Module.SYSTEM_TRANSLATION),
    THEMES_SELECT(Module.SYSTEM_THEMES),
    THEMES_REMOVE(Module.SYSTEM_THEMES),
    THEMES_IMPORT(Module.SYSTEM_THEMES),
    THEMES_EXPORT(Module.SYSTEM_THEMES),
    PAYMENTS_PAYMENT(Module.SYSTEM_PAYMENTS, Group.Relationships.TRANSFER_TYPES),
    PAYMENTS_AUTHORIZE(Module.SYSTEM_PAYMENTS),
    PAYMENTS_CANCEL(Module.SYSTEM_PAYMENTS),
    PAYMENTS_CHARGEBACK(Module.SYSTEM_PAYMENTS, SystemGroup.Relationships.CHARGEBACK_TRANSFER_TYPES),
    PAYMENTS_CANCEL_SCHEDULED(Module.SYSTEM_PAYMENTS),
    PAYMENTS_BLOCK_SCHEDULED(Module.SYSTEM_PAYMENTS),
    ACCOUNT_FEES_VIEW(Module.SYSTEM_ACCOUNT_FEES),
    ACCOUNT_FEES_CHARGE(Module.SYSTEM_ACCOUNT_FEES),
    AD_CATEGORIES_MANAGE(Module.SYSTEM_AD_CATEGORIES),
    AD_CATEGORIES_VIEW(Module.SYSTEM_AD_CATEGORIES),
    AD_CATEGORIES_FILE(Module.SYSTEM_AD_CATEGORIES),
    MESSAGE_CATEGORIES_MANAGE(Module.SYSTEM_MESSAGE_CATEGORIES),
    MESSAGE_CATEGORIES_VIEW(Module.SYSTEM_MESSAGE_CATEGORIES),
    ALERTS_MANAGE_MEMBER_ALERTS(Module.SYSTEM_ALERTS),
    ALERTS_MANAGE_SYSTEM_ALERTS(Module.SYSTEM_ALERTS),
    ALERTS_VIEW_MEMBER_ALERTS(Module.SYSTEM_ALERTS),
    ALERTS_VIEW_SYSTEM_ALERTS(Module.SYSTEM_ALERTS),
    ERROR_LOG_MANAGE(Module.SYSTEM_ERROR_LOG),
    ERROR_LOG_VIEW(Module.SYSTEM_ERROR_LOG),
    GROUPS_MANAGE_MEMBER(Module.SYSTEM_GROUPS),
    GROUPS_MANAGE_BROKER(Module.SYSTEM_GROUPS),
    GROUPS_MANAGE_ADMIN(Module.SYSTEM_GROUPS),
    REGISTRATION_AGREEMENTS_VIEW(Module.SYSTEM_REGISTRATION_AGREEMENTS),
    REGISTRATION_AGREEMENTS_MANAGE(Module.SYSTEM_REGISTRATION_AGREEMENTS),
    ADMIN_GROUPS_VIEW(Module.SYSTEM_ADMIN_GROUPS),
    ADMIN_GROUPS_MANAGE_ADMIN_CUSTOMIZED_FILES(Module.SYSTEM_ADMIN_GROUPS),
    GROUP_FILTERS_MANAGE(Module.SYSTEM_GROUP_FILTERS),
    GROUP_FILTERS_VIEW(Module.SYSTEM_GROUP_FILTERS),
    GROUP_FILTERS_MANAGE_CUSTOMIZED_FILES(Module.SYSTEM_GROUP_FILTERS),
    LOAN_GROUPS_MANAGE(Module.SYSTEM_LOAN_GROUPS),
    LOAN_GROUPS_VIEW(Module.SYSTEM_LOAN_GROUPS),
    REPORTS_CURRENT(Module.SYSTEM_REPORTS),
    REPORTS_MEMBER_LIST(Module.SYSTEM_REPORTS),
    REPORTS_SMS_LOGS(Module.SYSTEM_REPORTS),
    REPORTS_STATISTICS(Module.SYSTEM_REPORTS),
    REPORTS_SIMULATIONS(Module.SYSTEM_REPORTS),
    TASKS_ONLINE_STATE(Module.SYSTEM_TASKS),
    TASKS_MANAGE_INDEXES(Module.SYSTEM_TASKS),
    STATUS_VIEW(Module.SYSTEM_STATUS),
    STATUS_VIEW_CONNECTED_ADMINS(Module.SYSTEM_STATUS, AdminGroup.Relationships.VIEW_CONNECTED_ADMINS_OF),
    STATUS_VIEW_CONNECTED_BROKERS(Module.SYSTEM_STATUS),
    STATUS_VIEW_CONNECTED_MEMBERS(Module.SYSTEM_STATUS),
    STATUS_VIEW_CONNECTED_OPERATORS(Module.SYSTEM_STATUS),
    EXTERNAL_ACCOUNTS_MANAGE(Module.SYSTEM_EXTERNAL_ACCOUNTS),
    EXTERNAL_ACCOUNTS_VIEW(Module.SYSTEM_EXTERNAL_ACCOUNTS),
    EXTERNAL_ACCOUNTS_DETAILS(Module.SYSTEM_EXTERNAL_ACCOUNTS),
    EXTERNAL_ACCOUNTS_PROCESS_PAYMENT(Module.SYSTEM_EXTERNAL_ACCOUNTS),
    EXTERNAL_ACCOUNTS_CHECK_PAYMENT(Module.SYSTEM_EXTERNAL_ACCOUNTS),
    EXTERNAL_ACCOUNTS_MANAGE_PAYMENT(Module.SYSTEM_EXTERNAL_ACCOUNTS),
    MEMBER_RECORD_TYPES_MANAGE(Module.SYSTEM_MEMBER_RECORD_TYPES),
    MEMBER_RECORD_TYPES_VIEW(Module.SYSTEM_MEMBER_RECORD_TYPES),
    SERVICE_CLIENTS_MANAGE(Module.SYSTEM_SERVICE_CLIENTS),
    SERVICE_CLIENTS_VIEW(Module.SYSTEM_SERVICE_CLIENTS),
    CHANNELS_MANAGE(Module.SYSTEM_CHANNELS),
    CHANNELS_VIEW(Module.SYSTEM_CHANNELS),
    GUARANTEE_TYPES_MANAGE(Module.SYSTEM_GUARANTEE_TYPES),
    GUARANTEE_TYPES_VIEW(Module.SYSTEM_GUARANTEE_TYPES),
    CARD_TYPES_MANAGE(Module.SYSTEM_CARD_TYPES),
    CARD_TYPES_VIEW(Module.SYSTEM_CARD_TYPES),
    INFO_TEXTS_MANAGE(Module.SYSTEM_INFO_TEXTS),
    INFO_TEXTS_VIEW(Module.SYSTEM_INFO_TEXTS);

    private final Module module;
    private String value;
    private String qualifiedName;
    private Relationship relationship;

    private AdminSystemPermission(Module module) {
        this(module, null);
    }

    private AdminSystemPermission(Module module, Relationship relationship) {
        this.module = module;
        this.relationship = relationship;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = PermissionHelper.getQualifiedPermissionName(this);
        }
        return this.qualifiedName;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = PermissionHelper.getValue(this);
        }
        return this.value;
    }

    @Override
    public Relationship relationship() {
        return this.relationship;
    }
}

