/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.access;

import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public enum BrokerPermission implements Permission
{
    MEMBERS_REGISTER(Module.BROKER_MEMBERS),
    MEMBERS_MANAGE_PENDING(Module.BROKER_MEMBERS),
    MEMBERS_CHANGE_PROFILE(Module.BROKER_MEMBERS),
    MEMBERS_CHANGE_NAME(Module.BROKER_MEMBERS),
    MEMBERS_CHANGE_USERNAME(Module.BROKER_MEMBERS),
    MEMBERS_CHANGE_EMAIL(Module.BROKER_MEMBERS),
    MEMBERS_MANAGE_DEFAULTS(Module.BROKER_MEMBERS),
    MEMBERS_MANAGE_CONTRACTS(Module.BROKER_MEMBERS),
    ACCOUNTS_INFORMATION(Module.BROKER_ACCOUNTS),
    ACCOUNTS_AUTHORIZED_INFORMATION(Module.BROKER_ACCOUNTS),
    ACCOUNTS_SCHEDULED_INFORMATION(Module.BROKER_ACCOUNTS),
    REPORTS_VIEW(Module.BROKER_REPORTS),
    REPORTS_SHOW_ACCOUNT_INFORMATION(Module.BROKER_REPORTS, BrokerGroup.Relationships.BROKER_CAN_VIEW_INFORMATION_OF),
    ADS_VIEW(Module.BROKER_ADS),
    ADS_MANAGE(Module.BROKER_ADS),
    REFERENCES_MANAGE(Module.BROKER_REFERENCES),
    INVOICES_VIEW(Module.BROKER_INVOICES),
    INVOICES_SEND_AS_MEMBER_TO_MEMBER(Module.BROKER_INVOICES),
    INVOICES_SEND_AS_MEMBER_TO_SYSTEM(Module.BROKER_INVOICES),
    INVOICES_ACCEPT_AS_MEMBER_FROM_MEMBER(Module.BROKER_INVOICES),
    INVOICES_ACCEPT_AS_MEMBER_FROM_SYSTEM(Module.BROKER_INVOICES),
    INVOICES_DENY_AS_MEMBER(Module.BROKER_INVOICES),
    INVOICES_CANCEL_AS_MEMBER(Module.BROKER_INVOICES),
    LOANS_VIEW(Module.BROKER_LOANS),
    LOAN_GROUPS_VIEW(Module.BROKER_LOAN_GROUPS),
    DOCUMENTS_VIEW(Module.BROKER_DOCUMENTS, BrokerGroup.Relationships.BROKER_DOCUMENTS),
    DOCUMENTS_VIEW_MEMBER(Module.BROKER_DOCUMENTS),
    DOCUMENTS_MANAGE_MEMBER(Module.BROKER_DOCUMENTS),
    MESSAGES_SEND_TO_MEMBERS(Module.BROKER_MESSAGES),
    MEMBER_ACCESS_CHANGE_PASSWORD(Module.BROKER_MEMBER_ACCESS),
    MEMBER_ACCESS_RESET_PASSWORD(Module.BROKER_MEMBER_ACCESS),
    MEMBER_ACCESS_TRANSACTION_PASSWORD(Module.BROKER_MEMBER_ACCESS),
    MEMBER_ACCESS_CHANGE_PIN(Module.BROKER_MEMBER_ACCESS),
    MEMBER_ACCESS_UNBLOCK_PIN(Module.BROKER_MEMBER_ACCESS),
    MEMBER_ACCESS_CHANGE_CHANNELS_ACCESS(Module.BROKER_MEMBER_ACCESS),
    MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER(Module.BROKER_MEMBER_PAYMENTS, BrokerGroup.Relationships.TRANSFER_TYPES_AS_MEMBER),
    MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF(Module.BROKER_MEMBER_PAYMENTS, BrokerGroup.Relationships.TRANSFER_TYPES_AS_MEMBER),
    MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM(Module.BROKER_MEMBER_PAYMENTS, BrokerGroup.Relationships.TRANSFER_TYPES_AS_MEMBER),
    MEMBER_PAYMENTS_AUTHORIZE(Module.BROKER_MEMBER_PAYMENTS),
    MEMBER_PAYMENTS_CANCEL_AUTHORIZED_AS_MEMBER(Module.BROKER_MEMBER_PAYMENTS),
    MEMBER_PAYMENTS_CANCEL_SCHEDULED_AS_MEMBER(Module.BROKER_MEMBER_PAYMENTS),
    MEMBER_PAYMENTS_BLOCK_SCHEDULED_AS_MEMBER(Module.BROKER_MEMBER_PAYMENTS),
    MEMBER_RECORDS_VIEW(Module.BROKER_MEMBER_RECORDS, BrokerGroup.Relationships.BROKER_MEMBER_RECORD_TYPES),
    MEMBER_RECORDS_CREATE(Module.BROKER_MEMBER_RECORDS, BrokerGroup.Relationships.BROKER_CREATE_MEMBER_RECORD_TYPES),
    MEMBER_RECORDS_MODIFY(Module.BROKER_MEMBER_RECORDS, BrokerGroup.Relationships.BROKER_MODIFY_MEMBER_RECORD_TYPES),
    MEMBER_RECORDS_DELETE(Module.BROKER_MEMBER_RECORDS, BrokerGroup.Relationships.BROKER_DELETE_MEMBER_RECORD_TYPES),
    MEMBER_SMS_VIEW(Module.BROKER_MEMBER_SMS),
    CARDS_VIEW(Module.BROKER_CARDS),
    CARDS_GENERATE(Module.BROKER_CARDS),
    CARDS_CANCEL(Module.BROKER_CARDS),
    CARDS_BLOCK(Module.BROKER_CARDS),
    CARDS_UNBLOCK(Module.BROKER_CARDS),
    CARDS_CHANGE_CARD_SECURITY_CODE(Module.BROKER_CARDS),
    CARDS_UNBLOCK_SECURITY_CODE(Module.BROKER_CARDS),
    POS_VIEW(Module.BROKER_POS),
    POS_MANAGE(Module.BROKER_POS),
    POS_ASSIGN(Module.BROKER_POS),
    POS_BLOCK(Module.BROKER_POS),
    POS_DISCARD(Module.BROKER_POS),
    POS_UNBLOCK_PIN(Module.BROKER_POS),
    POS_CHANGE_PIN(Module.BROKER_POS),
    POS_CHANGE_PARAMETERS(Module.BROKER_POS),
    SMS_MAILINGS_FREE_SMS_MAILINGS(Module.BROKER_SMS_MAILINGS),
    SMS_MAILINGS_PAID_SMS_MAILINGS(Module.BROKER_SMS_MAILINGS),
    PREFERENCES_MANAGE_NOTIFICATIONS(Module.BROKER_PREFERENCES);

    private final Module module;
    private String value;
    private String qualifiedName;
    private Relationship relationship;

    private BrokerPermission(Module module) {
        this(module, null);
    }

    private BrokerPermission(Module module, Relationship relationship) {
        this.module = module;
        this.relationship = relationship;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = PermissionHelper.getQualifiedPermissionName(this);
        }
        return this.qualifiedName;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = PermissionHelper.getValue(this);
        }
        return this.value;
    }

    @Override
    public Relationship relationship() {
        return this.relationship;
    }
}

