/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.access;

import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public enum MemberPermission implements Permission
{
    PROFILE_VIEW(Module.MEMBER_PROFILE, MemberGroup.Relationships.CAN_VIEW_PROFILE_OF_GROUPS),
    PROFILE_CHANGE_USERNAME(Module.MEMBER_PROFILE),
    PROFILE_CHANGE_NAME(Module.MEMBER_PROFILE),
    PROFILE_CHANGE_EMAIL(Module.MEMBER_PROFILE),
    ACCESS_CHANGE_CHANNELS_ACCESS(Module.MEMBER_ACCESS),
    ACCESS_UNBLOCK_PIN(Module.MEMBER_ACCESS),
    ACCOUNT_AUTHORIZED_INFORMATION(Module.MEMBER_ACCOUNT),
    ACCOUNT_SCHEDULED_INFORMATION(Module.MEMBER_ACCOUNT),
    PAYMENTS_PAYMENT_TO_SELF(Module.MEMBER_PAYMENTS, Group.Relationships.TRANSFER_TYPES),
    PAYMENTS_PAYMENT_TO_MEMBER(Module.MEMBER_PAYMENTS, Group.Relationships.TRANSFER_TYPES),
    PAYMENTS_PAYMENT_TO_SYSTEM(Module.MEMBER_PAYMENTS, Group.Relationships.TRANSFER_TYPES),
    PAYMENTS_TICKET(Module.MEMBER_PAYMENTS),
    PAYMENTS_AUTHORIZE(Module.MEMBER_PAYMENTS),
    PAYMENTS_CANCEL_AUTHORIZED(Module.MEMBER_PAYMENTS),
    PAYMENTS_CANCEL_SCHEDULED(Module.MEMBER_PAYMENTS),
    PAYMENTS_BLOCK_SCHEDULED(Module.MEMBER_PAYMENTS),
    PAYMENTS_REQUEST(Module.MEMBER_PAYMENTS, MemberGroup.Relationships.REQUEST_PAYMENT_BY_CHANNELS),
    PAYMENTS_CHARGEBACK(Module.MEMBER_PAYMENTS, SystemGroup.Relationships.CHARGEBACK_TRANSFER_TYPES),
    INVOICES_VIEW(Module.MEMBER_INVOICES),
    INVOICES_SEND_TO_MEMBER(Module.MEMBER_INVOICES),
    INVOICES_SEND_TO_SYSTEM(Module.MEMBER_INVOICES),
    REFERENCES_VIEW(Module.MEMBER_REFERENCES),
    REFERENCES_GIVE(Module.MEMBER_REFERENCES),
    DOCUMENTS_VIEW(Module.MEMBER_DOCUMENTS, SystemGroup.Relationships.DOCUMENTS),
    LOANS_VIEW(Module.MEMBER_LOANS),
    LOANS_REPAY(Module.MEMBER_LOANS),
    ADS_VIEW(Module.MEMBER_ADS, MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS),
    ADS_PUBLISH(Module.MEMBER_ADS),
    PREFERENCES_MANAGE_NOTIFICATIONS(Module.MEMBER_PREFERENCES),
    PREFERENCES_MANAGE_AD_INTERESTS(Module.MEMBER_PREFERENCES),
    PREFERENCES_MANAGE_RECEIPT_PRINTER_SETTINGS(Module.MEMBER_PREFERENCES),
    REPORTS_VIEW(Module.MEMBER_REPORTS),
    REPORTS_SHOW_ACCOUNT_INFORMATION(Module.MEMBER_REPORTS, MemberGroup.Relationships.CAN_VIEW_INFORMATION_OF),
    MESSAGES_VIEW(Module.MEMBER_MESSAGES),
    MESSAGES_SEND_TO_MEMBER(Module.MEMBER_MESSAGES),
    MESSAGES_SEND_TO_ADMINISTRATION(Module.MEMBER_MESSAGES, SystemGroup.Relationships.MESSAGE_CATEGORIES),
    MESSAGES_MANAGE(Module.MEMBER_MESSAGES),
    OPERATORS_MANAGE(Module.MEMBER_OPERATORS),
    SMS_VIEW(Module.MEMBER_SMS),
    GUARANTEES_ISSUE_GUARANTEES(Module.MEMBER_GUARANTEES, Group.Relationships.GUARANTEE_TYPES),
    GUARANTEES_ISSUE_CERTIFICATIONS(Module.MEMBER_GUARANTEES, MemberGroup.Relationships.CAN_ISSUE_CERTIFICATION_TO_GROUPS),
    GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS(Module.MEMBER_GUARANTEES, MemberGroup.Relationships.CAN_BUY_WITH_PAYMENT_OBLIGATIONS_FROM_GROUPS),
    GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS(Module.MEMBER_GUARANTEES),
    CARDS_VIEW(Module.MEMBER_CARDS),
    CARDS_BLOCK(Module.MEMBER_CARDS),
    CARDS_UNBLOCK(Module.MEMBER_CARDS),
    CARDS_CHANGE_CARD_SECURITY_CODE(Module.MEMBER_CARDS);

    private final Module module;
    private String value;
    private String qualifiedName;
    private Relationship relationship;

    private MemberPermission(Module module) {
        this.module = module;
    }

    private MemberPermission(Module module, Relationship relationship) {
        this.module = module;
        this.relationship = relationship;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = PermissionHelper.getQualifiedPermissionName(this);
        }
        return this.qualifiedName;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = PermissionHelper.getValue(this);
        }
        return this.value;
    }

    @Override
    public Relationship relationship() {
        return this.relationship;
    }
}

