/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.access;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.ModuleType;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public enum Module {
    BASIC(ModuleType.BASIC),
    SYSTEM_CURRENCIES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_ACCOUNTS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_SETTINGS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_CUSTOMIZED_FILES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_CUSTOM_IMAGES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_CUSTOM_FIELDS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_TRANSLATION(ModuleType.ADMIN_SYSTEM),
    SYSTEM_THEMES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_PAYMENTS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_ACCOUNT_FEES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_AD_CATEGORIES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_MESSAGE_CATEGORIES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_ALERTS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_ERROR_LOG(ModuleType.ADMIN_SYSTEM),
    SYSTEM_GROUPS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_REGISTRATION_AGREEMENTS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_ADMIN_GROUPS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_GROUP_FILTERS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_LOAN_GROUPS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_REPORTS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_TASKS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_STATUS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_EXTERNAL_ACCOUNTS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_MEMBER_RECORD_TYPES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_SERVICE_CLIENTS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_CHANNELS(ModuleType.ADMIN_SYSTEM),
    SYSTEM_GUARANTEE_TYPES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_CARD_TYPES(ModuleType.ADMIN_SYSTEM),
    SYSTEM_INFO_TEXTS(ModuleType.ADMIN_SYSTEM),
    ADMIN_ADMINS(ModuleType.ADMIN_ADMIN),
    ADMIN_ADMIN_ACCESS(ModuleType.ADMIN_ADMIN),
    ADMIN_ADMIN_RECORDS(ModuleType.ADMIN_ADMIN),
    ADMIN_MEMBERS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_ACCESS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_BROKERINGS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_ACCOUNTS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_GROUPS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_REPORTS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_PAYMENTS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_INVOICES(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_ADS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_REFERENCES(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_TRANSACTION_FEEDBACKS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_LOANS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_LOAN_GROUPS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_MESSAGES(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_DOCUMENTS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_RECORDS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_BULK_ACTIONS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_SMS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_SMS_MAILINGS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_GUARANTEES(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_CARDS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_POS(ModuleType.ADMIN_MEMBER),
    ADMIN_MEMBER_PREFERENCES(ModuleType.ADMIN_MEMBER),
    BROKER_MEMBERS(ModuleType.BROKER),
    BROKER_ACCOUNTS(ModuleType.BROKER),
    BROKER_REPORTS(ModuleType.BROKER),
    BROKER_ADS(ModuleType.BROKER),
    BROKER_REFERENCES(ModuleType.BROKER),
    BROKER_INVOICES(ModuleType.BROKER),
    BROKER_LOANS(ModuleType.BROKER),
    BROKER_LOAN_GROUPS(ModuleType.BROKER),
    BROKER_DOCUMENTS(ModuleType.BROKER),
    BROKER_MESSAGES(ModuleType.BROKER),
    BROKER_MEMBER_ACCESS(ModuleType.BROKER),
    BROKER_MEMBER_PAYMENTS(ModuleType.BROKER),
    BROKER_MEMBER_RECORDS(ModuleType.BROKER),
    BROKER_MEMBER_SMS(ModuleType.BROKER),
    BROKER_CARDS(ModuleType.BROKER),
    BROKER_POS(ModuleType.BROKER),
    BROKER_SMS_MAILINGS(ModuleType.BROKER),
    BROKER_PREFERENCES(ModuleType.BROKER),
    MEMBER_PROFILE(ModuleType.MEMBER),
    MEMBER_ACCESS(ModuleType.MEMBER),
    MEMBER_ACCOUNT(ModuleType.MEMBER),
    MEMBER_PAYMENTS(ModuleType.MEMBER),
    MEMBER_INVOICES(ModuleType.MEMBER),
    MEMBER_REFERENCES(ModuleType.MEMBER),
    MEMBER_DOCUMENTS(ModuleType.MEMBER),
    MEMBER_LOANS(ModuleType.MEMBER),
    MEMBER_ADS(ModuleType.MEMBER),
    MEMBER_PREFERENCES(ModuleType.MEMBER),
    MEMBER_REPORTS(ModuleType.MEMBER),
    MEMBER_MESSAGES(ModuleType.MEMBER),
    MEMBER_OPERATORS(ModuleType.MEMBER),
    MEMBER_SMS(ModuleType.MEMBER),
    MEMBER_GUARANTEES(ModuleType.MEMBER),
    MEMBER_CARDS(ModuleType.MEMBER),
    OPERATOR_ACCOUNT(ModuleType.OPERATOR),
    OPERATOR_PAYMENTS(ModuleType.OPERATOR),
    OPERATOR_INVOICES(ModuleType.OPERATOR),
    OPERATOR_REFERENCES(ModuleType.OPERATOR),
    OPERATOR_LOANS(ModuleType.OPERATOR),
    OPERATOR_ADS(ModuleType.OPERATOR),
    OPERATOR_REPORTS(ModuleType.OPERATOR),
    OPERATOR_CONTACTS(ModuleType.OPERATOR),
    OPERATOR_GUARANTEES(ModuleType.OPERATOR),
    OPERATOR_MESSAGES(ModuleType.OPERATOR);

    private final ModuleType type;
    private String value;
    private static Map<Module, Set<Permission>> PERMISSIONS_BY_MODULE;

    private static void processModules() {
        if (PERMISSIONS_BY_MODULE != null) {
            return;
        }
        EnumMap<Module, Set<Permission>> byModule = new EnumMap<Module, Set<Permission>>(Module.class);
        block9: for (Module module : Module.values()) {
            switch (module.type) {
                case BASIC: {
                    module.mapPermissions(BasicPermission.class, byModule);
                    continue block9;
                }
                case ADMIN_ADMIN: {
                    module.mapPermissions(AdminAdminPermission.class, byModule);
                    continue block9;
                }
                case ADMIN_MEMBER: {
                    module.mapPermissions(AdminMemberPermission.class, byModule);
                    continue block9;
                }
                case ADMIN_SYSTEM: {
                    module.mapPermissions(AdminSystemPermission.class, byModule);
                    continue block9;
                }
                case BROKER: {
                    module.mapPermissions(BrokerPermission.class, byModule);
                    continue block9;
                }
                case MEMBER: {
                    module.mapPermissions(MemberPermission.class, byModule);
                    continue block9;
                }
                case OPERATOR: {
                    module.mapPermissions(OperatorPermission.class, byModule);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported module type: " + module.type);
                }
            }
        }
        PERMISSIONS_BY_MODULE = byModule;
    }

    private Module(ModuleType type) {
        this.type = type;
        this.value = PermissionHelper.getValue(this);
    }

    public Set<Permission> getPermissions() {
        Module.processModules();
        return PERMISSIONS_BY_MODULE.get((Object)this);
    }

    public ModuleType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    private <T extends Enum<T>> void mapPermissions(Class<T> permissionEnumType, Map<Module, Set<Permission>> byModule) {
        EnumSet<? extends Permission> permissions = EnumSet.noneOf(this.type.getPermissionClass());
        for (Enum enumValue : (Enum[])permissionEnumType.getEnumConstants()) {
            Permission perm = (Permission)((Object)enumValue);
            if (perm.getModule() != this) continue;
            permissions.add(perm);
        }
        byModule.put(this, Collections.unmodifiableSet(permissions));
    }
}

