/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public enum ModuleType implements StringValuedEnum
{
    BASIC(BasicPermission.class, "B", "basic", false),
    ADMIN_SYSTEM(AdminSystemPermission.class, "AS", "system", false),
    ADMIN_MEMBER(AdminMemberPermission.class, "AM", "adminMember", true),
    ADMIN_ADMIN(AdminAdminPermission.class, "AA", "adminAdmin", false),
    MEMBER(MemberPermission.class, "M", "member", true),
    BROKER(BrokerPermission.class, "BK", "broker", true),
    OPERATOR(OperatorPermission.class, "O", "operator", true);

    private static Map<Group.Nature, List<ModuleType>> BY_GROUP_NATURE;
    private final Class<? extends Permission> permissionClass;
    private final String value;
    private final String prefix;
    private final boolean relatedToMember;

    public static List<ModuleType> getModuleTypes(Group.Nature groupNature) {
        if (BY_GROUP_NATURE == null) {
            HashMap byNature = new HashMap();
            for (Group.Nature nature : Group.Nature.values()) {
                byNature.put(nature, new ArrayList());
            }
            block8: for (Enum enum_ : ModuleType.values()) {
                switch (1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[enum_.ordinal()]) {
                    case 1: {
                        ((List)byNature.get((Object)Group.Nature.ADMIN)).add(enum_);
                        ((List)byNature.get((Object)Group.Nature.BROKER)).add(enum_);
                        ((List)byNature.get((Object)Group.Nature.MEMBER)).add(enum_);
                        ((List)byNature.get((Object)Group.Nature.OPERATOR)).add(enum_);
                        continue block8;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        ((List)byNature.get((Object)Group.Nature.ADMIN)).add(enum_);
                        continue block8;
                    }
                    case 5: {
                        ((List)byNature.get((Object)Group.Nature.BROKER)).add(enum_);
                        continue block8;
                    }
                    case 6: {
                        ((List)byNature.get((Object)Group.Nature.BROKER)).add(enum_);
                        ((List)byNature.get((Object)Group.Nature.MEMBER)).add(enum_);
                        continue block8;
                    }
                    case 7: {
                        ((List)byNature.get((Object)Group.Nature.OPERATOR)).add(enum_);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported module type: " + enum_);
                    }
                }
            }
            BY_GROUP_NATURE = Collections.unmodifiableMap(byNature);
        }
        return BY_GROUP_NATURE.get((Object)groupNature);
    }

    private ModuleType(Class<? extends Permission> permissionClass, String value, String prefix, boolean relatedToMember) {
        this.permissionClass = permissionClass;
        this.value = value;
        this.prefix = prefix;
        this.relatedToMember = relatedToMember;
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : Module.values()) {
            if (module.getType() != this) continue;
            modules.add(module);
        }
        return modules;
    }

    public Class<? extends Permission> getPermissionClass() {
        return this.permissionClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean isRelatedToMember() {
        return this.relatedToMember;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$nl$strohalm$cyclos$access$ModuleType;

        static {
            $SwitchMap$nl$strohalm$cyclos$access$ModuleType = new int[ModuleType.values().length];
            try {
                1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[ModuleType.BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[ModuleType.ADMIN_ADMIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[ModuleType.ADMIN_MEMBER.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[ModuleType.ADMIN_SYSTEM.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[ModuleType.BROKER.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[ModuleType.MEMBER.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$nl$strohalm$cyclos$access$ModuleType[ModuleType.OPERATOR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

