/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.access;

import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public enum OperatorPermission implements Permission
{
    ACCOUNT_AUTHORIZED_INFORMATION(Module.OPERATOR_ACCOUNT, MemberPermission.ACCOUNT_AUTHORIZED_INFORMATION),
    ACCOUNT_SCHEDULED_INFORMATION(Module.OPERATOR_ACCOUNT, MemberPermission.ACCOUNT_SCHEDULED_INFORMATION),
    ACCOUNT_ACCOUNT_INFORMATION(Module.OPERATOR_ACCOUNT, OperatorGroup.Relationships.CAN_VIEW_INFORMATION_OF),
    PAYMENTS_PAYMENT_TO_SELF(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_PAYMENT_TO_SELF),
    PAYMENTS_PAYMENT_TO_MEMBER(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_PAYMENT_TO_MEMBER),
    PAYMENTS_PAYMENT_TO_SYSTEM(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_PAYMENT_TO_SYSTEM),
    PAYMENTS_POSWEB_MAKE_PAYMENT(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_PAYMENT_TO_MEMBER),
    PAYMENTS_POSWEB_RECEIVE_PAYMENT(Module.OPERATOR_PAYMENTS),
    PAYMENTS_AUTHORIZE(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_AUTHORIZE),
    PAYMENTS_CANCEL_AUTHORIZED(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_CANCEL_AUTHORIZED),
    PAYMENTS_CANCEL_SCHEDULED(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_CANCEL_SCHEDULED),
    PAYMENTS_BLOCK_SCHEDULED(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_BLOCK_SCHEDULED),
    PAYMENTS_REQUEST(Module.OPERATOR_PAYMENTS, MemberPermission.PAYMENTS_REQUEST),
    INVOICES_VIEW(Module.OPERATOR_INVOICES, MemberPermission.INVOICES_VIEW),
    INVOICES_SEND_TO_MEMBER(Module.OPERATOR_INVOICES, MemberPermission.INVOICES_SEND_TO_MEMBER),
    INVOICES_SEND_TO_SYSTEM(Module.OPERATOR_INVOICES, MemberPermission.INVOICES_SEND_TO_SYSTEM),
    INVOICES_MANAGE(Module.OPERATOR_INVOICES, MemberPermission.INVOICES_SEND_TO_MEMBER, MemberPermission.INVOICES_SEND_TO_SYSTEM),
    REFERENCES_VIEW(Module.OPERATOR_REFERENCES, MemberPermission.REFERENCES_VIEW),
    REFERENCES_MANAGE_MEMBER_REFERENCES(Module.OPERATOR_REFERENCES, MemberPermission.REFERENCES_GIVE),
    REFERENCES_MANAGE_MEMBER_TRANSACTION_FEEDBACKS(Module.OPERATOR_REFERENCES, MemberPermission.REFERENCES_GIVE),
    LOANS_VIEW(Module.OPERATOR_LOANS, MemberPermission.LOANS_VIEW),
    LOANS_REPAY(Module.OPERATOR_LOANS, MemberPermission.LOANS_REPAY),
    ADS_PUBLISH(Module.OPERATOR_ADS, MemberPermission.ADS_PUBLISH),
    REPORTS_VIEW_MEMBER(Module.OPERATOR_REPORTS),
    CONTACTS_MANAGE(Module.OPERATOR_CONTACTS),
    CONTACTS_VIEW(Module.OPERATOR_CONTACTS),
    GUARANTEES_ISSUE_GUARANTEES(Module.OPERATOR_GUARANTEES, Group.Relationships.GUARANTEE_TYPES, MemberPermission.GUARANTEES_ISSUE_GUARANTEES),
    GUARANTEES_ISSUE_CERTIFICATIONS(Module.OPERATOR_GUARANTEES, MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS),
    GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS(Module.OPERATOR_GUARANTEES, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS),
    GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS(Module.OPERATOR_GUARANTEES, MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS),
    MESSAGES_VIEW(Module.OPERATOR_MESSAGES, MemberPermission.MESSAGES_VIEW),
    MESSAGES_SEND_TO_MEMBER(Module.OPERATOR_MESSAGES, MemberPermission.MESSAGES_SEND_TO_MEMBER),
    MESSAGES_SEND_TO_ADMINISTRATION(Module.OPERATOR_MESSAGES, MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION),
    MESSAGES_MANAGE(Module.OPERATOR_MESSAGES, MemberPermission.MESSAGES_MANAGE);

    private final Module module;
    private String value;
    private MemberPermission[] parentPermissions;
    private String qualifiedName;
    private Relationship relationship;

    private OperatorPermission(Module module) {
        this(module, (Relationship)null);
    }

    private OperatorPermission(Module module, MemberPermission ... parentPermissions) {
        this(module, (Relationship)null, parentPermissions);
    }

    private OperatorPermission(Module module, Relationship relationship) {
        this(module, relationship, new MemberPermission[0]);
    }

    private OperatorPermission(Module module, Relationship relationship, MemberPermission ... parentPermissions) {
        this.module = module;
        this.parentPermissions = parentPermissions;
        this.relationship = relationship;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    public MemberPermission[] getParentPermissions() {
        return this.parentPermissions;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = PermissionHelper.getQualifiedPermissionName(this);
        }
        return this.qualifiedName;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = PermissionHelper.getValue(this);
        }
        return this.value;
    }

    @Override
    public Relationship relationship() {
        return this.relationship;
    }
}

