/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.TransactionPassword;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.MessageResourcesLoadedListener;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class AbstractActionContext
implements Serializable,
MessageResolver {
    private static final long serialVersionUID = 7565129435156786075L;
    private final ActionForm form;
    private final ActionMapping actionMapping;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final MessageHelper messageHelper;
    private final User user;

    public AbstractActionContext(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, MessageHelper messageHelper, User user) {
        if (actionMapping == null || request == null || response == null || messageHelper == null || user == null) {
            throw new NullPointerException();
        }
        this.actionMapping = actionMapping;
        this.form = actionForm;
        this.request = request;
        this.response = response;
        this.messageHelper = messageHelper;
        this.user = user;
    }

    @Override
    public void addMessageResourcesLoadedListener(MessageResourcesLoadedListener listener) {
        throw new UnsupportedOperationException();
    }

    public void checkTransactionPassword(String transactionPassword) {
        try {
            AccessService accessService = SpringHelper.bean(this.getServletContext(), AccessService.class);
            accessService.checkTransactionPassword(transactionPassword);
        }
        catch (InvalidCredentialsException e) {
            throw new ValidationException("transactionPassword.error.invalid", new Object[0]);
        }
        catch (BlockedCredentialsException e) {
            HttpSession session = this.getSession();
            session.setAttribute("errorReturnTo", (Object)(session.getAttribute("pathPrefix") + "/home"));
            throw new ValidationException("transactionPassword.error.blockedByTrials", new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public ActionForward findForward(String name) {
        return this.actionMapping.findForward(name);
    }

    public AccountOwner getAccountOwner() {
        try {
            Object element = this.getElement();
            return ((Element)element).getAccountOwner();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public ActionMapping getActionMapping() {
        return this.actionMapping;
    }

    public <E extends Element> E getElement() {
        return (E)this.user.getElement();
    }

    public <F extends ActionForm> F getForm() {
        return (F)this.form;
    }

    public <G extends Group> G getGroup() {
        Object element = this.getElement();
        return (G)((Element)element).getGroup();
    }

    public ActionForward getInputForward() {
        return this.actionMapping.getInputForward();
    }

    public String getPathPrefix() {
        return RequestHelper.getPathPrefix(this.request);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.getSession().getServletContext();
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public ActionForward getSuccessForward() {
        return this.actionMapping.findForward("success");
    }

    public <U extends User> U getUser() {
        return (U)this.user;
    }

    public Writer getWriter() throws IOException {
        return this.response.getWriter();
    }

    public boolean isAdmin() {
        return this.user instanceof AdminUser;
    }

    public boolean isBroker() {
        if (!this.isMember()) {
            return false;
        }
        Member member = (Member)this.getElement();
        return member.getMemberGroup().isBroker();
    }

    public boolean isMember() {
        return this.user instanceof MemberUser;
    }

    public boolean isMemberAndNotBroker() {
        return this.isMember() && !this.isBroker();
    }

    public boolean isOperator() {
        return this.user instanceof OperatorUser;
    }

    public boolean isTransactionPasswordEnabled() {
        Object loggedGroup = this.getGroup();
        if (loggedGroup instanceof OperatorGroup) {
            GroupService groupService = SpringHelper.bean(this.getServletContext(), GroupService.class);
            loggedGroup = groupService.load(((Entity)loggedGroup).getId(), RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        TransactionPassword transactionPassword = ((Group)loggedGroup).getBasicSettings().getTransactionPassword();
        return transactionPassword.isUsed();
    }

    public boolean isTransactionPasswordEnabled(AccountType accountType) {
        if (!this.isTransactionPasswordEnabled()) {
            return false;
        }
        if (this.isAdmin()) {
            return true;
        }
        Member member = (Member)this.getAccountOwner();
        GroupService groupService = SpringHelper.bean(this.getServletContext(), GroupService.class);
        try {
            MemberGroupAccountSettings mgas = groupService.loadAccountSettings(member.getGroup().getId(), accountType.getId(), new Relationship[0]);
            return mgas.isTransactionPasswordRequired();
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    @Override
    public String message(String key, List<?> args) {
        return this.messageHelper.message(key, new Object[]{args});
    }

    @Override
    public String message(String key, Object ... args) {
        return this.messageHelper.message(key, args);
    }

    public void sendMessage(String key, Object ... arguments) {
        ActionHelper.sendMessage(this.getRequest(), this.getResponse(), key, arguments);
    }

    public void validateTransactionPassword() {
        this.validateTransactionPassword(((User)this.getUser()).getTransactionPasswordStatus());
    }

    protected void validateTransactionPassword(User.TransactionPasswordStatus tpStatus) {
        String errorKey = null;
        switch (tpStatus) {
            case BLOCKED: {
                errorKey = "transactionPassword.error.blocked";
                break;
            }
            case PENDING: 
            case NEVER_CREATED: {
                errorKey = "transactionPassword.error.pending";
            }
        }
        if (errorKey != null) {
            this.request.getSession().setAttribute("errorReturnTo", (Object)(this.request.getSession().getAttribute("pathPrefix") + "/home"));
            this.request.getSession().setAttribute("errorButtonKey", (Object)"global.ok");
            throw new ValidationException(errorKey, new Object[0]);
        }
    }
}

