/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.controls.AbstractActionContext;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.Navigation;
import nl.strohalm.cyclos.utils.SpringHelper;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ActionContext
extends AbstractActionContext {
    private static final long serialVersionUID = 1L;
    private PermissionService permissionService = SpringHelper.bean(this.getServletContext(), PermissionService.class);

    public ActionContext(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, User user, MessageHelper messageHelper) {
        super(actionMapping, actionForm, request, response, messageHelper, user);
    }

    public ActionForward back() {
        return ActionHelper.back(this.getActionMapping());
    }

    public Member getMember() {
        AccountOwner owner = this.getAccountOwner();
        return (Member)(owner instanceof Member ? owner : null);
    }

    public Navigation getNavigation() {
        return Navigation.get(this.getSession());
    }

    public boolean isBrokerOf(Member member) {
        if (member == null || !this.isBroker() || member.equals(this.getElement())) {
            return false;
        }
        return this.permissionService.manages(member);
    }

    public boolean isMemberOf(Operator operator) {
        if (operator == null || !this.isMember()) {
            return false;
        }
        return this.permissionService.manages(operator);
    }

    public ActionForward sendError(String key, Object ... arguments) {
        return ActionHelper.sendError(this.getActionMapping(), this.getRequest(), this.getResponse(), key, arguments);
    }
}

