/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.access.ChangeExpiredPasswordAction;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.QueryParseException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.AccessDeniedException;
import nl.strohalm.cyclos.exceptions.ExternalException;
import nl.strohalm.cyclos.exceptions.LoggedOutException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.customization.exceptions.ImageException;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.struts.access.ActionAccessMonitor;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.Navigation;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class BaseAction
extends Action {
    private static final Log LOG = LogFactory.getLog(BaseAction.class);
    protected LoginHelper loginHelper;
    protected ActionHelper actionHelper;
    protected PermissionService permissionService;
    protected AccessService accessService;
    protected ElementService elementService;
    protected GroupService groupService;
    protected MessageHelper messageHelper;
    protected SettingsService settingsService;
    private ActionAccessMonitor actionAccessMonitor;

    public final ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
        if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            return ActionHelper.sendError(actionMapping, request, response, "error.maxUploadSizeExceeded", FileUtils.byteCountToDisplaySize((long)settings.getMaxUploadBytes()));
        }
        HttpSession session = request.getSession(false);
        User user = null;
        try {
            user = this.validate(request, response, actionMapping);
            if (user == null) {
                return null;
            }
        }
        catch (LoggedOutException e) {
            if (session != null) {
                session.invalidate();
            }
            session = request.getSession();
            ActionForward forward = this.resolveLoginForward(actionMapping, request);
            if (this.storePath(actionMapping, request)) {
                String path = actionMapping.getPath();
                String queryString = request.getQueryString();
                if (StringUtils.isNotEmpty((String)queryString)) {
                    path = path + "?" + queryString;
                }
                session.setAttribute("returnTo", (Object)path);
                session.setAttribute("loggedOut", (Object)true);
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (path.contains("/operator/")) {
                    params.put("operator", true);
                }
                forward = ActionHelper.redirectWithParams(request, forward, params);
            }
            return forward;
        }
        catch (AccessDeniedException e) {
            if (session != null) {
                session.invalidate();
            }
            return ActionHelper.sendError(actionMapping, request, response, "error.accessDenied", new Object[0]);
        }
        catch (Exception e) {
            CurrentTransactionData.setError(e);
            this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
            LOG.error((Object)("Application error on " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            return ActionHelper.sendError(actionMapping, request, response, null, new Object[0]);
        }
        if (session != null) {
            String forwardName = null;
            if (Boolean.TRUE.equals(session.getAttribute("shallAcceptRegistrationAgreement"))) {
                forwardName = RequestHelper.isPosWeb(request) ? "poswebAcceptRegistrationAgreement" : "acceptRegistrationAgreement";
            } else if (Boolean.TRUE.equals(session.getAttribute("expiredPassword")) && !(this instanceof ChangeExpiredPasswordAction)) {
                if (RequestHelper.isPosWeb(request)) {
                    forwardName = "poswebChangeExpiredPassword";
                } else {
                    return this.actionHelper.getForwardFor(((Element)LoggedUser.element()).getNature(), "changeExpiredPassword", true);
                }
            }
            if (forwardName != null) {
                return actionMapping.findForward(forwardName);
            }
        }
        if (RequestHelper.isFromMenu(request)) {
            request.setAttribute("fromMenu", (Object)true);
        }
        ActionContext context = new ActionContext(actionMapping, actionForm, request, response, user, this.messageHelper);
        request.setAttribute("formAction", (Object)actionMapping.getPath());
        try {
            this.actionAccessMonitor.requestAccess(context);
            Navigation navigation = context.getNavigation();
            if (this.storePath(actionMapping, request)) {
                navigation.setLastAction(actionMapping);
                navigation.store(context);
            }
            ActionForward forward = this.executeAction(context);
            return forward;
        }
        catch (PermissionDeniedException e) {
            CurrentTransactionData.setError(e);
            boolean userBlocked = this.accessService.notifyPermissionDeniedException();
            if (userBlocked) {
                request.getSession(false).invalidate();
                return ActionHelper.sendError(actionMapping, request, response, "login.error.blocked", new Object[0]);
            }
            return ActionHelper.sendError(actionMapping, request, response, "error.permissionDenied", new Object[0]);
        }
        catch (QueryParseException e) {
            CurrentTransactionData.setError(e);
            return ActionHelper.sendError(actionMapping, request, response, "error.queryParse", new Object[0]);
        }
        catch (ImageHelper.UnknownImageTypeException e) {
            CurrentTransactionData.setError(e);
            String recognizedTypes = StringUtils.join((Object[])ImageHelper.ImageType.values(), (String)", ");
            return ActionHelper.sendError(actionMapping, request, response, "error.unknownImageType", recognizedTypes);
        }
        catch (ImageException e) {
            CurrentTransactionData.setError(e);
            return ActionHelper.sendError(actionMapping, request, response, e.getKey(), new Object[0]);
        }
        catch (ValidationException e) {
            CurrentTransactionData.setError(e);
            return ActionHelper.handleValidationException(actionMapping, request, response, e);
        }
        catch (EntityNotFoundException e) {
            return ActionHelper.handleValidationException(actionMapping, request, response, new ValidationException());
        }
        catch (ExternalException e) {
            CurrentTransactionData.setError(e);
            return ActionHelper.sendErrorWithMessage(actionMapping, request, response, e.getMessage());
        }
        catch (Exception e) {
            CurrentTransactionData.setError(e);
            this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
            LOG.error((Object)("Application error on " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            return ActionHelper.sendError(actionMapping, request, response, null, new Object[0]);
        }
    }

    @Inject
    public final void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setActionAccessMonitor(ActionAccessMonitor actionAccessMonitor) {
        this.actionAccessMonitor = actionAccessMonitor;
    }

    @Inject
    public final void setActionHelper(ActionHelper actionHelper) {
        this.actionHelper = actionHelper;
    }

    @Inject
    public final void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    @Inject
    public final void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Inject
    public final void setLoginHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    @Inject
    public final void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }

    @Inject
    public final void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Inject
    public final void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    protected abstract ActionForward executeAction(ActionContext var1) throws Exception;

    protected ActionForward resolveLoginForward(ActionMapping actionMapping, HttpServletRequest request) {
        return actionMapping.findForward("login");
    }

    protected boolean storePath(ActionMapping actionMapping, HttpServletRequest request) {
        String path = actionMapping.getPath();
        return RequestHelper.isGet(request) && StringUtils.isNotEmpty((String)actionMapping.getInput()) && (path.contains("admin/") || path.contains("member/") || path.contains("operator/"));
    }

    protected User validate(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws Exception {
        List<String> pathShouldNotInclude;
        User user = this.loginHelper.validateLoggedUser(request);
        if (user instanceof AdminUser) {
            pathShouldNotInclude = Arrays.asList("/member/", "/operator/");
        } else if (user instanceof MemberUser) {
            pathShouldNotInclude = Arrays.asList("/admin/", "/operator/");
        } else if (user instanceof OperatorUser) {
            pathShouldNotInclude = Arrays.asList("/member/", "/admin/");
        } else {
            throw new AccessDeniedException();
        }
        String path = actionMapping.getPath();
        for (String current : pathShouldNotInclude) {
            if (!path.contains(current)) continue;
            throw new AccessDeniedException();
        }
        return user;
    }
}

