/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.exceptions.LoggedOutException;
import nl.strohalm.cyclos.utils.ResponseHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class BaseAjaxAction
extends BaseAction {
    private static final Class<?> CLIENT_ABORT_EXCEPTION;
    protected ResponseHelper responseHelper;

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    protected abstract ContentType contentType();

    @Override
    protected final ActionForward executeAction(ActionContext context) throws Exception {
        block2: {
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            ContentType contentType = this.contentType();
            contentType.processResponse(response);
            this.responseHelper.setEncoding(response);
            this.responseHelper.setNoCache(response);
            try {
                this.renderContent(context);
                response.flushBuffer();
            }
            catch (Exception e) {
                if (CLIENT_ABORT_EXCEPTION != null && CLIENT_ABORT_EXCEPTION.isInstance(e)) break block2;
                this.handleException(request, response, e);
            }
        }
        return null;
    }

    protected void handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws Exception {
        response.sendError(500, StringUtils.trimToEmpty((String)e.getMessage()));
    }

    protected abstract void renderContent(ActionContext var1) throws Exception;

    @Override
    protected boolean storePath(ActionMapping actionMapping, HttpServletRequest request) {
        return false;
    }

    @Override
    protected User validate(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws Exception {
        try {
            return super.validate(request, response, actionMapping);
        }
        catch (LoggedOutException e) {
            request.getSession().invalidate();
            HttpSession session = request.getSession();
            session.setAttribute("loggedOut", (Object)true);
            response.sendError(401);
            return null;
        }
    }

    static {
        Class<?> clientAbortException;
        try {
            clientAbortException = Class.forName("org.apache.catalina.connector.ClientAbortException");
        }
        catch (Exception e) {
            clientAbortException = null;
        }
        CLIENT_ABORT_EXCEPTION = clientAbortException;
    }

    public static enum ContentType {
        CSV("application/msexcel"),
        JSON("application/json"),
        TEXT("text/plain"),
        HTML("text/html"),
        XML("text/xml");

        private final String contentType;

        private ContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void processResponse(HttpServletResponse response) {
            response.setContentType(this.contentType);
        }
    }
}

