/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.fetch.FetchService;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.csv.CSVWriter;

public abstract class BaseCsvAction
extends BaseAjaxAction
implements LocalSettingsChangeListener {
    private CSVWriter<?> cachedCsvWriter = null;

    public CSVWriter<?> getCsvWriter() {
        return this.cachedCsvWriter;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.cachedCsvWriter = null;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.CSV;
    }

    protected abstract Iterable<?> executeQuery(ActionContext var1);

    protected abstract String fileName(ActionContext var1);

    @Override
    protected void handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws Exception {
        throw e;
    }

    @Override
    protected final void renderContent(ActionContext context) throws Exception {
        CSVWriter<?> csvWriter = this.resolveCSVWriter(context);
        HttpServletResponse response = context.getResponse();
        try {
            this.responseHelper.setDownload(response, this.fileName(context));
            PrintWriter out = response.getWriter();
            csvWriter.writeHeader(out);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            CacheCleaner cacheCleaner = new CacheCleaner(SpringHelper.bean(context.getServletContext(), FetchService.class));
            int remaining = localSettings.getMaxIteratorResults() == 0 ? -1 : localSettings.getMaxIteratorResults();
            boolean shouldLimit = this.shouldLimit();
            for (Object row : this.executeQuery(context)) {
                if (remaining-- == 0 && shouldLimit) {
                    out.print(context.message("reports.print.limitation", localSettings.getMaxIteratorResults()));
                    break;
                }
                csvWriter.writeRow(row, out);
                cacheCleaner.clearCache();
            }
        }
        catch (Exception e) {
            try {
                response.resetBuffer();
                response.setContentType("text/html");
                this.responseHelper.setInline(response);
                throw e;
            }
            catch (IllegalStateException e1) {
                e.printStackTrace();
            }
        }
    }

    protected abstract CSVWriter<?> resolveCSVWriter(ActionContext var1);

    protected boolean shouldLimit() {
        return true;
    }
}

