/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public abstract class BaseFormAction
extends BaseAction {
    protected ResponseHelper responseHelper;

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected final ActionForward executeAction(ActionContext context) throws Exception {
        if (this.isFormPreparation(context)) {
            return this.handleDisplay(context);
        }
        if (this.isFormValidation(context)) {
            return this.handleValidation(context);
        }
        if (this.isFormSubmission(context)) {
            return this.handleSubmit(context);
        }
        return context.sendError("errors.invalid_request", new Object[0]);
    }

    protected void formAction(ActionContext context) throws Exception {
    }

    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        this.prepareForm(context);
        return context.getActionMapping().getInputForward();
    }

    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        this.formAction(context);
        return context.getSuccessForward();
    }

    protected ActionForward handleValidation(ActionContext context) {
        try {
            this.validateForm(context);
            this.responseHelper.writeValidationSuccess(context.getResponse());
        }
        catch (PermissionDeniedException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), new ValidationException("error.permissionDenied", new Object[0]));
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
        return null;
    }

    protected boolean isFormPreparation(ActionContext context) {
        return RequestHelper.isGet(context.getRequest());
    }

    protected boolean isFormSubmission(ActionContext context) {
        return RequestHelper.isPost(context.getRequest());
    }

    protected boolean isFormValidation(ActionContext context) {
        return RequestHelper.isValidation(context.getRequest());
    }

    protected void prepareForm(ActionContext context) throws Exception {
    }

    protected void validateForm(ActionContext context) {
    }
}

