/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.exceptions.QueryParseException;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.ExternalException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class BasePublicAction
extends Action {
    private final Log LOG = LogFactory.getLog(BasePublicAction.class);
    protected ElementService elementService;
    protected GroupService groupService;
    protected ActionHelper actionHelper;
    protected MessageHelper messageHelper;
    protected SettingsService settingsService;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
        if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            return ActionHelper.sendError(mapping, request, response, "error.maxUploadSizeExceeded", FileUtils.byteCountToDisplaySize((long)settings.getMaxUploadBytes()));
        }
        request.setAttribute("formAction", (Object)mapping.getPath());
        try {
            return this.executeAction(mapping, actionForm, request, response);
        }
        catch (PermissionDeniedException e) {
            return ActionHelper.sendError(mapping, request, response, "error.permissionDenied", new Object[0]);
        }
        catch (QueryParseException e) {
            return ActionHelper.sendError(mapping, request, response, "error.queryParse", new Object[0]);
        }
        catch (ImageHelper.UnknownImageTypeException e) {
            String recognizedTypes = StringUtils.join((Object[])ImageHelper.ImageType.values(), (String)", ");
            return ActionHelper.sendError(mapping, request, response, "error.unknownImageType", recognizedTypes);
        }
        catch (ValidationException e) {
            return ActionHelper.handleValidationException(mapping, request, response, e);
        }
        catch (ExternalException e) {
            return ActionHelper.sendErrorWithMessage(mapping, request, response, e.getMessage());
        }
        catch (Exception e) {
            this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
            this.LOG.error((Object)("Application error on " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            return ActionHelper.sendError(mapping, request, response, null, new Object[0]);
        }
    }

    @Inject
    public final void setActionHelper(ActionHelper actionHelper) {
        this.actionHelper = actionHelper;
    }

    @Inject
    public final void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    @Inject
    public final void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Inject
    public final void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }

    @Inject
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    protected abstract ActionForward executeAction(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;
}

