/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class BasePublicFormAction
extends BasePublicAction {
    protected ResponseHelper responseHelper;

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected final ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (RequestHelper.isGet(request)) {
            return this.handleDisplay(mapping, actionForm, request, response);
        }
        if (RequestHelper.isValidation(request)) {
            return this.handleValidation(mapping, actionForm, request, response);
        }
        return this.handleSubmit(mapping, actionForm, request, response);
    }

    protected void formAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected ActionForward handleDisplay(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareForm(mapping, actionForm, request, response);
        return mapping.getInputForward();
    }

    protected ActionForward handleSubmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.formAction(mapping, actionForm, request, response);
        return mapping.findForward("success");
    }

    protected ActionForward handleValidation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.validateForm(mapping, actionForm, request, response);
            this.responseHelper.writeValidationSuccess(response);
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(response, e);
        }
        return null;
    }

    protected void prepareForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected void validateForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws ValidationException {
    }
}

