/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseQueryAction
extends BaseAction
implements LocalSettingsChangeListener,
InitializingBean {
    private ResponseHelper responseHelper;
    private int defaultPageSize;
    private int maxIteratorResult;

    private static PageParameters ensurePageParameters(QueryParameters queryParameters, Integer pageSize) {
        PageParameters pageParameters = queryParameters.getPageParameters();
        if (pageParameters == null) {
            pageParameters = new PageParameters();
            queryParameters.setPageParameters(pageParameters);
            pageParameters.setCurrentPage(0);
        }
        pageParameters.setPageSize(pageSize);
        return pageParameters;
    }

    public void afterPropertiesSet() throws Exception {
        LocalSettings settings = this.settingsService.getLocalSettings();
        this.defaultPageSize = settings.getMaxPageResults();
        this.maxIteratorResult = settings.getMaxIteratorResults();
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        LocalSettings settings = event.getSource();
        this.defaultPageSize = settings.getMaxPageResults();
        this.maxIteratorResult = settings.getMaxIteratorResults();
    }

    @Inject
    public void setResponseHelper(ResponseHelper responseHelper) {
        this.responseHelper = responseHelper;
    }

    @Override
    protected final ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        if (this.isValidation(context)) {
            try {
                this.validateForm(context);
                this.responseHelper.writeValidationSuccess(context.getResponse());
            }
            catch (ValidationException e) {
                this.responseHelper.writeValidationErrors(context.getResponse(), e);
            }
            return null;
        }
        QueryParameters queryParameters = this.prepareForm(context);
        this.handlePageParameters(context, queryParameters);
        boolean willExecuteQuery = this.willExecuteQuery(context, queryParameters);
        if (willExecuteQuery) {
            this.executeQuery(context, queryParameters);
        }
        request.setAttribute("query", (Object)queryParameters);
        request.setAttribute("queryExecuted", (Object)willExecuteQuery);
        return context.getInputForward();
    }

    protected abstract void executeQuery(ActionContext var1, QueryParameters var2);

    protected Integer pageSize(ActionContext context) {
        return this.defaultPageSize;
    }

    protected abstract QueryParameters prepareForm(ActionContext var1);

    protected boolean shouldLimit() {
        return true;
    }

    protected void validateForm(ActionContext context) {
    }

    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return RequestHelper.isPost(context.getRequest());
    }

    private void handlePageParameters(ActionContext context, QueryParameters queryParameters) {
        Integer pageSize = this.pageSize(context);
        if (pageSize == null) {
            queryParameters.setResultType(QueryParameters.ResultType.ITERATOR);
            if (this.maxIteratorResult > 0 && this.shouldLimit()) {
                BaseQueryAction.ensurePageParameters(queryParameters, this.maxIteratorResult + 1);
            }
        } else {
            queryParameters.setResultType(QueryParameters.ResultType.PAGE);
            BaseQueryAction.ensurePageParameters(queryParameters, pageSize);
        }
    }

    private boolean isValidation(ActionContext context) {
        return RequestHelper.isValidation(context.getRequest());
    }
}

