/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.printsettings.ReceiptPrinterSettings;
import nl.strohalm.cyclos.services.preferences.ReceiptPrinterSettingsService;
import nl.strohalm.cyclos.utils.JSONBuilder;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.commons.lang.StringUtils;

public abstract class BaseReceiptPrintAjaxAction
extends BaseAjaxAction {
    private static final Pattern ASCII = Pattern.compile("(\\#\\d{1,3})");
    protected ReceiptPrinterSettingsService receiptPrinterSettingsService;

    private static String replaceASCII(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return "";
        }
        Matcher matcher = ASCII.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            char c = (char)Integer.parseInt(matcher.group(1).substring(1));
            matcher.appendReplacement(sb, String.valueOf(c));
        }
        matcher.appendTail(sb);
        return StringUtils.replace((String)sb.toString(), (String)"\\n", (String)"\n");
    }

    @Inject
    public final void setReceiptPrinterSettingsService(ReceiptPrinterSettingsService receiptPrinterSettingsService) {
        this.receiptPrinterSettingsService = receiptPrinterSettingsService;
    }

    @Override
    protected final BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        HttpServletResponse response = context.getResponse();
        ReceiptPrinterSettings receiptPrinterSettings = this.resolveReceiptPrinterSettings(context);
        String json = null;
        if (receiptPrinterSettings != null) {
            String beginCommand = BaseReceiptPrintAjaxAction.replaceASCII(receiptPrinterSettings.getBeginOfDocCommand());
            String endCommand = BaseReceiptPrintAjaxAction.replaceASCII(receiptPrinterSettings.getEndOfDocCommand());
            String text = BaseReceiptPrintAjaxAction.replaceASCII(this.resolveText(context, receiptPrinterSettings));
            String fullText = StringUtils.replace((String)(beginCommand + text + endCommand), (String)"\r\n", (String)"\n");
            json = new JSONBuilder().set("printerName", receiptPrinterSettings.getPrinterName()).set("text", fullText).toString();
        }
        this.responseHelper.writeJSON(response, json);
    }

    protected abstract String resolveText(ActionContext var1, ReceiptPrinterSettings var2);

    private ReceiptPrinterSettings resolveReceiptPrinterSettings(ActionContext context) {
        Long id;
        HttpServletRequest request = context.getRequest();
        String cookie = RequestHelper.getCookieValue((ServletRequest)request, "receiptPrinterId");
        try {
            id = IdConverter.instance().valueOf(cookie);
        }
        catch (Exception e) {
            id = null;
        }
        if (id == null) {
            return null;
        }
        try {
            return this.receiptPrinterSettingsService.load(id);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }
}

