/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.access.ChangePasswordForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.services.access.ChangeLoginPasswordDTO;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.CredentialsAlreadyUsedException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionConverter;
import org.apache.struts.action.ActionForward;

public class ChangePasswordAction
extends BaseFormAction {
    private DataBinder<ChangeLoginPasswordDTO> dataBinder;

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        ChangePasswordForm form = (ChangePasswordForm)((Object)context.getForm());
        User ofUser = this.ofUser(context);
        HttpServletRequest request = context.getRequest();
        request.setAttribute("user", (Object)ofUser);
        BasicGroupSettings basicSettings = ofUser.getElement().getGroup().getBasicSettings();
        request.setAttribute("passwordLength", (Object)basicSettings.getPasswordLength());
        request.setAttribute("ofAdmin", (Object)(ofUser instanceof AdminUser));
        Object loggedUser = context.getUser();
        request.setAttribute("myPassword", (Object)((Entity)loggedUser).equals(ofUser));
        request.setAttribute("shouldRequestOldPassword", (Object)this.shouldRequestOldPassword(context, ofUser));
        if (form.isEmbed()) {
            return new ActionForward("/pages/access/changePassword.jsp");
        }
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        ChangePasswordForm form = (ChangePasswordForm)((Object)context.getForm());
        ChangeLoginPasswordDTO params = this.getDataBinder().readFromString((Object)form);
        params.setUser(this.ofUser(context));
        try {
            this.accessService.changePassword(params);
            context.getSession().removeAttribute("expiredPassword");
            context.sendMessage("changePassword.modified", new Object[0]);
        }
        catch (InvalidCredentialsException e) {
            String key = "changePassword.error.incorrect";
            return context.sendError("changePassword.error.incorrect", new Object[0]);
        }
        catch (BlockedCredentialsException e) {
            request.getSession().invalidate();
            return context.sendError("changePassword.error.userBlocked", new Object[0]);
        }
        catch (CredentialsAlreadyUsedException e) {
            return context.sendError("changePassword.error.alreadyUsed", new Object[0]);
        }
        return this.resolveForward(context);
    }

    protected User ofUser(ActionContext context) {
        ChangePasswordForm form = (ChangePasswordForm)((Object)context.getForm());
        long userId = form.getUserId();
        if (userId == 0L || userId < 0L) {
            return context.getUser();
        }
        return this.elementService.loadUser(userId, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
    }

    protected ActionForward resolveForward(ActionContext context) {
        ChangePasswordForm form = (ChangePasswordForm)((Object)context.getForm());
        ActionForward forward = form.isEmbed() ? context.findForward("managePasswords") : this.actionHelper.getForwardFor(((User)context.getUser()).getElement().getNature(), "home", true);
        return ActionHelper.redirectWithParam(context.getRequest(), forward, "userId", form.getUserId());
    }

    protected boolean shouldRequestOldPassword(ActionContext context, User ofUser) {
        Object loggedUser = context.getUser();
        return ((Entity)loggedUser).equals(ofUser);
    }

    @Override
    protected void validateForm(ActionContext context) {
        ChangePasswordForm form = (ChangePasswordForm)((Object)context.getForm());
        ChangeLoginPasswordDTO params = this.getDataBinder().readFromString((Object)form);
        params.setUser(this.ofUser(context));
        this.accessService.validateChangePassword(params);
    }

    private DataBinder<ChangeLoginPasswordDTO> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ChangeLoginPasswordDTO> binder = BeanBinder.instance(ChangeLoginPasswordDTO.class);
            binder.registerBinder("user", PropertyBinder.instance(User.class, "userId"));
            binder.registerBinder("oldPassword", PropertyBinder.instance(String.class, "oldPassword", CoercionConverter.instance(String.class)));
            binder.registerBinder("newPassword", PropertyBinder.instance(String.class, "newPassword", CoercionConverter.instance(String.class)));
            binder.registerBinder("newPasswordConfirmation", PropertyBinder.instance(String.class, "newPasswordConfirmation", CoercionConverter.instance(String.class)));
            binder.registerBinder("forceChange", PropertyBinder.instance(Boolean.TYPE, "forceChange"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

