/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.access.DisconnectUserForm;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class DisconnectUserAction
extends BaseAction {
    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        DisconnectUserForm form = (DisconnectUserForm)((Object)context.getForm());
        long userId = form.getUserId();
        if (userId <= 0L) {
            throw new ValidationException();
        }
        try {
            String forward;
            String param;
            User user = EntityHelper.reference(User.class, userId);
            user = this.accessService.disconnect(user);
            if (user instanceof AdminUser) {
                param = "adminId";
                forward = "adminProfile";
            } else if (user instanceof MemberUser) {
                param = "memberId";
                forward = "memberProfile";
            } else if (user instanceof OperatorUser) {
                param = "operatorId";
                forward = "operatorProfile";
            } else {
                throw new IllegalStateException("Unknown user type: " + user);
            }
            context.sendMessage("disconnect.disconnected", new Object[0]);
            return ActionHelper.redirectWithParam(context.getRequest(), context.findForward(forward), param, userId);
        }
        catch (EntityNotFoundException e) {
            throw new ValidationException();
        }
        catch (NotConnectedException e) {
            return context.sendError("disconnect.error.notConnected", new Object[0]);
        }
    }
}

