/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.access;

import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.access.DisconnectUserSessionForm;
import nl.strohalm.cyclos.entities.access.Session;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class DisconnectUserSessionAction
extends BaseAction {
    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        DisconnectUserSessionForm form = (DisconnectUserSessionForm)((Object)context.getForm());
        long sessionId = form.getSessionId();
        if (sessionId <= 0L) {
            throw new ValidationException();
        }
        try {
            Session session = EntityHelper.reference(Session.class, sessionId);
            this.accessService.disconnect(session);
            context.sendMessage("disconnect.disconnected", new Object[0]);
            return context.getSuccessForward();
        }
        catch (EntityNotFoundException e) {
            throw new ValidationException();
        }
        catch (NotConnectedException e) {
            return context.sendError("disconnect.error.notConnected", new Object[0]);
        }
    }
}

